/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.store.AbiStore;
import org.tron.core.store.ContractStore;

public class MoveAbiHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private int count;
    private final ChainBaseManager chainBaseManager;

    public MoveAbiHelper(ChainBaseManager chainBaseManager) {
        this.chainBaseManager = chainBaseManager;
    }

    public void doWork() {
        long start = System.currentTimeMillis();
        logger.info("Start to move abi");
        AbiStore abiStore = this.chainBaseManager.getAbiStore();
        ContractStore contractStore = this.chainBaseManager.getContractStore();
        Iterator it = contractStore.iterator();
        it.forEachRemaining(e -> {
            ContractCapsule contractCapsule = (ContractCapsule)e.getValue();
            if (!contractCapsule.getInstance().getAbi().getEntrysList().isEmpty()) {
                abiStore.put((byte[])e.getKey(), contractCapsule.getInstance().getAbi().toByteArray());
            }
            contractStore.put((byte[])e.getKey(), contractCapsule);
            ++this.count;
            if (this.count % 100000 == 0) {
                logger.info("Doing the abi move, current count: {} {}", (Object)this.count, (Object)System.currentTimeMillis());
            }
        });
        this.chainBaseManager.getDynamicPropertiesStore().saveAbiMoveDone(1L);
        logger.info("Complete the abi move, total time: {} milliseconds, total count: {}", (Object)(System.currentTimeMillis() - start), (Object)this.count);
    }
}

