/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.accountstate.storetrie;

import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.Hash;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.db.accountstate.AccountStateEntity;
import org.tron.core.db.accountstate.TrieService;
import org.tron.core.db2.common.DB;
import org.tron.core.trie.TrieImpl;

@Component
public class AccountStateStoreTrie
extends TronStoreWithRevoking<BytesCapsule>
implements DB<byte[], BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"AccountState");
    @Autowired
    private TrieService trieService;

    @Autowired
    private AccountStateStoreTrie(@Value(value="accountTrie") String dbName) {
        super(dbName);
    }

    @PostConstruct
    public void init() {
        this.trieService.setAccountStateStoreTrie(this);
    }

    public AccountStateEntity getAccount(byte[] key) {
        return this.getAccount(key, this.trieService.getFullAccountStateRootHash());
    }

    public AccountStateEntity getAccount(byte[] key, byte[] rootHash) {
        TrieImpl trie = new TrieImpl(this, rootHash);
        byte[] value = trie.get(Hash.encodeElement((byte[])key));
        return ArrayUtils.isEmpty((byte[])value) ? null : AccountStateEntity.parse(value);
    }

    public AccountStateEntity getSolidityAccount(byte[] key) {
        return this.getAccount(key, this.trieService.getSolidityAccountStateRootHash());
    }

    public boolean isEmpty() {
        return super.size() <= 0L;
    }

    public void remove(byte[] bytes) {
        super.delete(bytes);
    }

    public BytesCapsule get(byte[] key) {
        return (BytesCapsule)super.getUnchecked(key);
    }

    public void put(byte[] key, BytesCapsule item) {
        super.put(key, (ProtoCapsule)item);
    }

    public DB<byte[], BytesCapsule> newInstance() {
        return null;
    }

    public void stat() {
    }
}

