/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.consensus;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.SignUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.consensus.Consensus;
import org.tron.consensus.base.BlockHandle;
import org.tron.consensus.base.Param;
import org.tron.consensus.base.PbftInterface;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.consensus.BlockHandleImpl;
import org.tron.core.consensus.PbftBaseImpl;
import org.tron.core.store.WitnessStore;

@Component
public class ConsensusService {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private Consensus consensus;
    @Autowired
    private WitnessStore witnessStore;
    @Autowired
    private BlockHandleImpl blockHandle;
    @Autowired
    private PbftBaseImpl pbftBaseImpl;
    private CommonParameter parameter = Args.getInstance();

    public void start() {
        Param param = Param.getInstance();
        param.setEnable(this.parameter.isWitness());
        param.setGenesisBlock(this.parameter.getGenesisBlock());
        param.setMinParticipationRate(this.parameter.getMinParticipationRate());
        param.setBlockProduceTimeoutPercent(Args.getInstance().getBlockProducedTimeOut());
        param.setNeedSyncCheck(this.parameter.isNeedSyncCheck());
        param.setAgreeNodeCount(this.parameter.getAgreeNodeCount());
        ArrayList<Param.Miner> miners = new ArrayList<Param.Miner>();
        List privateKeys = Args.getLocalWitnesses().getPrivateKeys();
        if (privateKeys.size() > 1) {
            for (String key : privateKeys) {
                byte[] privateKey = ByteArray.fromHexString((String)key);
                byte[] privateKeyAddress = SignUtils.fromPrivate((byte[])privateKey, (boolean)Args.getInstance().isECKeyCryptoEngine()).getAddress();
                WitnessCapsule witnessCapsule = this.witnessStore.get(privateKeyAddress);
                if (null == witnessCapsule) {
                    logger.warn("Witness {} is not in witnessStore.", (Object)Hex.toHexString((byte[])privateKeyAddress));
                }
                Param param2 = param;
                param2.getClass();
                Param.Miner miner = new Param.Miner(param2, privateKey, ByteString.copyFrom((byte[])privateKeyAddress), ByteString.copyFrom((byte[])privateKeyAddress));
                miners.add(miner);
                logger.info("Add witness: {}, size: {}", (Object)Hex.toHexString((byte[])privateKeyAddress), (Object)miners.size());
            }
        } else {
            byte[] privateKey = ByteArray.fromHexString((String)Args.getLocalWitnesses().getPrivateKey());
            byte[] privateKeyAddress = SignUtils.fromPrivate((byte[])privateKey, (boolean)Args.getInstance().isECKeyCryptoEngine()).getAddress();
            byte[] witnessAddress = Args.getLocalWitnesses().getWitnessAccountAddress(Args.getInstance().isECKeyCryptoEngine());
            WitnessCapsule witnessCapsule = this.witnessStore.get(witnessAddress);
            if (null == witnessCapsule) {
                logger.warn("Witness {} is not in witnessStore.", (Object)Hex.toHexString((byte[])witnessAddress));
            }
            Param param3 = param;
            param3.getClass();
            Param.Miner miner = new Param.Miner(param3, privateKey, ByteString.copyFrom((byte[])privateKeyAddress), ByteString.copyFrom((byte[])witnessAddress));
            miners.add(miner);
        }
        param.setMiners(miners);
        param.setBlockHandle((BlockHandle)this.blockHandle);
        param.setPbftInterface((PbftInterface)this.pbftBaseImpl);
        this.consensus.start(param);
        logger.info("consensus service start success");
    }

    public void stop() {
        logger.info("consensus service closed start.");
        this.consensus.stop();
        logger.info("consensus service closed successfully.");
    }
}

