/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.typesafe.config.Config;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.config.Configuration;
import org.tron.core.config.args.Args;
import org.tron.core.net.TronNetService;

@Component
public class DynamicArgs {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private final CommonParameter parameter = Args.getInstance();
    private long lastModified = 0L;
    private ScheduledExecutorService reloadExecutor = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        if (this.parameter.isDynamicConfigEnable()) {
            logger.info("Start the dynamic loading configuration service");
            long checkInterval = this.parameter.getDynamicConfigCheckInterval();
            File config = this.getConfigFile();
            if (config == null) {
                return;
            }
            this.lastModified = config.lastModified();
            this.reloadExecutor.scheduleWithFixedDelay(() -> {
                try {
                    this.run();
                }
                catch (Exception e) {
                    logger.error("Exception caught when reloading configuration", (Throwable)e);
                }
            }, 10L, checkInterval, TimeUnit.SECONDS);
        }
    }

    public void run() {
        long lastModifiedTime;
        File config = this.getConfigFile();
        if (config != null && (lastModifiedTime = config.lastModified()) > this.lastModified) {
            this.reload();
            this.lastModified = lastModifiedTime;
        }
    }

    private File getConfigFile() {
        String confFilePath = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.parameter.getShellConfFileName()}) ? this.parameter.getShellConfFileName() : "config.conf";
        File confFile = new File(confFilePath);
        if (!confFile.exists()) {
            logger.warn("Configuration path is required! No such file {}", (Object)confFile);
            return null;
        }
        return confFile;
    }

    public void reload() {
        logger.debug("Reloading ... ");
        Config config = Configuration.getByFileName((String)this.parameter.getShellConfFileName(), (String)"config.conf");
        this.updateActiveNodes(config);
        this.updateTrustNodes(config);
    }

    private void updateActiveNodes(Config config) {
        List<InetSocketAddress> newActiveNodes = Args.getInetSocketAddress(config, "node.active", true);
        this.parameter.setActiveNodes(newActiveNodes);
        List activeNodes = TronNetService.getP2pConfig().getActiveNodes();
        activeNodes.clear();
        activeNodes.addAll(newActiveNodes);
        logger.debug("p2p active nodes : {}", (Object)TronNetService.getP2pConfig().getActiveNodes().toString());
    }

    private void updateTrustNodes(Config config) {
        List<InetAddress> newPassiveNodes = Args.getInetAddress(config, "node.passive");
        this.parameter.setPassiveNodes(newPassiveNodes);
        List trustNodes = TronNetService.getP2pConfig().getTrustNodes();
        trustNodes.clear();
        trustNodes.addAll(newPassiveNodes);
        this.parameter.getActiveNodes().forEach(n -> trustNodes.add(n.getAddress()));
        this.parameter.getFastForwardNodes().forEach(f -> trustNodes.add(f.getAddress()));
        logger.debug("p2p trust nodes : {}", (Object)TronNetService.getP2pConfig().getTrustNodes().toString());
    }

    public void close() {
        logger.info("Closing the dynamic loading configuration service");
        this.reloadExecutor.shutdown();
    }
}

