/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.contract.ShieldContract;

public class SpendDescriptionCapsule
implements ProtoCapsule<ShieldContract.SpendDescription> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private ShieldContract.SpendDescription spendDescription;

    public SpendDescriptionCapsule() {
        this.spendDescription = ShieldContract.SpendDescription.newBuilder().build();
    }

    public SpendDescriptionCapsule(ShieldContract.SpendDescription spendDescription) {
        this.spendDescription = spendDescription;
    }

    public SpendDescriptionCapsule(byte[] data) {
        try {
            this.spendDescription = ShieldContract.SpendDescription.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public SpendDescriptionCapsule(ByteString cv, ByteString anchor, ByteString nf, ByteString rk, ByteString zkproof, ByteString sig) {
        this.spendDescription = ShieldContract.SpendDescription.newBuilder().setValueCommitment(cv).setAnchor(anchor).setNullifier(nf).setRk(rk).setZkproof(zkproof).setSpendAuthoritySignature(sig).build();
    }

    public ByteString getValueCommitment() {
        return this.spendDescription.getValueCommitment();
    }

    public void setValueCommitment(byte[] bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setValueCommitment(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setValueCommitment(ByteString bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setValueCommitment(bytes).build();
    }

    public ByteString getAnchor() {
        return this.spendDescription.getAnchor();
    }

    public void setAnchor(byte[] bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setAnchor(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setAnchor(ByteString bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setAnchor(bytes).build();
    }

    public ByteString getNullifier() {
        return this.spendDescription.getNullifier();
    }

    public void setNullifier(byte[] bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setNullifier(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setNullifier(ByteString bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setNullifier(bytes).build();
    }

    public ByteString getRk() {
        return this.spendDescription.getRk();
    }

    public void setRk(byte[] bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setRk(ByteString.copyFrom((byte[])bytes)).build();
    }

    public void setRk(ByteString bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setRk(bytes).build();
    }

    public ByteString getZkproof() {
        return this.spendDescription.getZkproof();
    }

    public void setZkproof(byte[] proof) {
        ByteString proof1 = ByteString.copyFrom((byte[])proof);
        this.spendDescription = this.spendDescription.toBuilder().setZkproof(proof1).build();
    }

    public void setZkproof(ByteString proof) {
        this.spendDescription = this.spendDescription.toBuilder().setZkproof(proof).build();
    }

    public ByteString getSpendAuthoritySignature() {
        return this.spendDescription.getSpendAuthoritySignature();
    }

    public void setSpendAuthoritySignature(ByteString bytes) {
        this.spendDescription = this.spendDescription.toBuilder().setSpendAuthoritySignature(bytes).build();
    }

    public byte[] getData() {
        return this.spendDescription.toByteArray();
    }

    public ShieldContract.SpendDescription getInstance() {
        return this.spendDescription;
    }
}

