/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.logsfilter.capsule;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.Hash;
import org.tron.common.logsfilter.ContractEventParserAbi;
import org.tron.common.logsfilter.EventPluginLoader;
import org.tron.common.logsfilter.capsule.RawData;
import org.tron.common.logsfilter.capsule.TriggerCapsule;
import org.tron.common.logsfilter.trigger.ContractEventTrigger;
import org.tron.common.logsfilter.trigger.ContractLogTrigger;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.core.config.args.Args;
import org.tron.protos.contract.SmartContractOuterClass;

public class ContractTriggerCapsule
extends TriggerCapsule {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private ContractTrigger contractTrigger;

    public ContractTriggerCapsule(ContractTrigger contractTrigger) {
        this.contractTrigger = contractTrigger;
    }

    public void setLatestSolidifiedBlockNumber(long latestSolidifiedBlockNumber) {
        this.contractTrigger.setLatestSolidifiedBlockNumber(latestSolidifiedBlockNumber);
    }

    public void setBlockHash(String blockHash) {
        this.contractTrigger.setBlockHash(blockHash);
    }

    @Override
    public void processTrigger() {
        ContractEventTrigger event;
        boolean isEvent = false;
        LogInfo logInfo = this.contractTrigger.getLogInfo();
        SmartContractOuterClass.SmartContract.ABI abi = this.contractTrigger.getAbi();
        List topics = logInfo.getTopics();
        String eventSignature = "";
        String eventSignatureFull = "fallback()";
        String entryName = "";
        SmartContractOuterClass.SmartContract.ABI.Entry eventEntry = null;
        if (abi != null && abi.getEntrysCount() > 0 && topics != null && !topics.isEmpty() && !ArrayUtils.isEmpty((byte[])((DataWord)topics.get(0)).getData()) && Args.getInstance().getStorage().isContractParseSwitch()) {
            String logHash = ((DataWord)topics.get(0)).toString();
            for (SmartContractOuterClass.SmartContract.ABI.Entry entry : abi.getEntrysList()) {
                if (entry.getType() != SmartContractOuterClass.SmartContract.ABI.Entry.EntryType.Event || entry.getAnonymous()) continue;
                String signature = entry.getName() + "(";
                String signatureFull = entry.getName() + "(";
                StringBuilder signBuilder = new StringBuilder();
                StringBuilder signFullBuilder = new StringBuilder();
                for (SmartContractOuterClass.SmartContract.ABI.Entry.Param param : entry.getInputsList()) {
                    if (signBuilder.length() > 0) {
                        signBuilder.append(",");
                        signFullBuilder.append(",");
                    }
                    String type = param.getType();
                    String name = param.getName();
                    signBuilder.append(type);
                    signFullBuilder.append(type);
                    if (!StringUtils.isNotNullOrEmpty((String)name)) continue;
                    signFullBuilder.append(" ").append(name);
                }
                signature = signature + signBuilder.toString() + ")";
                signatureFull = signatureFull + signFullBuilder.toString() + ")";
                String sha3 = Hex.toHexString((byte[])Hash.sha3((byte[])signature.getBytes()));
                if (!sha3.equals(logHash)) continue;
                eventSignature = signature;
                eventSignatureFull = signatureFull;
                entryName = entry.getName();
                eventEntry = entry;
                isEvent = true;
                break;
            }
        }
        if (isEvent) {
            event = new ContractEventTrigger();
            event.setEventSignature(eventSignature);
            event.setEventSignatureFull(eventSignatureFull);
            event.setEventName(entryName);
            List topicList = logInfo.getClonedTopics();
            byte[] data = logInfo.getClonedData();
            event.setTopicMap(ContractEventParserAbi.parseTopics(topicList, eventEntry));
            event.setDataMap(ContractEventParserAbi.parseEventData(data, topicList, eventEntry));
        } else {
            event = new ContractLogTrigger();
            ((ContractLogTrigger)event).setTopicList(logInfo.getHexTopics());
            ((ContractLogTrigger)event).setData(logInfo.getHexData());
        }
        RawData rawData = new RawData(logInfo.getAddress(), logInfo.getTopics(), logInfo.getData());
        event.setRawData(rawData);
        event.setLatestSolidifiedBlockNumber(this.contractTrigger.getLatestSolidifiedBlockNumber());
        event.setRemoved(this.contractTrigger.isRemoved());
        event.setUniqueId(this.contractTrigger.getUniqueId());
        event.setTransactionId(this.contractTrigger.getTransactionId());
        event.setContractAddress(this.contractTrigger.getContractAddress());
        event.setOriginAddress(this.contractTrigger.getOriginAddress());
        event.setCallerAddress("");
        event.setCreatorAddress(this.contractTrigger.getCreatorAddress());
        event.setBlockNumber(this.contractTrigger.getBlockNumber());
        event.setTimeStamp(this.contractTrigger.getTimeStamp());
        event.setBlockHash(this.contractTrigger.getBlockHash());
        if (EventPluginLoader.matchFilter(this.contractTrigger)) {
            if (isEvent) {
                boolean result;
                if (EventPluginLoader.getInstance().isContractEventTriggerEnable()) {
                    EventPluginLoader.getInstance().postContractEventTrigger(event);
                }
                if (EventPluginLoader.getInstance().isSolidityEventTriggerEnable() && !(result = Args.getSolidityContractEventTriggerMap().computeIfAbsent(event.getBlockNumber(), listBlk -> new LinkedBlockingQueue()).offer(event))) {
                    logger.info("too many triggers, solidity event trigger lost: {}", (Object)event.getUniqueId());
                }
                if (EventPluginLoader.getInstance().isContractLogTriggerEnable() && EventPluginLoader.getInstance().isContractLogTriggerRedundancy() || EventPluginLoader.getInstance().isSolidityLogTriggerEnable() && EventPluginLoader.getInstance().isSolidityLogTriggerRedundancy()) {
                    boolean result2;
                    ContractLogTrigger logTrigger = new ContractLogTrigger(event);
                    logTrigger.setTopicList(logInfo.getHexTopics());
                    logTrigger.setData(logInfo.getHexData());
                    if (EventPluginLoader.getInstance().isContractLogTriggerRedundancy()) {
                        EventPluginLoader.getInstance().postContractLogTrigger(logTrigger);
                    }
                    if (EventPluginLoader.getInstance().isSolidityLogTriggerRedundancy() && !(result2 = Args.getSolidityContractLogTriggerMap().computeIfAbsent(event.getBlockNumber(), listBlk -> new LinkedBlockingQueue()).offer(logTrigger))) {
                        logger.info("too many triggers, solidity log trigger lost: {}", (Object)logTrigger.getUniqueId());
                    }
                }
            } else {
                boolean result;
                if (EventPluginLoader.getInstance().isContractLogTriggerEnable()) {
                    EventPluginLoader.getInstance().postContractLogTrigger((ContractLogTrigger)event);
                }
                if (EventPluginLoader.getInstance().isSolidityLogTriggerEnable() && !(result = Args.getSolidityContractLogTriggerMap().computeIfAbsent(event.getBlockNumber(), listBlk -> new LinkedBlockingQueue()).offer((ContractLogTrigger)event))) {
                    logger.info("too many triggers, solidity log trigger lost: {}", (Object)event.getUniqueId());
                }
            }
        }
    }

    public ContractTrigger getContractTrigger() {
        return this.contractTrigger;
    }

    public void setContractTrigger(ContractTrigger contractTrigger) {
        this.contractTrigger = contractTrigger;
    }
}

