/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.backup.socket;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.backup.socket.EventHandler;
import org.tron.common.backup.socket.UdpEvent;

public class MessageHandler
extends SimpleChannelInboundHandler<UdpEvent>
implements Consumer<UdpEvent> {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private Channel channel;
    private EventHandler eventHandler;

    public MessageHandler(NioDatagramChannel channel, EventHandler eventHandler) {
        this.channel = channel;
        this.eventHandler = eventHandler;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.eventHandler.channelActivated();
    }

    public void channelRead0(ChannelHandlerContext ctx, UdpEvent udpEvent) {
        logger.debug("rcv udp msg type {}, len {} from {} ", new Object[]{udpEvent.getMessage().getType(), udpEvent.getMessage().getSendData().length, udpEvent.getAddress()});
        this.eventHandler.handleEvent(udpEvent);
    }

    @Override
    public void accept(UdpEvent udpEvent) {
        logger.debug("send udp msg type {}, len {} to {} ", new Object[]{udpEvent.getMessage().getType(), udpEvent.getMessage().getSendData().length, udpEvent.getAddress()});
        InetSocketAddress address = udpEvent.getAddress();
        this.sendPacket(udpEvent.getMessage().getSendData(), address);
    }

    void sendPacket(byte[] wire, InetSocketAddress address) {
        DatagramPacket packet = new DatagramPacket(Unpooled.copiedBuffer((byte[])wire), address);
        this.channel.write((Object)packet);
        this.channel.flush();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.warn("Exception caught in udp message handler, {} {}", (Object)ctx.channel().remoteAddress(), (Object)cause.getMessage());
        ctx.close();
    }
}

