/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.backup.message;

import org.apache.commons.lang3.ArrayUtils;
import org.tron.common.backup.message.KeepAliveMessage;
import org.tron.common.backup.message.UdpMessageTypeEnum;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.exception.P2pException;
import org.tron.p2p.discover.Node;
import org.tron.protos.Discover;

public abstract class Message {
    protected UdpMessageTypeEnum type;
    protected byte[] data;

    public Message(UdpMessageTypeEnum type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public static Node getNode(Discover.Endpoint endpoint) {
        Node node = new Node(endpoint.getNodeId().toByteArray(), ByteArray.toStr((byte[])endpoint.getAddress().toByteArray()), ByteArray.toStr((byte[])endpoint.getAddressIpv6().toByteArray()), endpoint.getPort());
        return node;
    }

    public static Message parse(byte[] encode) throws Exception {
        byte type = encode[0];
        byte[] data = ArrayUtils.subarray((byte[])encode, (int)1, (int)encode.length);
        switch (UdpMessageTypeEnum.fromByte(type)) {
            case BACKUP_KEEP_ALIVE: {
                return new KeepAliveMessage(data);
            }
        }
        throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "type=" + type);
    }

    public UdpMessageTypeEnum getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getSendData() {
        return ArrayUtils.add((byte[])this.data, (int)0, (byte)this.type.getType());
    }

    public Sha256Hash getMessageId() {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])this.getData());
    }

    public abstract Node getFrom();

    public abstract long getTimestamp();

    public String toString() {
        return "[Message Type: " + (Object)((Object)this.getType()) + ", len: " + (this.data == null ? 0 : this.data.length) + "]";
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getMessageId().hashCode();
    }
}

