/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.application;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;

public class ServiceContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private ArrayList<Service> services = new ArrayList();

    public void add(Service service) {
        this.services.add(service);
    }

    public void init() {
        for (Service service : this.services) {
            logger.debug("Initing {}.", (Object)service.getClass().getSimpleName());
            service.init();
        }
    }

    public void init(CommonParameter parameter) {
        for (Service service : this.services) {
            logger.debug("Initing {}.", (Object)service.getClass().getSimpleName());
            service.init(parameter);
        }
    }

    public void start() {
        logger.debug("Starting services.");
        for (Service service : this.services) {
            logger.debug("Starting {}.", (Object)service.getClass().getSimpleName());
            service.start();
        }
    }

    public void stop() {
        for (Service service : this.services) {
            logger.debug("Stopping {}.", (Object)service.getClass().getSimpleName());
            service.stop();
        }
    }
}

