/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.application;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.application.Application;
import org.tron.common.application.Service;
import org.tron.common.application.ServiceContainer;
import org.tron.common.logsfilter.EventPluginLoader;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.ChainBaseManager;
import org.tron.core.config.args.Args;
import org.tron.core.config.args.DynamicArgs;
import org.tron.core.consensus.ConsensusService;
import org.tron.core.db.Manager;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.net.TronNetService;
import org.tron.program.FullNode;

@Component
public class ApplicationImpl
implements Application {
    private static final Logger logger = LoggerFactory.getLogger((String)"app");
    private ServiceContainer services;
    @Autowired
    private TronNetService tronNetService;
    @Autowired
    private Manager dbManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private ConsensusService consensusService;
    @Autowired
    private DynamicArgs dynamicArgs;

    @Override
    public void setOptions(Args args) {
    }

    @Override
    @Autowired
    public void init(CommonParameter parameter) {
        this.services = new ServiceContainer();
    }

    @Override
    public void addService(Service service) {
        this.services.add(service);
    }

    @Override
    public void initServices(CommonParameter parameter) {
        this.services.init(parameter);
    }

    @Override
    public void startup() {
        if (!Args.getInstance().isSolidityNode() && !Args.getInstance().isP2pDisable()) {
            this.tronNetService.start();
        }
        this.consensusService.start();
        MetricsUtil.init();
        this.dynamicArgs.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        logger.info("******** start to shutdown ********");
        if (!Args.getInstance().isSolidityNode() && !Args.getInstance().p2pDisable) {
            this.tronNetService.close();
        }
        this.consensusService.stop();
        RevokingDatabase revokingDatabase = this.dbManager.getRevokingStore();
        synchronized (revokingDatabase) {
            this.dbManager.getSession().reset();
            this.closeRevokingStore();
            this.closeAllStore();
        }
        this.dbManager.stopRePushThread();
        this.dbManager.stopRePushTriggerThread();
        EventPluginLoader.getInstance().stopPlugin();
        this.dbManager.stopFilterProcessThread();
        this.dynamicArgs.close();
        logger.info("******** end to shutdown ********");
        FullNode.shutDownSign = true;
    }

    @Override
    public void startServices() {
        this.services.start();
    }

    @Override
    public void shutdownServices() {
        this.services.stop();
    }

    @Override
    public Manager getDbManager() {
        return this.dbManager;
    }

    @Override
    public ChainBaseManager getChainBaseManager() {
        return this.chainBaseManager;
    }

    private void closeRevokingStore() {
        logger.info("******** start to closeRevokingStore ********");
        this.dbManager.getRevokingStore().shutdown();
    }

    private void closeAllStore() {
        this.dbManager.closeAllStore();
    }
}

