/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.math.ec.ECPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.jce.TronCastleProvider;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.DecodeUtil;

public class Hash {
    private static final Logger logger = LoggerFactory.getLogger((String)"crypto");
    public static final byte[] EMPTY_TRIE_HASH;
    private static final Provider CRYPTO_PROVIDER;
    private static final String HASH_256_ALGORITHM_NAME;
    private static final String HASH_512_ALGORITHM_NAME;
    private static final String ALGORITHM_NOT_FOUND = "Can't find such algorithm";
    private static final int OFFSET_SHORT_ITEM = 128;
    private static final int OFFSET_LONG_ITEM = 183;
    private static final int SIZE_THRESHOLD = 56;

    public static byte[] sha3(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(ALGORITHM_NOT_FOUND, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input1, byte[] input2) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input1, 0, input1.length);
            digest.update(input2, 0, input2.length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(ALGORITHM_NOT_FOUND, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha3(byte[] input, int start, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance(HASH_256_ALGORITHM_NAME, CRYPTO_PROVIDER);
            digest.update(input, start, length);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(ALGORITHM_NOT_FOUND, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] encodeElement(byte[] srcData) {
        int tmpLength;
        if (ByteUtil.isNullOrZeroArray((byte[])srcData)) {
            return new byte[]{-128};
        }
        if (ByteUtil.isSingleZero((byte[])srcData)) {
            return srcData;
        }
        if (srcData.length == 1 && (srcData[0] & 0xFF) < 128) {
            return srcData;
        }
        if (srcData.length < 56) {
            byte length = (byte)(128 + srcData.length);
            byte[] data = Arrays.copyOf(srcData, srcData.length + 1);
            System.arraycopy(data, 0, data, 1, srcData.length);
            data[0] = length;
            return data;
        }
        int lengthOfLength = 0;
        for (tmpLength = srcData.length; tmpLength != 0; tmpLength >>= 8) {
            lengthOfLength = (byte)(lengthOfLength + 1);
        }
        byte[] data = new byte[1 + lengthOfLength + srcData.length];
        data[0] = (byte)(183 + lengthOfLength);
        tmpLength = srcData.length;
        for (int i = lengthOfLength; i > 0; --i) {
            data[i] = (byte)(tmpLength & 0xFF);
            tmpLength >>= 8;
        }
        System.arraycopy(srcData, 0, data, 1 + lengthOfLength, srcData.length);
        return data;
    }

    public static byte[] computeAddress(ECPoint pubPoint) {
        return Hash.computeAddress(pubPoint.getEncoded(false));
    }

    public static byte[] computeAddress(byte[] pubBytes) {
        return Hash.sha3omit12(Arrays.copyOfRange(pubBytes, 1, pubBytes.length));
    }

    public static byte[] sha3omit12(byte[] input) {
        byte[] hash = Hash.sha3(input);
        byte[] address = Arrays.copyOfRange(hash, 11, hash.length);
        address[0] = DecodeUtil.addressPreFixByte;
        return address;
    }

    public static byte[] ripemd160(byte[] data) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        digest.update(data, 0, data.length);
        digest.doFinal(resBuf, 0);
        return resBuf;
    }

    static {
        Security.addProvider(TronCastleProvider.getInstance());
        CRYPTO_PROVIDER = Security.getProvider("BC");
        HASH_256_ALGORITHM_NAME = "TRON-KECCAK-256";
        HASH_512_ALGORITHM_NAME = "TRON-KECCAK-512";
        EMPTY_TRIE_HASH = Hash.sha3(Hash.encodeElement(ByteUtil.EMPTY_BYTE_ARRAY));
    }
}

