/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.pbft;

import com.google.protobuf.ByteString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.PbftSignCapsule;
import org.tron.protos.Protocol;

@Component
public class PbftMessageAction {
    private static final Logger logger = LoggerFactory.getLogger((String)"pbft");
    @Autowired
    private ChainBaseManager chainBaseManager;

    public void action(PbftMessage message, List<ByteString> dataSignList) {
        switch (message.getDataType()) {
            case BLOCK: {
                long blockNum = message.getNumber();
                this.chainBaseManager.getCommonDataBase().saveLatestPbftBlockNum(blockNum);
                Protocol.PBFTMessage.Raw raw2 = message.getPbftMessage().getRawData();
                this.chainBaseManager.getPbftSignDataStore().putBlockSignData(blockNum, new PbftSignCapsule(raw2.toByteString(), dataSignList));
                logger.info("commit msg block num is:{}", (Object)blockNum);
                break;
            }
            case SRL: {
                try {
                    Protocol.PBFTMessage.Raw raw3 = message.getPbftMessage().getRawData();
                    this.chainBaseManager.getPbftSignDataStore().putSrSignData(message.getEpoch(), new PbftSignCapsule(raw3.toByteString(), dataSignList));
                    logger.info("sr commit msg :{}, epoch:{}", (Object)message.getNumber(), (Object)message.getEpoch());
                }
                catch (Exception e) {
                    logger.error("process the sr list error!", (Throwable)e);
                }
                break;
            }
        }
    }
}

