/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;
import org.tron.common.utils.StringUtil;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.dpos.DposSlot;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.WitnessCapsule;

@Component
public class StatisticManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    @Autowired
    private DposSlot dposSlot;

    public void applyBlock(BlockCapsule blockCapsule) {
        long blockNum = blockCapsule.getNum();
        long blockTime = blockCapsule.getTimeStamp();
        byte[] blockWitness = blockCapsule.getWitnessAddress().toByteArray();
        WitnessCapsule wc = this.consensusDelegate.getWitness(blockWitness);
        wc.setTotalProduced(wc.getTotalProduced() + 1L);
        Metrics.counterInc((String)"tron:miner", (double)1.0, (String[])new String[]{StringUtil.encode58Check((byte[])blockWitness), "success"});
        wc.setLatestBlockNum(blockNum);
        wc.setLatestSlotNum(this.dposSlot.getAbSlot(blockTime));
        this.consensusDelegate.saveWitness(wc);
        long slot = 1L;
        if (blockNum != 1L) {
            slot = this.dposSlot.getSlot(blockTime);
        }
        int i = 1;
        while ((long)i < slot) {
            byte[] witness = this.dposSlot.getScheduledWitness(i).toByteArray();
            wc = this.consensusDelegate.getWitness(witness);
            wc.setTotalMissed(wc.getTotalMissed() + 1L);
            Metrics.counterInc((String)"tron:miner", (double)1.0, (String[])new String[]{StringUtil.encode58Check((byte[])wc.getAddress().toByteArray()), "miss"});
            this.consensusDelegate.saveWitness(wc);
            logger.info("Current block: {}, witness: {}, totalMissed: {}", new Object[]{blockNum, StringUtil.encode58Check((byte[])wc.getAddress().toByteArray()), wc.getTotalMissed()});
            this.consensusDelegate.applyBlock(false);
            ++i;
        }
        this.consensusDelegate.applyBlock(true);
    }
}

