/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus.dpos;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.WalletUtil;
import org.tron.consensus.ConsensusDelegate;
import org.tron.consensus.dpos.DposService;
import org.tron.consensus.dpos.IncentiveManager;
import org.tron.consensus.pbft.PbftManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.VotesStore;

@Component
public class MaintenanceManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private ConsensusDelegate consensusDelegate;
    @Autowired
    private IncentiveManager incentiveManager;
    private DposService dposService;
    private PbftManager pbftManager;
    private final List<ByteString> beforeWitness = new ArrayList<ByteString>();
    private final List<ByteString> currentWitness = new ArrayList<ByteString>();
    private long beforeMaintenanceTime;

    public void init() {
        this.currentWitness.addAll(this.consensusDelegate.getActiveWitnesses());
    }

    public void applyBlock(BlockCapsule blockCapsule) {
        boolean flag;
        long blockNum = blockCapsule.getNum();
        long blockTime = blockCapsule.getTimeStamp();
        long nextMaintenanceTime = this.consensusDelegate.getNextMaintenanceTime();
        boolean bl = flag = this.consensusDelegate.getNextMaintenanceTime() <= blockTime;
        if (flag) {
            if (blockNum != 1L) {
                this.updateWitnessValue(this.beforeWitness);
                this.beforeMaintenanceTime = nextMaintenanceTime;
                this.doMaintenance();
                this.updateWitnessValue(this.currentWitness);
            }
            this.consensusDelegate.updateNextMaintenanceTime(blockTime);
            if (blockNum != 1L) {
                this.pbftManager.srPrePrepare(blockCapsule, this.currentWitness, this.consensusDelegate.getNextMaintenanceTime());
            }
        }
        this.consensusDelegate.saveStateFlag(flag ? 1 : 0);
        if (blockNum == 1L) {
            nextMaintenanceTime = this.consensusDelegate.getNextMaintenanceTime();
        }
        this.pbftManager.blockPrePrepare(blockCapsule, nextMaintenanceTime);
    }

    private void updateWitnessValue(List<ByteString> srList) {
        srList.clear();
        srList.addAll(this.consensusDelegate.getActiveWitnesses());
    }

    public void doMaintenance() {
        Map<ByteString, Long> countWitness;
        VotesStore votesStore = this.consensusDelegate.getVotesStore();
        this.tryRemoveThePowerOfTheGr();
        DynamicPropertiesStore dynamicPropertiesStore = this.consensusDelegate.getDynamicPropertiesStore();
        DelegationStore delegationStore = this.consensusDelegate.getDelegationStore();
        if (dynamicPropertiesStore.useNewRewardAlgorithm()) {
            long curCycle = dynamicPropertiesStore.getCurrentCycleNumber();
            this.consensusDelegate.getAllWitnesses().forEach(witness -> delegationStore.accumulateWitnessVi(curCycle, witness.createDbKey(), witness.getVoteCount()));
        }
        if (!(countWitness = this.countVote(votesStore)).isEmpty()) {
            List<ByteString> currentWits = this.consensusDelegate.getActiveWitnesses();
            ArrayList<ByteString> newWitnessAddressList = new ArrayList<ByteString>();
            this.consensusDelegate.getAllWitnesses().forEach(witnessCapsule -> newWitnessAddressList.add(witnessCapsule.getAddress()));
            countWitness.forEach((address, voteCount) -> {
                byte[] witnessAddress = address.toByteArray();
                WitnessCapsule witnessCapsule = this.consensusDelegate.getWitness(witnessAddress);
                if (witnessCapsule == null) {
                    logger.warn("Witness capsule is null. address is {}", (Object)Hex.toHexString((byte[])witnessAddress));
                    return;
                }
                AccountCapsule account = this.consensusDelegate.getAccount(witnessAddress);
                if (account == null) {
                    logger.warn("Witness account is null. address is {}", (Object)Hex.toHexString((byte[])witnessAddress));
                    return;
                }
                witnessCapsule.setVoteCount(witnessCapsule.getVoteCount() + voteCount);
                this.consensusDelegate.saveWitness(witnessCapsule);
                logger.info("address is {} , countVote is {}", (Object)witnessCapsule.createReadableString(), (Object)witnessCapsule.getVoteCount());
            });
            this.dposService.updateWitness(newWitnessAddressList);
            this.incentiveManager.reward(newWitnessAddressList);
            List<ByteString> newWits = this.consensusDelegate.getActiveWitnesses();
            if (!CollectionUtils.isEqualCollection(currentWits, newWits)) {
                currentWits.forEach(address -> {
                    WitnessCapsule witnessCapsule = this.consensusDelegate.getWitness(address.toByteArray());
                    witnessCapsule.setIsJobs(false);
                    this.consensusDelegate.saveWitness(witnessCapsule);
                });
                newWits.forEach(address -> {
                    WitnessCapsule witnessCapsule = this.consensusDelegate.getWitness(address.toByteArray());
                    witnessCapsule.setIsJobs(true);
                    this.consensusDelegate.saveWitness(witnessCapsule);
                });
            }
            logger.info("Update witness success. \nbefore: {} \nafter: {}", (Object)WalletUtil.getAddressStringList(currentWits), (Object)WalletUtil.getAddressStringList(newWits));
        }
        if (dynamicPropertiesStore.allowChangeDelegation()) {
            long nextCycle = dynamicPropertiesStore.getCurrentCycleNumber() + 1L;
            dynamicPropertiesStore.saveCurrentCycleNumber(nextCycle);
            List<WitnessCapsule> all = this.consensusDelegate.getAllWitnesses();
            all.forEach(witness -> {
                delegationStore.setBrokerage(nextCycle, witness.createDbKey(), delegationStore.getBrokerage(witness.createDbKey()));
                delegationStore.setWitnessVote(nextCycle, witness.createDbKey(), witness.getVoteCount());
            });
            this.consensusDelegate.updateWitnessStandby(all);
        }
    }

    private Map<ByteString, Long> countVote(VotesStore votesStore) {
        HashMap countWitness = Maps.newHashMap();
        Iterator dbIterator = votesStore.iterator();
        long sizeCount = 0L;
        while (dbIterator.hasNext()) {
            Map.Entry next = (Map.Entry)dbIterator.next();
            VotesCapsule votes = (VotesCapsule)next.getValue();
            votes.getOldVotes().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                long voteCount = vote.getVoteCount();
                if (countWitness.containsKey(voteAddress)) {
                    countWitness.put(voteAddress, (Long)countWitness.get(voteAddress) - voteCount);
                } else {
                    countWitness.put(voteAddress, -voteCount);
                }
            });
            votes.getNewVotes().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                long voteCount = vote.getVoteCount();
                if (countWitness.containsKey(voteAddress)) {
                    countWitness.put(voteAddress, (Long)countWitness.get(voteAddress) + voteCount);
                } else {
                    countWitness.put(voteAddress, voteCount);
                }
            });
            ++sizeCount;
            votesStore.delete((byte[])next.getKey());
        }
        logger.info("There is {} new votes in this epoch", (Object)sizeCount);
        return countWitness;
    }

    private void tryRemoveThePowerOfTheGr() {
        if (this.consensusDelegate.getRemoveThePowerOfTheGr() != 1L) {
            return;
        }
        this.dposService.getGenesisBlock().getWitnesses().forEach(witness -> {
            WitnessCapsule witnessCapsule = this.consensusDelegate.getWitness(witness.getAddress());
            witnessCapsule.setVoteCount(witnessCapsule.getVoteCount() - witness.getVoteCount());
            this.consensusDelegate.saveWitness(witnessCapsule);
        });
        this.consensusDelegate.saveRemoveThePowerOfTheGr(-1L);
    }

    public void setDposService(DposService dposService) {
        this.dposService = dposService;
    }

    public void setPbftManager(PbftManager pbftManager) {
        this.pbftManager = pbftManager;
    }

    public List<ByteString> getBeforeWitness() {
        return this.beforeWitness;
    }

    public List<ByteString> getCurrentWitness() {
        return this.currentWitness;
    }

    public long getBeforeMaintenanceTime() {
        return this.beforeMaintenanceTime;
    }
}

