/*
 * Decompiled with CFR 0.152.
 */
package org.tron.consensus;

import com.google.protobuf.ByteString;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.VotesStore;
import org.tron.core.store.WitnessScheduleStore;
import org.tron.core.store.WitnessStore;

@Component
public class ConsensusDelegate {
    private static final Logger logger = LoggerFactory.getLogger((String)"consensus");
    @Autowired
    private DynamicPropertiesStore dynamicPropertiesStore;
    @Autowired
    private DelegationStore delegationStore;
    @Autowired
    private AccountStore accountStore;
    @Autowired
    private WitnessStore witnessStore;
    @Autowired
    private WitnessScheduleStore witnessScheduleStore;
    @Autowired
    private VotesStore votesStore;

    public DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.dynamicPropertiesStore;
    }

    public DelegationStore getDelegationStore() {
        return this.delegationStore;
    }

    public VotesStore getVotesStore() {
        return this.votesStore;
    }

    public int calculateFilledSlotsCount() {
        return this.dynamicPropertiesStore.calculateFilledSlotsCount();
    }

    public void saveRemoveThePowerOfTheGr(long rate) {
        this.dynamicPropertiesStore.saveRemoveThePowerOfTheGr(rate);
    }

    public long getRemoveThePowerOfTheGr() {
        return this.dynamicPropertiesStore.getRemoveThePowerOfTheGr();
    }

    public long getWitnessStandbyAllowance() {
        return this.dynamicPropertiesStore.getWitnessStandbyAllowance();
    }

    public long getLatestBlockHeaderTimestamp() {
        return this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
    }

    public long getLatestBlockHeaderNumber() {
        return this.dynamicPropertiesStore.getLatestBlockHeaderNumber();
    }

    public boolean lastHeadBlockIsMaintenance() {
        return this.dynamicPropertiesStore.getStateFlag() == 1;
    }

    public long getMaintenanceSkipSlots() {
        return this.dynamicPropertiesStore.getMaintenanceSkipSlots();
    }

    public void saveActiveWitnesses(List<ByteString> addresses) {
        this.witnessScheduleStore.saveActiveWitnesses(addresses);
    }

    public List<ByteString> getActiveWitnesses() {
        return this.witnessScheduleStore.getActiveWitnesses();
    }

    public AccountCapsule getAccount(byte[] address) {
        return this.accountStore.get(address);
    }

    public void saveAccount(AccountCapsule accountCapsule) {
        this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
    }

    public WitnessCapsule getWitness(byte[] address) {
        return this.witnessStore.get(address);
    }

    public void saveWitness(WitnessCapsule witnessCapsule) {
        this.witnessStore.put(witnessCapsule.createDbKey(), (ProtoCapsule)witnessCapsule);
    }

    public List<WitnessCapsule> getAllWitnesses() {
        return this.witnessStore.getAllWitnesses();
    }

    public List<WitnessCapsule> updateWitnessStandby(List<WitnessCapsule> all) {
        return this.witnessStore.updateWitnessStandby(all);
    }

    public void saveStateFlag(int flag) {
        this.dynamicPropertiesStore.saveStateFlag(flag);
    }

    public void updateNextMaintenanceTime(long time) {
        this.dynamicPropertiesStore.updateNextMaintenanceTime(time);
    }

    public long getNextMaintenanceTime() {
        return this.dynamicPropertiesStore.getNextMaintenanceTime();
    }

    public long getLatestSolidifiedBlockNum() {
        return this.dynamicPropertiesStore.getLatestSolidifiedBlockNum();
    }

    public void saveLatestSolidifiedBlockNum(long num) {
        this.dynamicPropertiesStore.saveLatestSolidifiedBlockNum(num);
    }

    public void applyBlock(boolean flag) {
        this.dynamicPropertiesStore.applyBlock(flag);
    }

    public boolean allowChangeDelegation() {
        return this.dynamicPropertiesStore.allowChangeDelegation();
    }
}

