/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.log.layout;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiLayoutPattern
extends PatternLayoutEncoder {
    private List<Rule> rules = new ArrayList<Rule>();
    private Map<String, Layout<ILoggingEvent>> layoutMap = new HashMap<String, Layout<ILoggingEvent>>();

    public void addRule(Rule rule) {
        this.rules.add(rule);
        rule.start(this.context);
    }

    public byte[] encode(ILoggingEvent event) {
        Layout<ILoggingEvent> layout = this.getLayout(event.getLoggerName());
        String txt = layout.doLayout((Object)event);
        return this.convertToBytes(txt);
    }

    private byte[] convertToBytes(String s) {
        Charset charset = this.getCharset();
        if (charset == null) {
            return s.getBytes();
        }
        return s.getBytes(charset);
    }

    private Layout<ILoggingEvent> getLayout(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if ("ROOT".equalsIgnoreCase(name)) {
            return this.getLayout();
        }
        if (this.layoutMap.containsKey(name)) {
            return this.layoutMap.get(name);
        }
        Layout layout = this.getLayout();
        for (Rule rule : this.rules) {
            if (!rule.logger.equals(name)) continue;
            layout = rule.getPatternLayoutEncoder().getLayout();
            break;
        }
        this.layoutMap.put(name, (Layout<ILoggingEvent>)layout);
        return layout;
    }

    public void start() {
        super.start();
    }

    public static class Rule {
        private String logger;
        private String pattern;
        private PatternLayoutEncoder patternLayoutEncoder;
        private boolean outputPatternAsHeader = false;

        public String getLogger() {
            return this.logger;
        }

        public void setLogger(String logger) {
            this.logger = logger;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public boolean isOutputPatternAsHeader() {
            return this.outputPatternAsHeader;
        }

        public void setOutputPatternAsHeader(boolean outputPatternAsHeader) {
            this.outputPatternAsHeader = outputPatternAsHeader;
        }

        public PatternLayoutEncoder getPatternLayoutEncoder() {
            return this.patternLayoutEncoder;
        }

        public void start(Context context) {
            this.patternLayoutEncoder = new PatternLayoutEncoder();
            this.patternLayoutEncoder.setPattern(this.pattern);
            this.patternLayoutEncoder.setContext(context);
            this.patternLayoutEncoder.setOutputPatternAsHeader(this.outputPatternAsHeader);
            this.patternLayoutEncoder.start();
        }
    }
}

