/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.cache;

import java.util.Arrays;

public enum CacheType {
    witnessStandby("witnessStandby"),
    recentBlock("recent-block"),
    witness("witness"),
    witnessSchedule("witness_schedule"),
    delegatedResource("DelegatedResource"),
    delegatedResourceAccountIndex("DelegatedResourceAccountIndex"),
    votes("votes"),
    abi("abi"),
    code("code"),
    contract("contract"),
    assetIssueV2("asset-issue-v2"),
    properties("properties"),
    delegation("delegation"),
    storageRow("storage-row"),
    account("account");

    public final String type;

    private CacheType(String type) {
        this.type = type;
    }

    public static CacheType findByType(String type) {
        return Arrays.stream(CacheType.values()).filter(c -> c.type.equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException(type));
    }

    public String toString() {
        return this.type;
    }
}

