/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.setting;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbSettings {
    private static final Logger logger = LoggerFactory.getLogger(RocksDbSettings.class);
    private static RocksDbSettings rocksDbSettings;
    private int levelNumber;
    private int maxOpenFiles;
    private int compactThreads;
    private long blockSize;
    private long maxBytesForLevelBase;
    private double maxBytesForLevelMultiplier;
    private int level0FileNumCompactionTrigger;
    private long targetFileSizeBase;
    private int targetFileSizeMultiplier;
    private boolean enableStatistics;

    private RocksDbSettings() {
    }

    public static RocksDbSettings getDefaultSettings() {
        RocksDbSettings defaultSettings = new RocksDbSettings();
        return defaultSettings.withLevelNumber(7).withBlockSize(64L).withCompactThreads(32).withTargetFileSizeBase(256L).withMaxBytesForLevelMultiplier(10.0).withTargetFileSizeMultiplier(1).withMaxBytesForLevelBase(256L).withMaxOpenFiles(-1).withEnableStatistics(false);
    }

    public static RocksDbSettings getSettings() {
        return rocksDbSettings == null ? RocksDbSettings.getDefaultSettings() : rocksDbSettings;
    }

    public static RocksDbSettings initCustomSettings(int levelNumber, int compactThreads, int blockSize, long maxBytesForLevelBase, double maxBytesForLevelMultiplier, int level0FileNumCompactionTrigger, long targetFileSizeBase, int targetFileSizeMultiplier) {
        rocksDbSettings = new RocksDbSettings().withMaxOpenFiles(-1).withEnableStatistics(false).withLevelNumber(levelNumber).withCompactThreads(compactThreads).withBlockSize(blockSize).withMaxBytesForLevelBase(maxBytesForLevelBase).withMaxBytesForLevelMultiplier(maxBytesForLevelMultiplier).withLevel0FileNumCompactionTrigger(level0FileNumCompactionTrigger).withTargetFileSizeBase(targetFileSizeBase).withTargetFileSizeMultiplier(targetFileSizeMultiplier);
        return rocksDbSettings;
    }

    public static void loggingSettings() {
        logger.info(String.format("level number: %d, CompactThreads: %d, Blocksize: %d, maxBytesForLevelBase: %d, withMaxBytesForLevelMultiplier: %f, level0FileNumCompactionTrigger: %d, withTargetFileSizeBase: %d, withTargetFileSizeMultiplier: %d", rocksDbSettings.getLevelNumber(), rocksDbSettings.getCompactThreads(), rocksDbSettings.getBlockSize(), rocksDbSettings.getMaxBytesForLevelBase(), rocksDbSettings.getMaxBytesForLevelMultiplier(), rocksDbSettings.getLevel0FileNumCompactionTrigger(), rocksDbSettings.getTargetFileSizeBase(), rocksDbSettings.getTargetFileSizeMultiplier()));
    }

    public RocksDbSettings withMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
        return this;
    }

    public RocksDbSettings withCompactThreads(int compactThreads) {
        this.compactThreads = compactThreads;
        return this;
    }

    public RocksDbSettings withBlockSize(long blockSize) {
        this.blockSize = blockSize * 1024L;
        return this;
    }

    public RocksDbSettings withMaxBytesForLevelBase(long maxBytesForLevelBase) {
        this.maxBytesForLevelBase = maxBytesForLevelBase * 1024L * 1024L;
        return this;
    }

    public RocksDbSettings withMaxBytesForLevelMultiplier(double maxBytesForLevelMultiplier) {
        this.maxBytesForLevelMultiplier = maxBytesForLevelMultiplier;
        return this;
    }

    public RocksDbSettings withLevel0FileNumCompactionTrigger(int level0FileNumCompactionTrigger) {
        this.level0FileNumCompactionTrigger = level0FileNumCompactionTrigger;
        return this;
    }

    public RocksDbSettings withEnableStatistics(boolean enable) {
        this.enableStatistics = enable;
        return this;
    }

    public RocksDbSettings withLevelNumber(int levelNumber) {
        this.levelNumber = levelNumber;
        return this;
    }

    public RocksDbSettings withTargetFileSizeBase(long targetFileSizeBase) {
        this.targetFileSizeBase = targetFileSizeBase * 1024L * 1024L;
        return this;
    }

    public RocksDbSettings withTargetFileSizeMultiplier(int targetFileSizeMultiplier) {
        this.targetFileSizeMultiplier = targetFileSizeMultiplier;
        return this;
    }

    public static void setRocksDbSettings(RocksDbSettings rocksDbSettings) {
        RocksDbSettings.rocksDbSettings = rocksDbSettings;
    }

    public static RocksDbSettings getRocksDbSettings() {
        return rocksDbSettings;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public int getCompactThreads() {
        return this.compactThreads;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public long getMaxBytesForLevelBase() {
        return this.maxBytesForLevelBase;
    }

    public double getMaxBytesForLevelMultiplier() {
        return this.maxBytesForLevelMultiplier;
    }

    public int getLevel0FileNumCompactionTrigger() {
        return this.level0FileNumCompactionTrigger;
    }

    public long getTargetFileSizeBase() {
        return this.targetFileSizeBase;
    }

    public int getTargetFileSizeMultiplier() {
        return this.targetFileSizeMultiplier;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }
}

