/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.args;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.protos.Protocol;

public class Account
implements Serializable {
    private static final long serialVersionUID = 2674206490063656846L;
    private static final String ACCOUNT_TYPE_NORMAL = "NORMAL";
    private static final String ACCOUNT_TYPE_ASSETISSUE = "ASSETISSUE";
    private static final String ACCOUNT_TYPE_CONTRACT = "CONTRACT";
    private String accountName;
    private String accountType;
    private byte[] address;
    private String balance;

    public void setAddress(byte[] address) {
        if (!DecodeUtil.addressValid(address)) {
            throw new IllegalArgumentException("The address(" + StringUtil.createReadableString(address) + ") must be 21 bytes.");
        }
        this.address = address;
    }

    public long getBalance() {
        return Long.parseLong(this.balance);
    }

    public void setBalance(String balance) {
        try {
            Long.parseLong(balance);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Balance(" + balance + ") must be a Long type.");
        }
        this.balance = balance;
    }

    public ByteString getAccountName() {
        if (StringUtils.isBlank((CharSequence)this.accountName)) {
            return ByteString.EMPTY;
        }
        return ByteString.copyFrom((byte[])ByteArray.fromString(this.accountName));
    }

    public void setAccountName(String accountName) {
        if (StringUtils.isBlank((CharSequence)accountName)) {
            throw new IllegalArgumentException("Account name must be not be empty.");
        }
        this.accountName = accountName;
    }

    public Protocol.AccountType getAccountType() {
        return this.getAccountTypeByString(this.accountType);
    }

    public void setAccountType(String accountType) {
        if (!this.isAccountType(accountType)) {
            throw new IllegalArgumentException("Account type error: Not a Normal/AssetIssue/Contract");
        }
        this.accountType = accountType;
    }

    public boolean isAccountType(String accountType) {
        if (accountType == null) {
            return false;
        }
        switch (accountType.toUpperCase()) {
            case "NORMAL": 
            case "ASSETISSUE": 
            case "CONTRACT": {
                return true;
            }
        }
        return false;
    }

    public Protocol.AccountType getAccountTypeByString(String accountType) {
        if (accountType == null) {
            throw new IllegalArgumentException("Account type error: Not a Normal/AssetIssue/Contract");
        }
        switch (accountType.toUpperCase()) {
            case "NORMAL": {
                return Protocol.AccountType.Normal;
            }
            case "ASSETISSUE": {
                return Protocol.AccountType.AssetIssue;
            }
            case "CONTRACT": {
                return Protocol.AccountType.Contract;
            }
        }
        throw new IllegalArgumentException("Account type error: Not a Normal/AssetIssue/Contract");
    }

    public byte[] getAddress() {
        return this.address;
    }
}

