/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.bloom.Bloom;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.EventBloomException;

@Component
public class SectionBloomStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    public static final int BLOCK_PER_SECTION = 2048;
    private List<Integer> bitList;

    @Autowired
    public SectionBloomStore(@Value(value="section-bloom") String dbName) {
        super(dbName);
    }

    @Override
    public BytesCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return null;
        }
        return new BytesCapsule(value);
    }

    @Override
    public boolean has(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return !ArrayUtils.isEmpty((byte[])value);
    }

    private long combineKey(int section, int bitIndex) {
        return (long)section * 1000000L + (long)bitIndex;
    }

    public BitSet get(int section, int bitIndex) throws EventBloomException {
        byte[] data;
        long keyLong = this.combineKey(section, bitIndex);
        byte[] key = Long.toHexString(keyLong).getBytes();
        BytesCapsule bytesCapsule = this.get(key);
        if (bytesCapsule == null) {
            return null;
        }
        try {
            data = ByteUtil.decompress((byte[])bytesCapsule.getData());
        }
        catch (Exception e) {
            throw new EventBloomException("decompress byte failed");
        }
        return BitSet.valueOf(data);
    }

    public void put(int section, int bitIndex, BitSet bitSet) throws EventBloomException {
        long keyLong = this.combineKey(section, bitIndex);
        byte[] key = Long.toHexString(keyLong).getBytes();
        byte[] compressData = ByteUtil.compress((byte[])bitSet.toByteArray());
        super.put(key, new BytesCapsule(compressData));
    }

    public Bloom initBlockSection(TransactionRetCapsule transactionRetCapsule) {
        Bloom blockBloom = Bloom.createBloom(transactionRetCapsule);
        if (Objects.isNull(blockBloom)) {
            this.bitList = null;
            return null;
        }
        this.bitList = new ArrayList<Integer>();
        BitSet bs = BitSet.valueOf(blockBloom.getData());
        int i = bs.nextSetBit(0);
        while (i >= 0 && i != Integer.MAX_VALUE) {
            this.bitList.add(i);
            i = bs.nextSetBit(i + 1);
        }
        return blockBloom;
    }

    public void write(long blockNum) throws EventBloomException {
        if (CollectionUtils.isEmpty(this.bitList)) {
            return;
        }
        int section = (int)(blockNum / 2048L);
        int blockNumOffset = (int)(blockNum % 2048L);
        for (int bitIndex : this.bitList) {
            BitSet bitSet = this.get(section, bitIndex);
            if (Objects.isNull(bitSet)) {
                bitSet = new BitSet(2048);
            }
            bitSet.set(blockNumOffset);
            this.put(section, bitIndex, bitSet);
        }
    }
}

