/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.protobuf.ByteString;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Commons;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.db.accountstate.AccountStateCallBackUtils;
import org.tron.core.store.AccountTraceStore;
import org.tron.core.store.BalanceTraceStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.contract.BalanceContract;

@Component
public class AccountStore
extends TronStoreWithRevoking<AccountCapsule> {
    private static Map<String, byte[]> assertsAddress = new HashMap<String, byte[]>();
    @Autowired
    private AccountStateCallBackUtils accountStateCallBackUtils;
    @Autowired
    private BalanceTraceStore balanceTraceStore;
    @Autowired
    private AccountTraceStore accountTraceStore;
    @Autowired
    private DynamicPropertiesStore dynamicPropertiesStore;

    @Autowired
    private AccountStore(@Value(value="account") String dbName) {
        super(dbName);
    }

    public static void setAccount(Config config) {
        List list = config.getObjectList("genesis.block.assets");
        for (int i = 0; i < list.size(); ++i) {
            ConfigObject obj = (ConfigObject)list.get(i);
            String accountName = obj.get((Object)"accountName").unwrapped().toString();
            byte[] address = Commons.decodeFromBase58Check(obj.get((Object)"address").unwrapped().toString());
            assertsAddress.put(accountName, address);
        }
    }

    @Override
    public AccountCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new AccountCapsule(value);
    }

    @Override
    public void put(byte[] key, AccountCapsule item) {
        if (CommonParameter.getInstance().isHistoryBalanceLookup()) {
            AccountCapsule old = (AccountCapsule)super.getUnchecked(key);
            if (old == null) {
                if (item.getBalance() != 0L) {
                    this.recordBalance(item, item.getBalance());
                    BlockCapsule.BlockId blockId = this.balanceTraceStore.getCurrentBlockId();
                    if (blockId != null) {
                        this.accountTraceStore.recordBalanceWithBlock(key, blockId.getNum(), item.getBalance());
                    }
                }
            } else if (old.getBalance() != item.getBalance()) {
                this.recordBalance(item, item.getBalance() - old.getBalance());
                BlockCapsule.BlockId blockId = this.balanceTraceStore.getCurrentBlockId();
                if (blockId != null) {
                    this.accountTraceStore.recordBalanceWithBlock(key, blockId.getNum(), item.getBalance());
                }
            }
        }
        super.put(key, item);
        this.accountStateCallBackUtils.accountCallBack(key, item);
    }

    @Override
    public void delete(byte[] key) {
        if (CommonParameter.getInstance().isHistoryBalanceLookup()) {
            BlockCapsule.BlockId blockId;
            AccountCapsule old = (AccountCapsule)super.getUnchecked(key);
            if (old != null) {
                this.recordBalance(old, -old.getBalance());
            }
            if ((blockId = this.balanceTraceStore.getCurrentBlockId()) != null) {
                this.accountTraceStore.recordBalanceWithBlock(key, blockId.getNum(), 0L);
            }
        }
        super.delete(key);
    }

    public AccountCapsule getSun() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Sun"));
    }

    public AccountCapsule getBlackhole() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Blackhole"));
    }

    public byte[] getBlackholeAddress() {
        return assertsAddress.get("Blackhole");
    }

    public AccountCapsule getZion() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Zion"));
    }

    private void recordBalance(AccountCapsule accountCapsule, long diff) {
        BalanceContract.TransactionBalanceTrace transactionBalanceTrace = this.balanceTraceStore.getCurrentTransactionBalanceTrace();
        if (transactionBalanceTrace == null) {
            return;
        }
        OptionalLong max = transactionBalanceTrace.getOperationList().stream().mapToLong(BalanceContract.TransactionBalanceTrace.Operation::getOperationIdentifier).max();
        long operationIdentifier = max.isPresent() ? max.getAsLong() + 1L : 0L;
        ByteString address = accountCapsule.getAddress();
        BalanceContract.TransactionBalanceTrace.Operation operation = BalanceContract.TransactionBalanceTrace.Operation.newBuilder().setAddress(address).setAmount(diff).setOperationIdentifier(operationIdentifier).build();
        transactionBalanceTrace = transactionBalanceTrace.toBuilder().addOperation(operation).build();
        this.balanceTraceStore.setCurrentTransactionBalanceTrace(transactionBalanceTrace);
    }

    @Override
    public void close() {
        super.close();
    }
}

