/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class BlockIndexStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    public BlockIndexStore(@Value(value="block-index") String dbName) {
        super(dbName);
    }

    public void put(BlockCapsule.BlockId id) {
        this.put(ByteArray.fromLong((long)id.getNum()), new BytesCapsule(id.getBytes()));
    }

    public BlockCapsule.BlockId get(Long num) throws ItemNotFoundException {
        BytesCapsule value = (BytesCapsule)this.getUnchecked(ByteArray.fromLong((long)num));
        if (value == null || value.getData() == null) {
            throw new ItemNotFoundException(String.format("number: %d is not found!", num));
        }
        return new BlockCapsule.BlockId(Sha256Hash.wrap((byte[])value.getData()), (long)num);
    }

    @Override
    public BytesCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            throw new ItemNotFoundException(String.format("number: %d is not found!", ByteArray.toLong((byte[])key)));
        }
        return new BytesCapsule(value);
    }

    public List<BlockCapsule.BlockId> getLimitNumber(long startNumber, long limit) {
        return this.pack(this.revokingDB.getValuesNext(ByteArray.fromLong((long)startNumber), limit));
    }

    private List<BlockCapsule.BlockId> pack(Set<byte[]> values) {
        ArrayList<BlockCapsule.BlockId> blocks = new ArrayList<BlockCapsule.BlockId>();
        for (byte[] bytes : values) {
            blocks.add(new BlockCapsule.BlockId(Sha256Hash.wrap((byte[])bytes)));
        }
        blocks.sort(Comparator.comparing(BlockCapsule.BlockId::getNum));
        return blocks;
    }
}

