/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import com.google.common.primitives.Bytes;
import java.util.HashMap;
import java.util.Map;
import org.tron.common.utils.ByteArray;
import org.tron.core.store.AccountAssetStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;

public class AssetUtil {
    private static AccountAssetStore accountAssetStore;
    private static DynamicPropertiesStore dynamicPropertiesStore;

    public static boolean hasAssetV2(Protocol.Account account, byte[] key) {
        if (!account.getAssetV2Map().isEmpty() && account.getAssetV2Map().containsKey(ByteArray.toStr((byte[])key))) {
            return true;
        }
        if (!AssetUtil.isAllowAssetOptimization()) {
            return false;
        }
        byte[] dbKey = Bytes.concat((byte[][])new byte[][]{account.getAddress().toByteArray(), key});
        return accountAssetStore.get(dbKey) != null;
    }

    public static Protocol.Account importAsset(Protocol.Account account, byte[] key) {
        if (!AssetUtil.isAllowAssetOptimization()) {
            return account;
        }
        String sKey = ByteArray.toStr((byte[])key);
        if (account.getAssetV2Map().containsKey(sKey)) {
            return account;
        }
        long balance = accountAssetStore.getBalance(account, key);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.putAll(account.getAssetV2Map());
        map.put(sKey, balance);
        return account.toBuilder().clearAssetV2().putAllAssetV2(map).build();
    }

    public static Protocol.Account importAllAsset(Protocol.Account account) {
        if (!AssetUtil.isAllowAssetOptimization()) {
            return account;
        }
        Map<String, Long> map = accountAssetStore.getAllAssets(account);
        return account.toBuilder().clearAssetV2().putAllAssetV2(map).build();
    }

    public static void setAccountAssetStore(AccountAssetStore accountAssetStore) {
        AssetUtil.accountAssetStore = accountAssetStore;
    }

    public static void setDynamicPropertiesStore(DynamicPropertiesStore dynamicPropertiesStore) {
        AssetUtil.dynamicPropertiesStore = dynamicPropertiesStore;
    }

    public static boolean isAllowAssetOptimization() {
        return dynamicPropertiesStore.supportAllowAssetOptimization();
    }
}

