/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class MarketAccountOrderCapsule
implements ProtoCapsule<Protocol.MarketAccountOrder> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.MarketAccountOrder accountOrder;

    public MarketAccountOrderCapsule(Protocol.MarketAccountOrder accountOrder) {
        this.accountOrder = accountOrder;
    }

    public MarketAccountOrderCapsule(byte[] data) {
        try {
            this.accountOrder = Protocol.MarketAccountOrder.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public MarketAccountOrderCapsule(ByteString address) {
        this.accountOrder = Protocol.MarketAccountOrder.newBuilder().setOwnerAddress(address).build();
    }

    public MarketAccountOrderCapsule(ByteString address, List<ByteString> orders, long count) {
        this.accountOrder = Protocol.MarketAccountOrder.newBuilder().setOwnerAddress(address).addAllOrders(orders).setCount(count).build();
    }

    public ByteString getOwnerAddress() {
        return this.accountOrder.getOwnerAddress();
    }

    public byte[] createDbKey() {
        return this.getOwnerAddress().toByteArray();
    }

    public List<ByteString> getOrdersList() {
        return this.accountOrder.getOrdersList();
    }

    public void addOrders(ByteString order) {
        this.accountOrder = this.accountOrder.toBuilder().addOrders(order).build();
    }

    public void removeOrder(ByteString orderId) {
        ArrayList orderList = Lists.newArrayList();
        orderList.addAll(this.getOrdersList());
        orderList.remove(orderId);
        this.accountOrder = this.accountOrder.toBuilder().setCount(this.getCount() - 1L).clearOrders().addAllOrders((Iterable)orderList).build();
    }

    public void setCount(long o) {
        this.accountOrder = this.accountOrder.toBuilder().setCount(o).build();
    }

    public long getCount() {
        return this.accountOrder.getCount();
    }

    public void setOwnerAddress(long count) {
        this.accountOrder = this.accountOrder.toBuilder().setCount(count).build();
    }

    public void setTotalCount(long o) {
        this.accountOrder = this.accountOrder.toBuilder().setTotalCount(o).build();
    }

    public long getTotalCount() {
        return this.accountOrder.getTotalCount();
    }

    @Override
    public byte[] getData() {
        return this.accountOrder.toByteArray();
    }

    @Override
    public Protocol.MarketAccountOrder getInstance() {
        return this.accountOrder;
    }
}

