/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.utils.AssetUtil;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;
import org.tron.protos.contract.Common;

public class AccountCapsule
implements ProtoCapsule<Protocol.Account>,
Comparable<AccountCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.Account account;
    private boolean flag = false;

    public AccountCapsule(byte[] data) {
        try {
            this.account = Protocol.Account.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage());
        }
    }

    public AccountCapsule(ByteString accountName, ByteString address, Protocol.AccountType accountType, long balance) {
        this.account = Protocol.Account.newBuilder().setAccountName(accountName).setType(accountType).setAddress(address).setBalance(balance).build();
    }

    public AccountCapsule(AccountContract.AccountCreateContract contract) {
        this.account = Protocol.Account.newBuilder().setType(contract.getType()).setAddress(contract.getAccountAddress()).setTypeValue(contract.getTypeValue()).build();
    }

    public AccountCapsule(AccountContract.AccountCreateContract contract, long createTime, boolean withDefaultPermission, DynamicPropertiesStore dynamicPropertiesStore) {
        if (withDefaultPermission) {
            Protocol.Permission owner = AccountCapsule.createDefaultOwnerPermission(contract.getAccountAddress());
            Protocol.Permission active = AccountCapsule.createDefaultActivePermission(contract.getAccountAddress(), dynamicPropertiesStore);
            this.account = Protocol.Account.newBuilder().setType(contract.getType()).setAddress(contract.getAccountAddress()).setTypeValue(contract.getTypeValue()).setCreateTime(createTime).setOwnerPermission(owner).addActivePermission(active).build();
        } else {
            this.account = Protocol.Account.newBuilder().setType(contract.getType()).setAddress(contract.getAccountAddress()).setTypeValue(contract.getTypeValue()).setCreateTime(createTime).build();
        }
    }

    public AccountCapsule(AccountContract.AccountUpdateContract contract) {
    }

    public AccountCapsule(ByteString address, ByteString accountName, Protocol.AccountType accountType) {
        this.account = Protocol.Account.newBuilder().setType(accountType).setAccountName(accountName).setAddress(address).build();
    }

    public AccountCapsule(ByteString address, Protocol.AccountType accountType) {
        this.account = Protocol.Account.newBuilder().setType(accountType).setAddress(address).build();
    }

    public AccountCapsule(ByteString address, Protocol.AccountType accountType, long createTime, boolean withDefaultPermission, DynamicPropertiesStore dynamicPropertiesStore) {
        if (withDefaultPermission) {
            Protocol.Permission owner = AccountCapsule.createDefaultOwnerPermission(address);
            Protocol.Permission active = AccountCapsule.createDefaultActivePermission(address, dynamicPropertiesStore);
            this.account = Protocol.Account.newBuilder().setType(accountType).setAddress(address).setCreateTime(createTime).setOwnerPermission(owner).addActivePermission(active).build();
        } else {
            this.account = Protocol.Account.newBuilder().setType(accountType).setAddress(address).setCreateTime(createTime).build();
        }
    }

    public AccountCapsule(Protocol.Account account) {
        this.account = account;
    }

    private static ByteString getActiveDefaultOperations(DynamicPropertiesStore dynamicPropertiesStore) {
        return ByteString.copyFrom((byte[])dynamicPropertiesStore.getActiveDefaultOperations());
    }

    public static Protocol.Permission createDefaultOwnerPermission(ByteString address) {
        Protocol.Key.Builder key = Protocol.Key.newBuilder();
        key.setAddress(address);
        key.setWeight(1L);
        Protocol.Permission.Builder owner = Protocol.Permission.newBuilder();
        owner.setType(Protocol.Permission.PermissionType.Owner);
        owner.setId(0);
        owner.setPermissionName("owner");
        owner.setThreshold(1L);
        owner.setParentId(0);
        owner.addKeys(key);
        return owner.build();
    }

    public static Protocol.Permission createDefaultActivePermission(ByteString address, DynamicPropertiesStore dynamicPropertiesStore) {
        Protocol.Key.Builder key = Protocol.Key.newBuilder();
        key.setAddress(address);
        key.setWeight(1L);
        Protocol.Permission.Builder active = Protocol.Permission.newBuilder();
        active.setType(Protocol.Permission.PermissionType.Active);
        active.setId(2);
        active.setPermissionName("active");
        active.setThreshold(1L);
        active.setParentId(0);
        active.setOperations(AccountCapsule.getActiveDefaultOperations(dynamicPropertiesStore));
        active.addKeys(key);
        return active.build();
    }

    public static Protocol.Permission createDefaultWitnessPermission(ByteString address) {
        Protocol.Key.Builder key = Protocol.Key.newBuilder();
        key.setAddress(address);
        key.setWeight(1L);
        Protocol.Permission.Builder active = Protocol.Permission.newBuilder();
        active.setType(Protocol.Permission.PermissionType.Witness);
        active.setId(1);
        active.setPermissionName("witness");
        active.setThreshold(1L);
        active.setParentId(0);
        active.addKeys(key);
        return active.build();
    }

    public static Protocol.Permission getDefaultPermission(ByteString owner) {
        return AccountCapsule.createDefaultOwnerPermission(owner);
    }

    @Override
    public int compareTo(AccountCapsule otherObject) {
        return Long.compare(otherObject.getBalance(), this.getBalance());
    }

    @Override
    public byte[] getData() {
        return this.account.toByteArray();
    }

    @Override
    public Protocol.Account getInstance() {
        return this.account;
    }

    public void setInstance(Protocol.Account account) {
        this.account = account;
    }

    public ByteString getAddress() {
        return this.account.getAddress();
    }

    public byte[] createDbKey() {
        return this.getAddress().toByteArray();
    }

    public String createReadableString() {
        return ByteArray.toHexString((byte[])this.getAddress().toByteArray());
    }

    public Protocol.AccountType getType() {
        return this.account.getType();
    }

    public ByteString getAccountName() {
        return this.account.getAccountName();
    }

    public void setAccountName(byte[] name) {
        this.account = this.account.toBuilder().setAccountName(ByteString.copyFrom((byte[])name)).build();
    }

    public ByteString getAccountId() {
        return this.account.getAccountId();
    }

    public void setAccountId(byte[] id) {
        this.account = this.account.toBuilder().setAccountId(ByteString.copyFrom((byte[])id)).build();
    }

    public void setDefaultWitnessPermission(DynamicPropertiesStore dynamicPropertiesStore) {
        Protocol.Account.Builder builder = this.account.toBuilder();
        Protocol.Permission witness = AccountCapsule.createDefaultWitnessPermission(this.getAddress());
        if (!this.account.hasOwnerPermission()) {
            Protocol.Permission owner = AccountCapsule.createDefaultOwnerPermission(this.getAddress());
            builder.setOwnerPermission(owner);
        }
        if (this.account.getActivePermissionCount() == 0) {
            Protocol.Permission active = AccountCapsule.createDefaultActivePermission(this.getAddress(), dynamicPropertiesStore);
            builder.addActivePermission(active);
        }
        this.account = builder.setWitnessPermission(witness).build();
    }

    public byte[] getWitnessPermissionAddress() {
        if (this.account.getWitnessPermission().getKeysCount() == 0) {
            return this.getAddress().toByteArray();
        }
        return this.account.getWitnessPermission().getKeys(0).getAddress().toByteArray();
    }

    public long getBalance() {
        return this.account.getBalance();
    }

    public void setBalance(long balance) {
        this.account = this.account.toBuilder().setBalance(balance).build();
    }

    public long getLatestOperationTime() {
        return this.account.getLatestOprationTime();
    }

    public void setLatestOperationTime(long latestTime) {
        this.account = this.account.toBuilder().setLatestOprationTime(latestTime).build();
    }

    public long getLatestConsumeTime() {
        return this.account.getLatestConsumeTime();
    }

    public void setLatestConsumeTime(long latestTime) {
        this.account = this.account.toBuilder().setLatestConsumeTime(latestTime).build();
    }

    public long getLatestConsumeFreeTime() {
        return this.account.getLatestConsumeFreeTime();
    }

    public void setLatestConsumeFreeTime(long latestTime) {
        this.account = this.account.toBuilder().setLatestConsumeFreeTime(latestTime).build();
    }

    public void addDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setDelegatedFrozenBalanceForBandwidth(this.account.getDelegatedFrozenBalanceForBandwidth() + balance).build();
    }

    public void addDelegatedFrozenV2BalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setDelegatedFrozenV2BalanceForBandwidth(this.account.getDelegatedFrozenV2BalanceForBandwidth() + balance).build();
    }

    public long getAcquiredDelegatedFrozenBalanceForBandwidth() {
        return this.account.getAcquiredDelegatedFrozenBalanceForBandwidth();
    }

    public long getAcquiredDelegatedFrozenV2BalanceForBandwidth() {
        return this.account.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
    }

    public long getTotalAcquiredDelegatedFrozenBalanceForBandwidth() {
        return this.getAcquiredDelegatedFrozenBalanceForBandwidth() + this.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
    }

    public void addFrozenBalanceForBandwidthV2(long balance) {
        this.addFrozenBalanceForResource(Common.ResourceCode.BANDWIDTH, balance);
    }

    public void setAcquiredDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenBalanceForBandwidth(balance).build();
    }

    public void setAcquiredDelegatedFrozenV2BalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenV2BalanceForBandwidth(balance).build();
    }

    public void addAcquiredDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenBalanceForBandwidth(this.account.getAcquiredDelegatedFrozenBalanceForBandwidth() + balance).build();
    }

    public void addAcquiredDelegatedFrozenV2BalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenV2BalanceForBandwidth(this.account.getAcquiredDelegatedFrozenV2BalanceForBandwidth() + balance).build();
    }

    public void safeAddAcquiredDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenBalanceForBandwidth(Math.max(0L, this.account.getAcquiredDelegatedFrozenBalanceForBandwidth() + balance)).build();
    }

    public void safeAddAcquiredDelegatedFrozenV2BalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setAcquiredDelegatedFrozenV2BalanceForBandwidth(Math.max(0L, this.account.getAcquiredDelegatedFrozenV2BalanceForBandwidth() + balance)).build();
    }

    public long getAcquiredDelegatedFrozenBalanceForEnergy() {
        return this.getAccountResource().getAcquiredDelegatedFrozenBalanceForEnergy();
    }

    public long getAcquiredDelegatedFrozenV2BalanceForEnergy() {
        return this.getAccountResource().getAcquiredDelegatedFrozenV2BalanceForEnergy();
    }

    public long getTotalAcquiredDelegatedFrozenBalanceForEnergy() {
        return this.getAcquiredDelegatedFrozenBalanceForEnergy() + this.getAcquiredDelegatedFrozenV2BalanceForEnergy();
    }

    public void setAcquiredDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenBalanceForEnergy(balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void setAcquiredDelegatedFrozenV2BalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenV2BalanceForEnergy(balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public long getDelegatedFrozenBalanceForEnergy() {
        return this.getAccountResource().getDelegatedFrozenBalanceForEnergy();
    }

    public long getDelegatedFrozenV2BalanceForEnergy() {
        return this.getAccountResource().getDelegatedFrozenV2BalanceForEnergy();
    }

    public long getTotalDelegatedFrozenBalanceForEnergy() {
        return this.getDelegatedFrozenBalanceForEnergy() + this.getDelegatedFrozenV2BalanceForEnergy();
    }

    public long getDelegatedFrozenBalanceForBandwidth() {
        return this.account.getDelegatedFrozenBalanceForBandwidth();
    }

    public long getDelegatedFrozenV2BalanceForBandwidth() {
        return this.account.getDelegatedFrozenV2BalanceForBandwidth();
    }

    public long getTotalDelegatedFrozenBalanceForBandwidth() {
        return this.getDelegatedFrozenBalanceForBandwidth() + this.getDelegatedFrozenV2BalanceForBandwidth();
    }

    public void setDelegatedFrozenBalanceForBandwidth(long balance) {
        this.account = this.account.toBuilder().setDelegatedFrozenBalanceForBandwidth(balance).build();
    }

    public void setDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setDelegatedFrozenBalanceForEnergy(balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addAcquiredDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenBalanceForEnergy(this.getAccountResource().getAcquiredDelegatedFrozenBalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addAcquiredDelegatedFrozenV2BalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenV2BalanceForEnergy(this.getAccountResource().getAcquiredDelegatedFrozenV2BalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void safeAddAcquiredDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenBalanceForEnergy(Math.max(0L, this.getAccountResource().getAcquiredDelegatedFrozenBalanceForEnergy() + balance)).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void safeAddAcquiredDelegatedFrozenV2BalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenV2BalanceForEnergy(Math.max(0L, this.getAccountResource().getAcquiredDelegatedFrozenV2BalanceForEnergy() + balance)).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addDelegatedFrozenBalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setDelegatedFrozenBalanceForEnergy(this.getAccountResource().getDelegatedFrozenBalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addDelegatedFrozenV2BalanceForEnergy(long balance) {
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setDelegatedFrozenV2BalanceForEnergy(this.getAccountResource().getDelegatedFrozenV2BalanceForEnergy() + balance).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public void addFrozenBalanceForEnergyV2(long balance) {
        this.addFrozenBalanceForResource(Common.ResourceCode.ENERGY, balance);
    }

    private void addFrozenBalanceForResource(Common.ResourceCode type, long balance) {
        boolean doUpdate = false;
        for (int i = 0; i < this.account.getFrozenV2List().size(); ++i) {
            if (!((Protocol.Account.FreezeV2)this.account.getFrozenV2List().get(i)).getType().equals((Object)type)) continue;
            long newAmount = this.account.getFrozenV2(i).getAmount() + balance;
            Protocol.Account.FreezeV2 freezeV2 = Protocol.Account.FreezeV2.newBuilder().setType(type).setAmount(newAmount).build();
            this.updateFrozenV2List(i, freezeV2);
            doUpdate = true;
            break;
        }
        if (!doUpdate) {
            Protocol.Account.FreezeV2 freezeV2 = Protocol.Account.FreezeV2.newBuilder().setType(type).setAmount(balance).build();
            this.addFrozenV2List(freezeV2);
        }
    }

    public String toString() {
        return this.account.toString();
    }

    public void addVotes(ByteString voteAddress, long voteAdd) {
        this.account = this.account.toBuilder().addVotes(Protocol.Vote.newBuilder().setVoteAddress(voteAddress).setVoteCount(voteAdd).build()).build();
    }

    public void addAllVotes(List<Protocol.Vote> votesToAdd) {
        this.account = this.account.toBuilder().addAllVotes(votesToAdd).build();
    }

    public void clearLatestAssetOperationTimeV2() {
        this.account = this.account.toBuilder().clearLatestAssetOperationTimeV2().build();
    }

    public void clearFreeAssetNetUsageV2() {
        this.account = this.account.toBuilder().clearFreeAssetNetUsageV2().build();
    }

    public void clearVotes() {
        this.account = this.account.toBuilder().clearVotes().build();
    }

    public List<Protocol.Vote> getVotesList() {
        return this.account.getVotesList();
    }

    public long getTronPowerUsage() {
        if (this.getVotesList().isEmpty()) {
            return 0L;
        }
        return this.account.getVotesList().stream().mapToLong(Protocol.Vote::getVoteCount).sum();
    }

    public long getTronPower() {
        long tp = 0L;
        for (int i = 0; i < this.account.getFrozenCount(); ++i) {
            tp += this.account.getFrozen(i).getFrozenBalance();
        }
        tp += this.account.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
        tp += this.account.getDelegatedFrozenBalanceForBandwidth();
        tp += this.account.getAccountResource().getDelegatedFrozenBalanceForEnergy();
        tp += this.getFrozenV2List().stream().filter(o -> o.getType() != Common.ResourceCode.TRON_POWER).mapToLong(Protocol.Account.FreezeV2::getAmount).sum();
        tp += this.account.getDelegatedFrozenV2BalanceForBandwidth();
        return tp += this.account.getAccountResource().getDelegatedFrozenV2BalanceForEnergy();
    }

    public long getAllTronPower() {
        if (this.account.getOldTronPower() == -1L) {
            return this.getTronPowerFrozenBalance() + this.getTronPowerFrozenV2Balance();
        }
        if (this.account.getOldTronPower() == 0L) {
            return this.getTronPower() + this.getTronPowerFrozenBalance() + this.getTronPowerFrozenV2Balance();
        }
        return this.account.getOldTronPower() + this.getTronPowerFrozenBalance() + this.getTronPowerFrozenV2Balance();
    }

    public List<Protocol.Account.FreezeV2> getFrozenV2List() {
        return this.account.getFrozenV2List();
    }

    public List<Protocol.Account.UnFreezeV2> getUnfrozenV2List() {
        return this.account.getUnfrozenV2List();
    }

    public void updateFrozenV2List(int index, Protocol.Account.FreezeV2 frozenV2) {
        if (Objects.isNull(frozenV2)) {
            return;
        }
        this.account = this.account.toBuilder().setFrozenV2(index, frozenV2).build();
    }

    public void addFrozenV2List(Protocol.Account.FreezeV2 frozenV2) {
        this.account = this.account.toBuilder().addFrozenV2(frozenV2).build();
    }

    public void addUnfrozenV2List(Common.ResourceCode type, long unfreezeAmount, long expireTime) {
        Protocol.Account.UnFreezeV2 unFreezeV2 = Protocol.Account.UnFreezeV2.newBuilder().setType(type).setUnfreezeAmount(unfreezeAmount).setUnfreezeExpireTime(expireTime).build();
        this.account = this.account.toBuilder().addUnfrozenV2(unFreezeV2).build();
    }

    public int getUnfreezingV2Count(long now) {
        int count = 0;
        List unFreezeV2List = this.account.getUnfrozenV2List();
        for (Protocol.Account.UnFreezeV2 item : unFreezeV2List) {
            if (item.getUnfreezeExpireTime() <= now) continue;
            ++count;
        }
        return count;
    }

    public boolean getAssetOptimized() {
        return this.account.getAssetOptimized();
    }

    public void setAssetOptimized(boolean flag) {
        this.account = this.account.toBuilder().setAssetOptimized(flag).build();
    }

    public boolean assetBalanceEnoughV2(byte[] key, long amount, DynamicPropertiesStore dynamicPropertiesStore) {
        Long currentAmount;
        this.importAsset(key);
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            Map assetMap = this.account.getAssetMap();
            String nameKey = ByteArray.toStr((byte[])key);
            currentAmount = (Long)assetMap.get(nameKey);
        } else {
            String tokenID = ByteArray.toStr((byte[])key);
            Map assetMap = this.account.getAssetV2Map();
            currentAmount = (Long)assetMap.get(tokenID);
        }
        return amount > 0L && null != currentAmount && amount <= currentAmount;
    }

    public boolean addAssetAmount(byte[] key, long amount) {
        String nameKey;
        Map assetMap = this.account.getAssetMap();
        Long currentAmount = (Long)assetMap.get(nameKey = ByteArray.toStr((byte[])key));
        if (currentAmount == null) {
            currentAmount = 0L;
        }
        this.account = this.account.toBuilder().putAsset(nameKey, Math.addExact(currentAmount, amount)).build();
        return true;
    }

    public boolean addAssetAmountV2(byte[] key, long amount, DynamicPropertiesStore dynamicPropertiesStore, AssetIssueStore assetIssueStore) {
        this.importAsset(key);
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            Map assetMap = this.account.getAssetMap();
            AssetIssueCapsule assetIssueCapsule = assetIssueStore.get(key);
            String tokenID = assetIssueCapsule.getId();
            String nameKey = ByteArray.toStr((byte[])key);
            Long currentAmount = (Long)assetMap.get(nameKey);
            if (currentAmount == null) {
                currentAmount = 0L;
            }
            this.account = this.account.toBuilder().putAsset(nameKey, Math.addExact(currentAmount, amount)).putAssetV2(tokenID, Math.addExact(currentAmount, amount)).build();
        }
        if (dynamicPropertiesStore.getAllowSameTokenName() == 1L) {
            String tokenIDStr = ByteArray.toStr((byte[])key);
            Map assetMapV2 = this.account.getAssetV2Map();
            Long currentAmount = (Long)assetMapV2.get(tokenIDStr);
            if (currentAmount == null) {
                currentAmount = 0L;
            }
            this.account = this.account.toBuilder().putAssetV2(tokenIDStr, Math.addExact(currentAmount, amount)).build();
        }
        return true;
    }

    public boolean reduceAssetAmount(byte[] key, long amount) {
        Map assetMap = this.account.getAssetMap();
        String nameKey = ByteArray.toStr((byte[])key);
        Long currentAmount = (Long)assetMap.get(nameKey);
        if (amount > 0L && null != currentAmount && amount <= currentAmount) {
            this.account = this.account.toBuilder().putAsset(nameKey, Math.subtractExact(currentAmount, amount)).build();
            return true;
        }
        return false;
    }

    public boolean reduceAssetAmountV2(byte[] key, long amount, DynamicPropertiesStore dynamicPropertiesStore, AssetIssueStore assetIssueStore) {
        this.importAsset(key);
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            Map assetMap = this.account.getAssetMap();
            AssetIssueCapsule assetIssueCapsule = assetIssueStore.get(key);
            String tokenID = assetIssueCapsule.getId();
            String nameKey = ByteArray.toStr((byte[])key);
            Long currentAmount = (Long)assetMap.get(nameKey);
            if (amount > 0L && null != currentAmount && amount <= currentAmount) {
                this.account = this.account.toBuilder().putAsset(nameKey, Math.subtractExact(currentAmount, amount)).putAssetV2(tokenID, Math.subtractExact(currentAmount, amount)).build();
                return true;
            }
        }
        if (dynamicPropertiesStore.getAllowSameTokenName() == 1L) {
            String tokenID = ByteArray.toStr((byte[])key);
            Map assetMapV2 = this.account.getAssetV2Map();
            Long currentAmount = (Long)assetMapV2.get(tokenID);
            if (amount > 0L && null != currentAmount && amount <= currentAmount) {
                this.account = this.account.toBuilder().putAssetV2(tokenID, Math.subtractExact(currentAmount, amount)).build();
                return true;
            }
        }
        return false;
    }

    public void clearAssetV2() {
        this.account = this.account.toBuilder().clearAssetV2().build();
    }

    public void clearAsset() {
        this.account = this.account.toBuilder().clearAsset().clearAssetV2().build();
    }

    public boolean addAsset(byte[] key, long value) {
        Map assetMap = this.account.getAssetMap();
        String nameKey = ByteArray.toStr((byte[])key);
        if (!assetMap.isEmpty() && assetMap.containsKey(nameKey)) {
            return false;
        }
        this.account = this.account.toBuilder().putAsset(nameKey, value).build();
        return true;
    }

    public boolean addAssetV2(byte[] key, long value) {
        if (AssetUtil.hasAssetV2(this.account, key)) {
            return false;
        }
        this.account = this.account.toBuilder().putAssetV2(ByteArray.toStr((byte[])key), value).build();
        return true;
    }

    public void addAssetMapV2(Map<String, Long> assetMap) {
        this.account = this.account.toBuilder().putAllAssetV2(assetMap).build();
    }

    public Long getAsset(DynamicPropertiesStore dynamicStore, String key) {
        Long balance;
        if (dynamicStore.getAllowSameTokenName() == 0L) {
            balance = (Long)this.account.getAssetMap().get(key);
        } else {
            this.importAsset(key.getBytes());
            balance = (Long)this.account.getAssetV2Map().get(key);
        }
        return balance;
    }

    public long getAssetV2(String key) {
        this.importAsset(key.getBytes());
        Long balance = (Long)this.account.getAssetV2Map().get(key);
        return balance == null ? 0L : balance;
    }

    public Map<String, Long> getAssetMap() {
        Map assetMap = this.account.getAssetMap();
        if (assetMap.isEmpty()) {
            assetMap = Maps.newHashMap();
        }
        return assetMap;
    }

    public Map<String, Long> getAssetMapV2() {
        this.importAllAsset();
        Map assetMap = this.account.getAssetV2Map();
        if (assetMap.isEmpty()) {
            assetMap = Maps.newHashMap();
        }
        return assetMap;
    }

    public Map<String, Long> getAssetMapForTest() {
        return this.getAssetMap();
    }

    public Map<String, Long> getAssetV2MapForTest() {
        return this.getAssetMapV2();
    }

    public void addAllLatestAssetOperationTimeV2(Map<String, Long> map) {
        this.account = this.account.toBuilder().putAllLatestAssetOperationTimeV2(map).build();
    }

    public Map<String, Long> getLatestAssetOperationTimeMap() {
        return this.account.getLatestAssetOperationTimeMap();
    }

    public Map<String, Long> getLatestAssetOperationTimeMapV2() {
        return this.account.getLatestAssetOperationTimeV2Map();
    }

    public long getLatestAssetOperationTime(String assetName) {
        return this.account.getLatestAssetOperationTimeOrDefault(assetName, 0L);
    }

    public long getLatestAssetOperationTimeV2(String assetName) {
        return this.account.getLatestAssetOperationTimeV2OrDefault(assetName, 0L);
    }

    public void putLatestAssetOperationTimeMap(String key, Long value) {
        this.account = this.account.toBuilder().putLatestAssetOperationTime(key, value.longValue()).build();
    }

    public void putLatestAssetOperationTimeMapV2(String key, Long value) {
        this.account = this.account.toBuilder().putLatestAssetOperationTimeV2(key, value.longValue()).build();
    }

    public int getFrozenCount() {
        return this.getInstance().getFrozenCount();
    }

    public List<Protocol.Account.Frozen> getFrozenList() {
        return this.getInstance().getFrozenList();
    }

    public long getFrozenBalance() {
        List<Protocol.Account.Frozen> frozenList = this.getFrozenList();
        long[] frozenBalance = new long[]{0L};
        frozenList.forEach(frozen -> {
            frozenBalance[0] = Long.sum(frozenBalance[0], frozen.getFrozenBalance());
        });
        return frozenBalance[0];
    }

    public long getFrozenV2BalanceForBandwidth() {
        List<Protocol.Account.FreezeV2> frozenList = this.getFrozenV2List();
        if (frozenList.isEmpty()) {
            return 0L;
        }
        return frozenList.stream().filter(o -> o.getType() == Common.ResourceCode.BANDWIDTH).mapToLong(Protocol.Account.FreezeV2::getAmount).sum();
    }

    public long getAllFrozenBalanceForBandwidth() {
        return this.getFrozenBalance() + this.getAcquiredDelegatedFrozenBalanceForBandwidth() + this.getFrozenV2BalanceForBandwidth() + this.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
    }

    public int getFrozenSupplyCount() {
        return this.getInstance().getFrozenSupplyCount();
    }

    public List<Protocol.Account.Frozen> getFrozenSupplyList() {
        return this.getInstance().getFrozenSupplyList();
    }

    public long getFrozenSupplyBalance() {
        List<Protocol.Account.Frozen> frozenSupplyList = this.getFrozenSupplyList();
        long[] frozenSupplyBalance = new long[]{0L};
        frozenSupplyList.forEach(frozen -> {
            frozenSupplyBalance[0] = Long.sum(frozenSupplyBalance[0], frozen.getFrozenBalance());
        });
        return frozenSupplyBalance[0];
    }

    public ByteString getAssetIssuedName() {
        return this.getInstance().getAssetIssuedName();
    }

    public void setAssetIssuedName(byte[] nameKey) {
        ByteString assetIssuedName = ByteString.copyFrom((byte[])nameKey);
        this.account = this.account.toBuilder().setAssetIssuedName(assetIssuedName).build();
    }

    public ByteString getAssetIssuedID() {
        return this.getInstance().getAssetIssuedID();
    }

    public void setAssetIssuedID(byte[] id) {
        ByteString assetIssuedID = ByteString.copyFrom((byte[])id);
        this.account = this.account.toBuilder().setAssetIssuedID(assetIssuedID).build();
    }

    public long getAllowance() {
        return this.getInstance().getAllowance();
    }

    public void setAllowance(long allowance) {
        this.account = this.account.toBuilder().setAllowance(allowance).build();
    }

    public long getLatestWithdrawTime() {
        return this.getInstance().getLatestWithdrawTime();
    }

    public void setLatestWithdrawTime(long latestWithdrawTime) {
        this.account = this.account.toBuilder().setLatestWithdrawTime(latestWithdrawTime).build();
    }

    public boolean getIsWitness() {
        return this.getInstance().getIsWitness();
    }

    public void setIsWitness(boolean isWitness) {
        this.account = this.account.toBuilder().setIsWitness(isWitness).build();
    }

    public boolean getIsCommittee() {
        return this.getInstance().getIsCommittee();
    }

    public void setIsCommittee(boolean isCommittee) {
        this.account = this.account.toBuilder().setIsCommittee(isCommittee).build();
    }

    public void setFrozenForBandwidth(long frozenBalance, long expireTime) {
        Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(frozenBalance).setExpireTime(expireTime).build();
        long frozenCount = this.getFrozenCount();
        if (frozenCount == 0L) {
            this.setInstance(this.getInstance().toBuilder().addFrozen(newFrozen).build());
        } else {
            this.setInstance(this.getInstance().toBuilder().setFrozen(0, newFrozen).build());
        }
    }

    public void setFrozen(long frozenBalance, long expireTime) {
        Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(frozenBalance).setExpireTime(expireTime).build();
        this.account = this.account.toBuilder().addFrozen(newFrozen).build();
    }

    public long getNetUsage() {
        return this.account.getNetUsage();
    }

    public long getUsage(Common.ResourceCode resourceCode) {
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            return this.account.getNetUsage();
        }
        return this.account.getAccountResource().getEnergyUsage();
    }

    public void setNetUsage(long netUsage) {
        this.account = this.account.toBuilder().setNetUsage(netUsage).build();
    }

    public Protocol.Account.AccountResource getAccountResource() {
        return this.account.getAccountResource();
    }

    public void setFrozenForEnergy(long newFrozenBalanceForEnergy, long time) {
        Protocol.Account.Frozen newFrozenForEnergy = Protocol.Account.Frozen.newBuilder().setFrozenBalance(newFrozenBalanceForEnergy).setExpireTime(time).build();
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setFrozenBalanceForEnergy(newFrozenForEnergy).build();
        this.account = this.account.toBuilder().setAccountResource(newAccountResource).build();
    }

    public long getEnergyFrozenBalance() {
        return this.account.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
    }

    public long getFrozenV2BalanceForEnergy() {
        List<Protocol.Account.FreezeV2> frozenList = this.getFrozenV2List();
        if (frozenList.isEmpty()) {
            return 0L;
        }
        return frozenList.stream().filter(o -> o.getType() == Common.ResourceCode.ENERGY).mapToLong(Protocol.Account.FreezeV2::getAmount).sum();
    }

    public boolean oldTronPowerIsNotInitialized() {
        return this.account.getOldTronPower() == 0L;
    }

    public boolean oldTronPowerIsInvalid() {
        return this.account.getOldTronPower() == -1L;
    }

    public void initializeOldTronPower() {
        long value = this.getTronPower();
        if (value == 0L) {
            value = -1L;
        }
        this.setInstance(this.getInstance().toBuilder().setOldTronPower(value).build());
    }

    public void invalidateOldTronPower() {
        this.setInstance(this.getInstance().toBuilder().setOldTronPower(-1L).build());
    }

    public void setOldTronPower(long value) {
        this.setInstance(this.getInstance().toBuilder().setOldTronPower(value).build());
    }

    public void setFrozenForTronPower(long frozenBalance, long expireTime) {
        Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(frozenBalance).setExpireTime(expireTime).build();
        this.setInstance(this.getInstance().toBuilder().setTronPower(newFrozen).build());
    }

    public void addFrozenForTronPowerV2(long balance) {
        this.addFrozenBalanceForResource(Common.ResourceCode.TRON_POWER, balance);
    }

    public long getTronPowerFrozenBalance() {
        return this.account.getTronPower().getFrozenBalance();
    }

    public long getTronPowerFrozenV2Balance() {
        return this.getFrozenV2List().stream().filter(o -> o.getType() == Common.ResourceCode.TRON_POWER).mapToLong(Protocol.Account.FreezeV2::getAmount).sum();
    }

    public long getEnergyUsage() {
        return this.account.getAccountResource().getEnergyUsage();
    }

    public void setEnergyUsage(long energyUsage) {
        this.account = this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setEnergyUsage(energyUsage).build()).build();
    }

    public long getAllFrozenBalanceForEnergy() {
        return this.getEnergyFrozenBalance() + this.getAcquiredDelegatedFrozenBalanceForEnergy() + this.getFrozenV2BalanceForEnergy() + this.getAcquiredDelegatedFrozenV2BalanceForEnergy();
    }

    public long getLatestConsumeTimeForEnergy() {
        return this.account.getAccountResource().getLatestConsumeTimeForEnergy();
    }

    public void setLatestConsumeTimeForEnergy(long latestTime) {
        this.account = this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setLatestConsumeTimeForEnergy(latestTime).build()).build();
    }

    public long getFreeNetUsage() {
        return this.account.getFreeNetUsage();
    }

    public void setFreeNetUsage(long freeNetUsage) {
        this.account = this.account.toBuilder().setFreeNetUsage(freeNetUsage).build();
    }

    public void addAllFreeAssetNetUsageV2(Map<String, Long> map) {
        this.account = this.account.toBuilder().putAllFreeAssetNetUsageV2(map).build();
    }

    public long getFreeAssetNetUsage(String assetName) {
        return this.account.getFreeAssetNetUsageOrDefault(assetName, 0L);
    }

    public long getFreeAssetNetUsageV2(String assetName) {
        return this.account.getFreeAssetNetUsageV2OrDefault(assetName, 0L);
    }

    public Map<String, Long> getAllFreeAssetNetUsage() {
        return this.account.getFreeAssetNetUsageMap();
    }

    public Map<String, Long> getAllFreeAssetNetUsageV2() {
        return this.account.getFreeAssetNetUsageV2Map();
    }

    public void putFreeAssetNetUsage(String s, long freeAssetNetUsage) {
        this.account = this.account.toBuilder().putFreeAssetNetUsage(s, freeAssetNetUsage).build();
    }

    public void putFreeAssetNetUsageV2(String s, long freeAssetNetUsage) {
        this.account = this.account.toBuilder().putFreeAssetNetUsageV2(s, freeAssetNetUsage).build();
    }

    public long getStorageLimit() {
        return this.account.getAccountResource().getStorageLimit();
    }

    public void setStorageLimit(long limit) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageLimit(limit).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public long getStorageUsage() {
        return this.account.getAccountResource().getStorageUsage();
    }

    public void setStorageUsage(long usage) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageUsage(usage).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public long getStorageLeft() {
        return this.getStorageLimit() - this.getStorageUsage();
    }

    public long getLatestExchangeStorageTime() {
        return this.account.getAccountResource().getLatestExchangeStorageTime();
    }

    public void setLatestExchangeStorageTime(long time) {
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setLatestExchangeStorageTime(time).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public void addStorageUsage(long storageUsage) {
        if (storageUsage <= 0L) {
            return;
        }
        Protocol.Account.AccountResource accountResource = this.account.getAccountResource();
        accountResource = accountResource.toBuilder().setStorageUsage(accountResource.getStorageUsage() + storageUsage).build();
        this.account = this.account.toBuilder().setAccountResource(accountResource).build();
    }

    public Protocol.Permission getPermissionById(int id) {
        if (id == 0) {
            if (this.account.hasOwnerPermission()) {
                return this.account.getOwnerPermission();
            }
            return AccountCapsule.getDefaultPermission(this.account.getAddress());
        }
        if (id == 1) {
            if (this.account.hasWitnessPermission()) {
                return this.account.getWitnessPermission();
            }
            return null;
        }
        for (Protocol.Permission permission : this.account.getActivePermissionList()) {
            if (id != permission.getId()) continue;
            return permission;
        }
        return null;
    }

    public void updatePermissions(Protocol.Permission owner, Protocol.Permission witness, List<Protocol.Permission> actives) {
        Protocol.Account.Builder builder = this.account.toBuilder();
        owner = owner.toBuilder().setId(0).build();
        builder.setOwnerPermission(owner);
        if (witness != null && builder.getIsWitness()) {
            witness = witness.toBuilder().setId(1).build();
            builder.setWitnessPermission(witness);
        }
        builder.clearActivePermission();
        if (actives != null) {
            for (int i = 0; i < actives.size(); ++i) {
                Protocol.Permission permission = actives.get(i).toBuilder().setId(i + 2).build();
                builder.addActivePermission(permission);
            }
        }
        this.account = builder.build();
    }

    public void updateAccountType(Protocol.AccountType accountType) {
        this.account = this.account.toBuilder().setType(accountType).build();
    }

    public void clearDelegatedResource() {
        Protocol.Account.Builder builder = this.account.toBuilder();
        Protocol.Account.AccountResource newAccountResource = this.getAccountResource().toBuilder().setAcquiredDelegatedFrozenBalanceForEnergy(0L).setAcquiredDelegatedFrozenV2BalanceForEnergy(0L).build();
        builder.setAccountResource(newAccountResource);
        builder.setAcquiredDelegatedFrozenBalanceForBandwidth(0L).setAcquiredDelegatedFrozenV2BalanceForBandwidth(0L);
        this.account = builder.build();
    }

    public void importAsset(byte[] key) {
        this.account = AssetUtil.importAsset(this.account, key);
    }

    public void importAllAsset() {
        if (!this.flag) {
            this.account = AssetUtil.importAllAsset(this.account);
            this.flag = true;
        }
    }

    public void addUnfrozenV2(Protocol.Account.UnFreezeV2 unfrozenV2) {
        if (Objects.isNull(unfrozenV2)) {
            return;
        }
        this.account = this.account.toBuilder().addUnfrozenV2(unfrozenV2).build();
    }

    public void addAllUnfrozenV2(List<Protocol.Account.UnFreezeV2> unFreezeV2List) {
        if (CollectionUtils.isEmpty(unFreezeV2List)) {
            return;
        }
        this.account = this.account.toBuilder().addAllUnfrozenV2(unFreezeV2List).build();
    }

    public void clearUnfrozenV2() {
        this.account = this.account.toBuilder().clearUnfrozenV2().build();
    }

    public void clearFrozenV2() {
        this.account = this.account.toBuilder().clearFrozenV2().build();
    }

    public void setNewWindowSize(Common.ResourceCode resourceCode, long newWindowSize) {
        this.account = resourceCode == Common.ResourceCode.BANDWIDTH ? this.account.toBuilder().setNetWindowSize(newWindowSize).build() : this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setEnergyWindowSize(newWindowSize).build()).build();
    }

    public long getWindowSize(Common.ResourceCode resourceCode) {
        boolean windowOptimized;
        long windowSize;
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            windowSize = this.account.getNetWindowSize();
            windowOptimized = this.account.getNetWindowOptimized();
        } else {
            windowSize = this.account.getAccountResource().getEnergyWindowSize();
            windowOptimized = this.account.getAccountResource().getEnergyWindowOptimized();
        }
        if (windowSize == 0L) {
            return 28800L;
        }
        if (windowOptimized) {
            return windowSize < 1000L ? 28800L : windowSize / 1000L;
        }
        return windowSize;
    }

    public long getWindowSizeV2(Common.ResourceCode resourceCode) {
        boolean windowOptimized;
        long windowSize;
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            windowSize = this.account.getNetWindowSize();
            windowOptimized = this.account.getNetWindowOptimized();
        } else {
            windowSize = this.account.getAccountResource().getEnergyWindowSize();
            windowOptimized = this.account.getAccountResource().getEnergyWindowOptimized();
        }
        if (windowSize == 0L) {
            return 28800000L;
        }
        if (windowOptimized) {
            return windowSize;
        }
        return windowSize * 1000L;
    }

    public boolean getWindowOptimized(Common.ResourceCode resourceCode) {
        boolean windowOptimized = resourceCode == Common.ResourceCode.BANDWIDTH ? this.account.getNetWindowOptimized() : this.account.getAccountResource().getEnergyWindowOptimized();
        return windowOptimized;
    }

    public void setWindowOptimized(Common.ResourceCode resourceCode, boolean windowOptimized) {
        this.account = resourceCode == Common.ResourceCode.BANDWIDTH ? this.account.toBuilder().setNetWindowOptimized(windowOptimized).build() : this.account.toBuilder().setAccountResource(this.account.getAccountResource().toBuilder().setEnergyWindowOptimized(windowOptimized).build()).build();
    }

    public long getLastConsumeTime(Common.ResourceCode resourceCode) {
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            return this.account.getLatestConsumeTime();
        }
        return this.account.getAccountResource().getLatestConsumeTimeForEnergy();
    }

    public long getFrozenV2BalanceWithDelegated(Common.ResourceCode resourceCode) {
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            return this.getFrozenV2BalanceForBandwidth() + this.getDelegatedFrozenV2BalanceForBandwidth();
        }
        return this.getFrozenV2BalanceForEnergy() + this.getDelegatedFrozenV2BalanceForEnergy();
    }

    public void setNewWindowSizeV2(Common.ResourceCode resourceCode, long newWindowSize) {
        this.setNewWindowSize(resourceCode, newWindowSize);
        if (!this.getWindowOptimized(resourceCode)) {
            this.setWindowOptimized(resourceCode, true);
        }
    }

    public void setUsage(Common.ResourceCode resourceCode, long usage) {
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            this.setNetUsage(usage);
        } else {
            this.setEnergyUsage(usage);
        }
    }

    public void setLatestTime(Common.ResourceCode resourceCode, long time) {
        if (resourceCode == Common.ResourceCode.BANDWIDTH) {
            this.setLatestConsumeTime(time);
        } else {
            this.setLatestConsumeTimeForEnergy(time);
        }
    }
}

