/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iq80.leveldb.DBComparator;
import org.iq80.leveldb.Options;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.DirectComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.MarketOrderPriceComparatorForLevelDB;
import org.tron.common.utils.MarketOrderPriceComparatorForRockDB;
import org.tron.common.utils.StorageUtils;
import org.tron.core.capsule.MarketOrderIdListCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class MarketPairPriceToOrderStore
extends TronStoreWithRevoking<MarketOrderIdListCapsule> {
    @Autowired
    protected MarketPairPriceToOrderStore(@Value(value="market_pair_price_to_order") String dbName) {
        super(dbName);
    }

    @Override
    protected Options getOptionsByDbNameForLevelDB(String dbName) {
        Options options = StorageUtils.getOptionsByDbName(dbName);
        options.comparator((DBComparator)new MarketOrderPriceComparatorForLevelDB());
        return options;
    }

    @Override
    protected DirectComparator getDirectComparator() {
        ComparatorOptions comparatorOptions = new ComparatorOptions();
        return new MarketOrderPriceComparatorForRockDB(comparatorOptions);
    }

    @Override
    public MarketOrderIdListCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.get(key);
        return new MarketOrderIdListCapsule(value);
    }

    public List<byte[]> getKeysNext(byte[] key, long limit) {
        if (limit <= 0L) {
            return Collections.emptyList();
        }
        return this.revokingDB.getKeysNext(key, limit);
    }

    public List<byte[]> getPriceKeysList(byte[] sellTokenId, byte[] buyTokenId, long count) {
        byte[] headKey = MarketUtils.getPairPriceHeadKey(sellTokenId, buyTokenId);
        return this.getPriceKeysList(headKey, count, count, true);
    }

    public List<byte[]> getPriceKeysList(byte[] headKey, long count, long totalCount, boolean skip) {
        List<byte[]> result = new ArrayList<byte[]>();
        if (this.has(headKey)) {
            long limit = count > totalCount ? totalCount : count;
            result = skip ? this.getKeysNext(headKey, limit + 1L).subList(1, (int)(limit + 1L)) : this.getKeysNext(headKey, limit);
        }
        return result;
    }

    public byte[] getNextKey(byte[] key) {
        List<byte[]> keysNext = this.revokingDB.getKeysNext(key, 2L);
        if (keysNext.size() < 2) {
            return new byte[0];
        }
        return ByteUtil.equals((byte[])keysNext.get(0), (byte[])key) ? keysNext.get(1) : keysNext.get(0);
    }
}

