/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class DynamicPropertiesStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private static final byte[] LATEST_BLOCK_HEADER_TIMESTAMP = "latest_block_header_timestamp".getBytes();
    private static final byte[] LATEST_BLOCK_HEADER_NUMBER = "latest_block_header_number".getBytes();
    private static final byte[] LATEST_BLOCK_HEADER_HASH = "latest_block_header_hash".getBytes();
    private static final byte[] STATE_FLAG = "state_flag".getBytes();
    private static final byte[] LATEST_SOLIDIFIED_BLOCK_NUM = "LATEST_SOLIDIFIED_BLOCK_NUM".getBytes();
    private static final byte[] LATEST_PROPOSAL_NUM = "LATEST_PROPOSAL_NUM".getBytes();
    private static final byte[] LATEST_EXCHANGE_NUM = "LATEST_EXCHANGE_NUM".getBytes();
    private static final byte[] BLOCK_FILLED_SLOTS = "BLOCK_FILLED_SLOTS".getBytes();
    private static final byte[] BLOCK_FILLED_SLOTS_INDEX = "BLOCK_FILLED_SLOTS_INDEX".getBytes();
    private static final byte[] NEXT_MAINTENANCE_TIME = "NEXT_MAINTENANCE_TIME".getBytes();
    private static final byte[] MAX_FROZEN_TIME = "MAX_FROZEN_TIME".getBytes();
    private static final byte[] MIN_FROZEN_TIME = "MIN_FROZEN_TIME".getBytes();
    private static final byte[] MAX_FROZEN_SUPPLY_NUMBER = "MAX_FROZEN_SUPPLY_NUMBER".getBytes();
    private static final byte[] MAX_FROZEN_SUPPLY_TIME = "MAX_FROZEN_SUPPLY_TIME".getBytes();
    private static final byte[] MIN_FROZEN_SUPPLY_TIME = "MIN_FROZEN_SUPPLY_TIME".getBytes();
    private static final byte[] WITNESS_ALLOWANCE_FROZEN_TIME = "WITNESS_ALLOWANCE_FROZEN_TIME".getBytes();
    private static final byte[] MAINTENANCE_TIME_INTERVAL = "MAINTENANCE_TIME_INTERVAL".getBytes();
    private static final byte[] ACCOUNT_UPGRADE_COST = "ACCOUNT_UPGRADE_COST".getBytes();
    private static final byte[] WITNESS_PAY_PER_BLOCK = "WITNESS_PAY_PER_BLOCK".getBytes();
    private static final byte[] WITNESS_127_PAY_PER_BLOCK = "WITNESS_127_PAY_PER_BLOCK".getBytes();
    private static final byte[] WITNESS_STANDBY_ALLOWANCE = "WITNESS_STANDBY_ALLOWANCE".getBytes();
    private static final byte[] ENERGY_FEE = "ENERGY_FEE".getBytes();
    private static final long DEFAULT_ENERGY_FEE = 100L;
    public static final String DEFAULT_ENERGY_PRICE_HISTORY = "0:100";
    private static final byte[] MAX_CPU_TIME_OF_ONE_TX = "MAX_CPU_TIME_OF_ONE_TX".getBytes();
    private static final byte[] CREATE_ACCOUNT_FEE = "CREATE_ACCOUNT_FEE".getBytes();
    private static final byte[] CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT = "CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT".getBytes();
    private static final byte[] CREATE_NEW_ACCOUNT_BANDWIDTH_RATE = "CREATE_NEW_ACCOUNT_BANDWIDTH_RATE".getBytes();
    private static final byte[] TRANSACTION_FEE = "TRANSACTION_FEE".getBytes();
    private static final long DEFAULT_TRANSACTION_FEE = 10L;
    public static final String DEFAULT_BANDWIDTH_PRICE_HISTORY = "0:10";
    private static final byte[] ASSET_ISSUE_FEE = "ASSET_ISSUE_FEE".getBytes();
    private static final byte[] UPDATE_ACCOUNT_PERMISSION_FEE = "UPDATE_ACCOUNT_PERMISSION_FEE".getBytes();
    private static final byte[] MULTI_SIGN_FEE = "MULTI_SIGN_FEE".getBytes();
    private static final byte[] SHIELDED_TRANSACTION_FEE = "SHIELDED_TRANSACTION_FEE".getBytes();
    private static final byte[] SHIELDED_TRANSACTION_CREATE_ACCOUNT_FEE = "SHIELDED_TRANSACTION_CREATE_ACCOUNT_FEE".getBytes();
    private static final byte[] TOTAL_SHIELDED_POOL_VALUE = "TOTAL_SHIELDED_POOL_VALUE".getBytes();
    private static final byte[] EXCHANGE_CREATE_FEE = "EXCHANGE_CREATE_FEE".getBytes();
    private static final byte[] EXCHANGE_BALANCE_LIMIT = "EXCHANGE_BALANCE_LIMIT".getBytes();
    private static final byte[] TOTAL_TRANSACTION_COST = "TOTAL_TRANSACTION_COST".getBytes();
    private static final byte[] TOTAL_CREATE_ACCOUNT_COST = "TOTAL_CREATE_ACCOUNT_COST".getBytes();
    private static final byte[] TOTAL_CREATE_WITNESS_COST = "TOTAL_CREATE_WITNESS_FEE".getBytes();
    private static final byte[] TOTAL_STORAGE_POOL = "TOTAL_STORAGE_POOL".getBytes();
    private static final byte[] TOTAL_STORAGE_TAX = "TOTAL_STORAGE_TAX".getBytes();
    private static final byte[] TOTAL_STORAGE_RESERVED = "TOTAL_STORAGE_RESERVED".getBytes();
    private static final byte[] STORAGE_EXCHANGE_TAX_RATE = "STORAGE_EXCHANGE_TAX_RATE".getBytes();
    private static final String FORK_CONTROLLER = "FORK_CONTROLLER";
    private static final String FORK_PREFIX = "FORK_VERSION_";
    private static final byte[] VERSION_NUMBER = "VERSION_NUMBER".getBytes();
    private static final byte[] REMOVE_THE_POWER_OF_THE_GR = "REMOVE_THE_POWER_OF_THE_GR".getBytes();
    private static final byte[] ALLOW_DELEGATE_RESOURCE = "ALLOW_DELEGATE_RESOURCE".getBytes();
    private static final byte[] ALLOW_ADAPTIVE_ENERGY = "ALLOW_ADAPTIVE_ENERGY".getBytes();
    private static final byte[] ALLOW_UPDATE_ACCOUNT_NAME = "ALLOW_UPDATE_ACCOUNT_NAME".getBytes();
    private static final byte[] ALLOW_SAME_TOKEN_NAME = " ALLOW_SAME_TOKEN_NAME".getBytes();
    private static final byte[] ALLOW_CREATION_OF_CONTRACTS = "ALLOW_CREATION_OF_CONTRACTS".getBytes();
    private static final byte[] TOTAL_SIGN_NUM = "TOTAL_SIGN_NUM".getBytes();
    private static final byte[] ALLOW_MULTI_SIGN = "ALLOW_MULTI_SIGN".getBytes();
    private static final byte[] TOKEN_ID_NUM = "TOKEN_ID_NUM".getBytes();
    private static final byte[] TOKEN_UPDATE_DONE = "TOKEN_UPDATE_DONE".getBytes();
    private static final byte[] ABI_MOVE_DONE = "ABI_MOVE_DONE".getBytes();
    private static final byte[] ALLOW_TVM_TRANSFER_TRC10 = "ALLOW_TVM_TRANSFER_TRC10".getBytes();
    private static final byte[] ALLOW_SHIELDED_TRANSACTION = "ALLOW_SHIELDED_TRANSACTION".getBytes();
    private static final byte[] ALLOW_SHIELDED_TRC20_TRANSACTION = "ALLOW_SHIELDED_TRC20_TRANSACTION".getBytes();
    private static final byte[] ALLOW_TVM_ISTANBUL = "ALLOW_TVM_ISTANBUL".getBytes();
    private static final byte[] ALLOW_TVM_CONSTANTINOPLE = "ALLOW_TVM_CONSTANTINOPLE".getBytes();
    private static final byte[] ALLOW_TVM_SOLIDITY_059 = "ALLOW_TVM_SOLIDITY_059".getBytes();
    private static final byte[] FORBID_TRANSFER_TO_CONTRACT = "FORBID_TRANSFER_TO_CONTRACT".getBytes();
    private static final byte[] ALLOW_PROTO_FILTER_NUM = "ALLOW_PROTO_FILTER_NUM".getBytes();
    private static final byte[] AVAILABLE_CONTRACT_TYPE = "AVAILABLE_CONTRACT_TYPE".getBytes();
    private static final byte[] ACTIVE_DEFAULT_OPERATIONS = "ACTIVE_DEFAULT_OPERATIONS".getBytes();
    private static final byte[] ALLOW_ACCOUNT_STATE_ROOT = "ALLOW_ACCOUNT_STATE_ROOT".getBytes();
    private static final byte[] CURRENT_CYCLE_NUMBER = "CURRENT_CYCLE_NUMBER".getBytes();
    private static final byte[] CHANGE_DELEGATION = "CHANGE_DELEGATION".getBytes();
    private static final byte[] ALLOW_PBFT = "ALLOW_PBFT".getBytes();
    private static final byte[] ALLOW_MARKET_TRANSACTION = "ALLOW_MARKET_TRANSACTION".getBytes();
    private static final byte[] MARKET_SELL_FEE = "MARKET_SELL_FEE".getBytes();
    private static final byte[] MARKET_CANCEL_FEE = "MARKET_CANCEL_FEE".getBytes();
    private static final byte[] MARKET_QUANTITY_LIMIT = "MARKET_QUANTITY_LIMIT".getBytes();
    private static final byte[] ALLOW_TRANSACTION_FEE_POOL = "ALLOW_TRANSACTION_FEE_POOL".getBytes();
    private static final byte[] TRANSACTION_FEE_POOL = "TRANSACTION_FEE_POOL".getBytes();
    private static final byte[] MAX_FEE_LIMIT = "MAX_FEE_LIMIT".getBytes();
    private static final byte[] BURN_TRX_AMOUNT = "BURN_TRX_AMOUNT".getBytes();
    private static final byte[] ALLOW_BLACKHOLE_OPTIMIZATION = "ALLOW_BLACKHOLE_OPTIMIZATION".getBytes();
    private static final byte[] ALLOW_NEW_RESOURCE_MODEL = "ALLOW_NEW_RESOURCE_MODEL".getBytes();
    private static final byte[] ALLOW_TVM_FREEZE = "ALLOW_TVM_FREEZE".getBytes();
    private static final byte[] ALLOW_TVM_VOTE = "ALLOW_TVM_VOTE".getBytes();
    private static final byte[] ALLOW_TVM_LONDON = "ALLOW_TVM_LONDON".getBytes();
    private static final byte[] ALLOW_TVM_COMPATIBLE_EVM = "ALLOW_TVM_COMPATIBLE_EVM".getBytes();
    private static final byte[] NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE = "NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE".getBytes();
    private static final byte[] ALLOW_ACCOUNT_ASSET_OPTIMIZATION = "ALLOW_ACCOUNT_ASSET_OPTIMIZATION".getBytes();
    private static final byte[] ALLOW_ASSET_OPTIMIZATION = "ALLOW_ASSET_OPTIMIZATION".getBytes();
    private static final byte[] ENERGY_PRICE_HISTORY = "ENERGY_PRICE_HISTORY".getBytes();
    private static final byte[] ENERGY_PRICE_HISTORY_DONE = "ENERGY_PRICE_HISTORY_DONE".getBytes();
    private static final byte[] BANDWIDTH_PRICE_HISTORY = "BANDWIDTH_PRICE_HISTORY".getBytes();
    private static final byte[] BANDWIDTH_PRICE_HISTORY_DONE = "BANDWIDTH_PRICE_HISTORY_DONE".getBytes();
    private static final byte[] SET_BLACKHOLE_ACCOUNT_PERMISSION = "SET_BLACKHOLE_ACCOUNT_PERMISSION".getBytes();
    private static final byte[] ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX = "ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX".getBytes();
    private static final byte[] ALLOW_NEW_REWARD = "ALLOW_NEW_REWARD".getBytes();
    private static final byte[] MEMO_FEE = "MEMO_FEE".getBytes();
    private static final byte[] MEMO_FEE_HISTORY = "MEMO_FEE_HISTORY".getBytes();
    private static final byte[] ALLOW_DELEGATE_OPTIMIZATION = "ALLOW_DELEGATE_OPTIMIZATION".getBytes();
    private static final byte[] ALLOW_DYNAMIC_ENERGY = "ALLOW_DYNAMIC_ENERGY".getBytes();
    private static final byte[] DYNAMIC_ENERGY_THRESHOLD = "DYNAMIC_ENERGY_THRESHOLD".getBytes();
    private static final byte[] DYNAMIC_ENERGY_INCREASE_FACTOR = "DYNAMIC_ENERGY_INCREASE_FACTOR".getBytes();
    private static final byte[] DYNAMIC_ENERGY_MAX_FACTOR = "DYNAMIC_ENERGY_MAX_FACTOR".getBytes();
    private static final byte[] UNFREEZE_DELAY_DAYS = "UNFREEZE_DELAY_DAYS".getBytes();
    private static final byte[] ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID = "ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID".getBytes();
    private static final byte[] ALLOW_TVM_SHANGHAI = "ALLOW_TVM_SHANGHAI".getBytes();
    private static final byte[] ALLOW_CANCEL_ALL_UNFREEZE_V2 = "ALLOW_CANCEL_ALL_UNFREEZE_V2".getBytes();
    private static final byte[] MAX_DELEGATE_LOCK_PERIOD = "MAX_DELEGATE_LOCK_PERIOD".getBytes();

    @Autowired
    private DynamicPropertiesStore(@Value(value="properties") String dbName) {
        block230: {
            block229: {
                byte[] bytes;
                String contractType;
                super(dbName);
                try {
                    this.getTotalSignNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalSignNum(5);
                }
                try {
                    this.getAllowMultiSign();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowMultiSign(CommonParameter.getInstance().getAllowMultiSign());
                }
                try {
                    this.getLatestBlockHeaderTimestamp();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestBlockHeaderTimestamp(0L);
                }
                try {
                    this.getLatestBlockHeaderNumber();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestBlockHeaderNumber(0L);
                }
                try {
                    this.getLatestBlockHeaderHash();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestBlockHeaderHash(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)"00")));
                }
                try {
                    this.getStateFlag();
                }
                catch (IllegalArgumentException e) {
                    this.saveStateFlag(0);
                }
                try {
                    this.getLatestSolidifiedBlockNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestSolidifiedBlockNum(0L);
                }
                try {
                    this.getLatestProposalNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestProposalNum(0L);
                }
                try {
                    this.getLatestExchangeNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveLatestExchangeNum(0L);
                }
                try {
                    this.getBlockFilledSlotsIndex();
                }
                catch (IllegalArgumentException e) {
                    this.saveBlockFilledSlotsIndex(0);
                }
                try {
                    this.getTokenIdNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveTokenIdNum(1000000L);
                }
                try {
                    this.getTokenUpdateDone();
                }
                catch (IllegalArgumentException e) {
                    this.saveTokenUpdateDone(0L);
                }
                try {
                    this.getAbiMoveDone();
                }
                catch (IllegalArgumentException e) {
                    this.saveAbiMoveDone(0L);
                }
                try {
                    this.getMaxFrozenTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaxFrozenTime(3);
                }
                try {
                    this.getMinFrozenTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveMinFrozenTime(3);
                }
                try {
                    this.getMaxFrozenSupplyNumber();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaxFrozenSupplyNumber(10);
                }
                try {
                    this.getMaxFrozenSupplyTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaxFrozenSupplyTime(3652);
                }
                try {
                    this.getMinFrozenSupplyTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveMinFrozenSupplyTime(1);
                }
                try {
                    this.getWitnessAllowanceFrozenTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveWitnessAllowanceFrozenTime(1);
                }
                try {
                    this.getWitnessPayPerBlock();
                }
                catch (IllegalArgumentException e) {
                    this.saveWitnessPayPerBlock(32000000L);
                }
                try {
                    this.getWitnessStandbyAllowance();
                }
                catch (IllegalArgumentException e) {
                    this.saveWitnessStandbyAllowance(115200000000L);
                }
                try {
                    this.getMaintenanceTimeInterval();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaintenanceTimeInterval(CommonParameter.getInstance().getMaintenanceTimeInterval());
                }
                try {
                    this.getAccountUpgradeCost();
                }
                catch (IllegalArgumentException e) {
                    this.saveAccountUpgradeCost(9999000000L);
                }
                try {
                    this.getPublicNetUsage();
                }
                catch (IllegalArgumentException e) {
                    this.savePublicNetUsage(0L);
                }
                try {
                    this.getOneDayNetLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveOneDayNetLimit(57600000000L);
                }
                try {
                    this.getPublicNetLimit();
                }
                catch (IllegalArgumentException e) {
                    this.savePublicNetLimit(14400000000L);
                }
                try {
                    this.getPublicNetTime();
                }
                catch (IllegalArgumentException e) {
                    this.savePublicNetTime(0L);
                }
                try {
                    this.getFreeNetLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveFreeNetLimit(5000L);
                }
                try {
                    this.getTotalNetWeight();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalNetWeight(0L);
                }
                try {
                    this.getTotalNetLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalNetLimit(43200000000L);
                }
                try {
                    this.getTotalEnergyWeight();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyWeight(0L);
                }
                try {
                    this.getTotalTronPowerWeight();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalTronPowerWeight(0L);
                }
                try {
                    this.getAllowAdaptiveEnergy();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowAdaptiveEnergy(CommonParameter.getInstance().getAllowAdaptiveEnergy());
                }
                try {
                    this.getAdaptiveResourceLimitTargetRatio();
                }
                catch (IllegalArgumentException e) {
                    this.saveAdaptiveResourceLimitTargetRatio(14400L);
                }
                try {
                    this.getTotalEnergyLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyLimit(50000000000L);
                }
                try {
                    this.getEnergyFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveEnergyFee(100L);
                }
                try {
                    this.getMaxCpuTimeOfOneTx();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaxCpuTimeOfOneTx(50L);
                }
                try {
                    this.getCreateAccountFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveCreateAccountFee(100000L);
                }
                try {
                    this.getShieldedTransactionFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveShieldedTransactionFee(100000L);
                }
                try {
                    this.getShieldedTransactionCreateAccountFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveShieldedTransactionCreateAccountFee(1000000L);
                }
                try {
                    this.getTotalShieldedPoolValue();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalShieldedPoolValue(0L);
                }
                try {
                    this.getCreateNewAccountFeeInSystemContract();
                }
                catch (IllegalArgumentException e) {
                    this.saveCreateNewAccountFeeInSystemContract(0L);
                }
                try {
                    this.getCreateNewAccountBandwidthRate();
                }
                catch (IllegalArgumentException e) {
                    this.saveCreateNewAccountBandwidthRate(1L);
                }
                try {
                    this.getTransactionFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveTransactionFee(10L);
                }
                try {
                    this.getAssetIssueFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveAssetIssueFee(1024000000L);
                }
                try {
                    this.getUpdateAccountPermissionFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveUpdateAccountPermissionFee(100000000L);
                }
                try {
                    this.getMultiSignFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveMultiSignFee(1000000L);
                }
                try {
                    this.getExchangeCreateFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveExchangeCreateFee(1024000000L);
                }
                try {
                    this.getExchangeBalanceLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveExchangeBalanceLimit(1000000000000000L);
                }
                try {
                    this.getAllowMarketTransaction();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowMarketTransaction(CommonParameter.getInstance().getAllowMarketTransaction());
                }
                try {
                    this.getMarketSellFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveMarketSellFee(0L);
                }
                try {
                    this.getMarketCancelFee();
                }
                catch (IllegalArgumentException e) {
                    this.saveMarketCancelFee(0L);
                }
                try {
                    this.getMarketQuantityLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveMarketQuantityLimit(1000000000000000L);
                }
                try {
                    this.getAllowTransactionFeePool();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTransactionFeePool(CommonParameter.getInstance().getAllowTransactionFeePool());
                }
                try {
                    this.getTransactionFeePool();
                }
                catch (IllegalArgumentException e) {
                    this.saveTransactionFeePool(0L);
                }
                try {
                    this.getTotalTransactionCost();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalTransactionCost(0L);
                }
                try {
                    this.getTotalCreateWitnessCost();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalCreateWitnessFee(0L);
                }
                try {
                    this.getTotalCreateAccountCost();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalCreateAccountFee(0L);
                }
                try {
                    this.getTotalStoragePool();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalStoragePool(100000000000000L);
                }
                try {
                    this.getTotalStorageTax();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalStorageTax(0L);
                }
                try {
                    this.getTotalStorageReserved();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalStorageReserved(0x2000000000L);
                }
                try {
                    this.getStorageExchangeTaxRate();
                }
                catch (IllegalArgumentException e) {
                    this.saveStorageExchangeTaxRate(10L);
                }
                try {
                    this.getRemoveThePowerOfTheGr();
                }
                catch (IllegalArgumentException e) {
                    this.saveRemoveThePowerOfTheGr(0L);
                }
                try {
                    this.getAllowDelegateResource();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowDelegateResource(CommonParameter.getInstance().getAllowDelegateResource());
                }
                try {
                    this.getAllowTvmTransferTrc10();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmTransferTrc10(CommonParameter.getInstance().getAllowTvmTransferTrc10());
                }
                try {
                    this.getAllowTvmConstantinople();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmConstantinople(CommonParameter.getInstance().getAllowTvmConstantinople());
                }
                try {
                    this.getAllowTvmSolidity059();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmSolidity059(CommonParameter.getInstance().getAllowTvmSolidity059());
                }
                try {
                    this.getForbidTransferToContract();
                }
                catch (IllegalArgumentException e) {
                    this.saveForbidTransferToContract(CommonParameter.getInstance().getForbidTransferToContract());
                }
                try {
                    this.getAvailableContractType();
                }
                catch (IllegalArgumentException e) {
                    contractType = "7fff1fc0037e0000000000000000000000000000000000000000000000000000";
                    bytes = ByteArray.fromHexString((String)contractType);
                    this.saveAvailableContractType(bytes);
                }
                try {
                    this.getActiveDefaultOperations();
                }
                catch (IllegalArgumentException e) {
                    contractType = "7fff1fc0033e0000000000000000000000000000000000000000000000000000";
                    bytes = ByteArray.fromHexString((String)contractType);
                    this.saveActiveDefaultOperations(bytes);
                }
                try {
                    this.getAllowSameTokenName();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowSameTokenName(CommonParameter.getInstance().getAllowSameTokenName());
                }
                try {
                    this.getAllowUpdateAccountName();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowUpdateAccountName(0L);
                }
                try {
                    this.getAllowCreationOfContracts();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowCreationOfContracts(CommonParameter.getInstance().getAllowCreationOfContracts());
                }
                try {
                    this.getAllowShieldedTransaction();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowShieldedTransaction(0L);
                }
                try {
                    this.getAllowShieldedTRC20Transaction();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowShieldedTRC20Transaction(CommonParameter.getInstance().getAllowShieldedTRC20Transaction());
                }
                try {
                    this.getAllowTvmIstanbul();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmIstanbul(CommonParameter.getInstance().getAllowTvmIstanbul());
                }
                try {
                    this.getBlockFilledSlots();
                }
                catch (IllegalArgumentException e) {
                    int[] blockFilledSlots = new int[this.getBlockFilledSlotsNumber()];
                    Arrays.fill(blockFilledSlots, 1);
                    this.saveBlockFilledSlots(blockFilledSlots);
                }
                try {
                    this.getNextMaintenanceTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveNextMaintenanceTime(Long.parseLong(CommonParameter.getInstance().getGenesisBlock().getTimestamp()));
                }
                try {
                    this.getTotalEnergyCurrentLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyCurrentLimit(this.getTotalEnergyLimit());
                }
                try {
                    this.getTotalEnergyTargetLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyTargetLimit(this.getTotalEnergyLimit() / 14400L);
                }
                try {
                    this.getTotalEnergyAverageUsage();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyAverageUsage(0L);
                }
                try {
                    this.getAdaptiveResourceLimitMultiplier();
                }
                catch (IllegalArgumentException e) {
                    this.saveAdaptiveResourceLimitMultiplier(1000L);
                }
                try {
                    this.getTotalEnergyAverageTime();
                }
                catch (IllegalArgumentException e) {
                    this.saveTotalEnergyAverageTime(0L);
                }
                try {
                    this.getBlockEnergyUsage();
                }
                catch (IllegalArgumentException e) {
                    this.saveBlockEnergyUsage(0L);
                }
                try {
                    this.getAllowAccountStateRoot();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowAccountStateRoot(CommonParameter.getInstance().getAllowAccountStateRoot());
                }
                try {
                    this.getAllowProtoFilterNum();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowProtoFilterNum(CommonParameter.getInstance().getAllowProtoFilterNum());
                }
                try {
                    this.getChangeDelegation();
                }
                catch (IllegalArgumentException e) {
                    this.saveChangeDelegation(CommonParameter.getInstance().getChangedDelegation());
                }
                try {
                    this.getAllowPBFT();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowPBFT(CommonParameter.getInstance().getAllowPBFT());
                }
                try {
                    this.getMaxFeeLimit();
                }
                catch (IllegalArgumentException e) {
                    this.saveMaxFeeLimit(1000000000L);
                }
                try {
                    this.getBurnTrxAmount();
                }
                catch (IllegalArgumentException e) {
                    this.saveBurnTrx(0L);
                }
                try {
                    this.getAllowBlackHoleOptimization();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowBlackHoleOptimization(CommonParameter.getInstance().getAllowBlackHoleOptimization());
                }
                try {
                    this.getAllowNewResourceModel();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowNewResourceModel(CommonParameter.getInstance().getAllowNewResourceModel());
                }
                try {
                    this.getAllowTvmFreeze();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmFreeze(CommonParameter.getInstance().getAllowTvmFreeze());
                }
                try {
                    this.getAllowTvmVote();
                }
                catch (IllegalArgumentException e) {
                    this.saveAllowTvmVote(CommonParameter.getInstance().getAllowTvmVote());
                    if (CommonParameter.getInstance().getAllowTvmVote() != 1L) break block229;
                    this.put(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE, new BytesCapsule(ByteArray.fromLong((long)this.getCurrentCycleNumber())));
                }
            }
            try {
                this.getAllowTvmLondon();
            }
            catch (IllegalArgumentException e) {
                this.saveAllowTvmLondon(CommonParameter.getInstance().getAllowTvmLondon());
            }
            try {
                this.getAllowTvmCompatibleEvm();
            }
            catch (IllegalArgumentException e) {
                this.saveAllowTvmCompatibleEvm(CommonParameter.getInstance().getAllowTvmCompatibleEvm());
            }
            try {
                this.getAllowAssetOptimization();
            }
            catch (IllegalArgumentException e) {
                this.setAllowAssetOptimization(CommonParameter.getInstance().getAllowAssetOptimization());
            }
            try {
                this.getAllowAccountAssetOptimization();
            }
            catch (IllegalArgumentException e) {
                this.setAllowAccountAssetOptimization(CommonParameter.getInstance().getAllowAccountAssetOptimization());
            }
            try {
                this.getEnergyPriceHistoryDone();
            }
            catch (IllegalArgumentException e) {
                this.saveEnergyPriceHistoryDone(0L);
            }
            try {
                this.getEnergyPriceHistory();
            }
            catch (IllegalArgumentException e) {
                this.saveEnergyPriceHistory(DEFAULT_ENERGY_PRICE_HISTORY);
            }
            try {
                this.getBandwidthPriceHistoryDone();
            }
            catch (IllegalArgumentException e) {
                this.saveBandwidthPriceHistoryDone(0L);
            }
            try {
                this.getBandwidthPriceHistory();
            }
            catch (IllegalArgumentException e) {
                this.saveBandwidthPriceHistory(DEFAULT_BANDWIDTH_PRICE_HISTORY);
            }
            try {
                this.getSetBlackholeAccountPermission();
            }
            catch (IllegalArgumentException e) {
                this.saveSetBlackholePermission(0L);
            }
            try {
                this.getAllowHigherLimitForMaxCpuTimeOfOneTx();
            }
            catch (IllegalArgumentException e) {
                this.saveAllowHigherLimitForMaxCpuTimeOfOneTx(CommonParameter.getInstance().getAllowHigherLimitForMaxCpuTimeOfOneTx());
            }
            try {
                this.getNewRewardAlgorithmEffectiveCycle();
            }
            catch (IllegalArgumentException e) {
                if (CommonParameter.getInstance().getAllowNewRewardAlgorithm() == 1L) {
                    this.put(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE, new BytesCapsule(ByteArray.fromLong((long)this.getCurrentCycleNumber())));
                }
                this.put(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE, new BytesCapsule(ByteArray.fromLong((long)Long.MAX_VALUE)));
            }
            try {
                this.getAllowNewReward();
            }
            catch (IllegalArgumentException e) {
                this.saveAllowNewReward(CommonParameter.getInstance().getAllowNewReward());
                if (CommonParameter.getInstance().getAllowNewReward() != 1L) break block230;
                this.put(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE, new BytesCapsule(ByteArray.fromLong((long)this.getCurrentCycleNumber())));
            }
        }
        try {
            this.getMemoFee();
        }
        catch (IllegalArgumentException e) {
            long memoFee = CommonParameter.getInstance().getMemoFee();
            this.saveMemoFee(memoFee);
            this.saveMemoFeeHistory("0:" + memoFee);
        }
        try {
            this.getAllowDelegateOptimization();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowDelegateOptimization(CommonParameter.getInstance().getAllowDelegateOptimization());
        }
        try {
            this.getUnfreezeDelayDays();
        }
        catch (IllegalArgumentException e) {
            this.saveUnfreezeDelayDays(CommonParameter.getInstance().getUnfreezeDelayDays());
        }
        try {
            this.getAllowOptimizedReturnValueOfChainId();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowOptimizedReturnValueOfChainId(CommonParameter.getInstance().getAllowOptimizedReturnValueOfChainId());
        }
        try {
            this.getAllowDynamicEnergy();
        }
        catch (IllegalArgumentException e) {
            this.saveAllowDynamicEnergy(CommonParameter.getInstance().getAllowDynamicEnergy());
        }
        try {
            this.getDynamicEnergyThreshold();
        }
        catch (IllegalArgumentException e) {
            this.saveDynamicEnergyThreshold(CommonParameter.getInstance().getDynamicEnergyThreshold());
        }
        try {
            this.getDynamicEnergyIncreaseFactor();
        }
        catch (IllegalArgumentException e) {
            this.saveDynamicEnergyIncreaseFactor(CommonParameter.getInstance().getDynamicEnergyIncreaseFactor());
        }
        try {
            this.getDynamicEnergyMaxFactor();
        }
        catch (IllegalArgumentException e) {
            this.saveDynamicEnergyMaxFactor(CommonParameter.getInstance().getDynamicEnergyMaxFactor());
        }
    }

    public String intArrayToString(int[] a) {
        StringBuilder sb = new StringBuilder();
        for (int i : a) {
            sb.append(i);
        }
        return sb.toString();
    }

    public int[] stringToIntArray(String s) {
        int length = s.length();
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Integer.parseInt(s.substring(i, i + 1));
        }
        return result;
    }

    public void saveTokenIdNum(long num) {
        this.put(TOKEN_ID_NUM, new BytesCapsule(ByteArray.fromLong((long)num)));
    }

    public long getTokenIdNum() {
        return Optional.ofNullable(this.getUnchecked(TOKEN_ID_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOKEN_ID_NUM"));
    }

    public void saveTokenUpdateDone(long num) {
        this.put(TOKEN_UPDATE_DONE, new BytesCapsule(ByteArray.fromLong((long)num)));
    }

    public long getTokenUpdateDone() {
        return Optional.ofNullable(this.getUnchecked(TOKEN_UPDATE_DONE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOKEN_UPDATE_DONE"));
    }

    public void saveAbiMoveDone(long num) {
        this.put(ABI_MOVE_DONE, new BytesCapsule(ByteArray.fromLong((long)num)));
    }

    public long getAbiMoveDone() {
        return Optional.ofNullable(this.getUnchecked(ABI_MOVE_DONE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ABI_MOVE_DONE"));
    }

    public void saveBlockFilledSlotsIndex(int blockFilledSlotsIndex) {
        logger.debug("BlockFilledSlotsIndex: {}.", (Object)blockFilledSlotsIndex);
        this.put(BLOCK_FILLED_SLOTS_INDEX, new BytesCapsule(ByteArray.fromInt((int)blockFilledSlotsIndex)));
    }

    public int getBlockFilledSlotsIndex() {
        return Optional.ofNullable(this.getUnchecked(BLOCK_FILLED_SLOTS_INDEX)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found BLOCK_FILLED_SLOTS_INDEX"));
    }

    public void saveMaxFrozenTime(int maxFrozenTime) {
        logger.debug("MAX_FROZEN_NUMBER:" + maxFrozenTime);
        this.put(MAX_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt((int)maxFrozenTime)));
    }

    public int getMaxFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_TIME"));
    }

    public void saveMinFrozenTime(int minFrozenTime) {
        logger.debug("MIN_FROZEN_NUMBER:" + minFrozenTime);
        this.put(MIN_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt((int)minFrozenTime)));
    }

    public int getMinFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(MIN_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MIN_FROZEN_TIME"));
    }

    public void saveMaxFrozenSupplyNumber(int maxFrozenSupplyNumber) {
        logger.debug("MAX_FROZEN_SUPPLY_NUMBER:" + maxFrozenSupplyNumber);
        this.put(MAX_FROZEN_SUPPLY_NUMBER, new BytesCapsule(ByteArray.fromInt((int)maxFrozenSupplyNumber)));
    }

    public int getMaxFrozenSupplyNumber() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_SUPPLY_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_SUPPLY_NUMBER"));
    }

    public void saveMaxFrozenSupplyTime(int maxFrozenSupplyTime) {
        logger.debug("MAX_FROZEN_SUPPLY_NUMBER:" + maxFrozenSupplyTime);
        this.put(MAX_FROZEN_SUPPLY_TIME, new BytesCapsule(ByteArray.fromInt((int)maxFrozenSupplyTime)));
    }

    public int getMaxFrozenSupplyTime() {
        return Optional.ofNullable(this.getUnchecked(MAX_FROZEN_SUPPLY_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MAX_FROZEN_SUPPLY_TIME"));
    }

    public void saveMinFrozenSupplyTime(int minFrozenSupplyTime) {
        logger.debug("MIN_FROZEN_SUPPLY_NUMBER:" + minFrozenSupplyTime);
        this.put(MIN_FROZEN_SUPPLY_TIME, new BytesCapsule(ByteArray.fromInt((int)minFrozenSupplyTime)));
    }

    public int getMinFrozenSupplyTime() {
        return Optional.ofNullable(this.getUnchecked(MIN_FROZEN_SUPPLY_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found MIN_FROZEN_SUPPLY_TIME"));
    }

    public void saveWitnessAllowanceFrozenTime(int witnessAllowanceFrozenTime) {
        logger.debug("WITNESS_ALLOWANCE_FROZEN_TIME:" + witnessAllowanceFrozenTime);
        this.put(WITNESS_ALLOWANCE_FROZEN_TIME, new BytesCapsule(ByteArray.fromInt((int)witnessAllowanceFrozenTime)));
    }

    public int getWitnessAllowanceFrozenTime() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_ALLOWANCE_FROZEN_TIME)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_ALLOWANCE_FROZEN_TIME"));
    }

    public void saveMaintenanceTimeInterval(long timeInterval) {
        logger.debug("MAINTENANCE_TIME_INTERVAL:" + timeInterval);
        this.put(MAINTENANCE_TIME_INTERVAL, new BytesCapsule(ByteArray.fromLong((long)timeInterval)));
    }

    public long getMaintenanceTimeInterval() {
        return Optional.ofNullable(this.getUnchecked(MAINTENANCE_TIME_INTERVAL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MAINTENANCE_TIME_INTERVAL"));
    }

    public void saveAccountUpgradeCost(long accountUpgradeCost) {
        logger.debug("ACCOUNT_UPGRADE_COST:" + accountUpgradeCost);
        this.put(ACCOUNT_UPGRADE_COST, new BytesCapsule(ByteArray.fromLong((long)accountUpgradeCost)));
    }

    public long getAccountUpgradeCost() {
        return Optional.ofNullable(this.getUnchecked(ACCOUNT_UPGRADE_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ACCOUNT_UPGRADE_COST"));
    }

    public void saveWitnessPayPerBlock(long pay) {
        logger.debug("WITNESS_PAY_PER_BLOCK:" + pay);
        this.put(WITNESS_PAY_PER_BLOCK, new BytesCapsule(ByteArray.fromLong((long)pay)));
    }

    public long getWitnessPayPerBlock() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_PAY_PER_BLOCK)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_PAY_PER_BLOCK"));
    }

    public void saveWitness127PayPerBlock(long pay) {
        logger.debug("WITNESS_127_PAY_PER_BLOCK:" + pay);
        this.put(WITNESS_127_PAY_PER_BLOCK, new BytesCapsule(ByteArray.fromLong((long)pay)));
    }

    public long getWitness127PayPerBlock() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_127_PAY_PER_BLOCK)).map(BytesCapsule::getData).map(ByteArray::toLong).orElse(16000000L);
    }

    public void saveWitnessStandbyAllowance(long allowance) {
        logger.debug("WITNESS_STANDBY_ALLOWANCE:" + allowance);
        this.put(WITNESS_STANDBY_ALLOWANCE, new BytesCapsule(ByteArray.fromLong((long)allowance)));
    }

    public long getWitnessStandbyAllowance() {
        return Optional.ofNullable(this.getUnchecked(WITNESS_STANDBY_ALLOWANCE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found WITNESS_STANDBY_ALLOWANCE"));
    }

    public void saveOneDayNetLimit(long oneDayNetLimit) {
        this.put(DynamicResourceProperties.ONE_DAY_NET_LIMIT, new BytesCapsule(ByteArray.fromLong((long)oneDayNetLimit)));
    }

    public long getOneDayNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.ONE_DAY_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ONE_DAY_NET_LIMIT"));
    }

    public void savePublicNetUsage(long publicNetUsage) {
        this.put(DynamicResourceProperties.PUBLIC_NET_USAGE, new BytesCapsule(ByteArray.fromLong((long)publicNetUsage)));
    }

    public long getPublicNetUsage() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_USAGE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_USAGE"));
    }

    public void savePublicNetLimit(long publicNetLimit) {
        this.put(DynamicResourceProperties.PUBLIC_NET_LIMIT, new BytesCapsule(ByteArray.fromLong((long)publicNetLimit)));
    }

    public long getPublicNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_LIMIT"));
    }

    public void savePublicNetTime(long publicNetTime) {
        this.put(DynamicResourceProperties.PUBLIC_NET_TIME, new BytesCapsule(ByteArray.fromLong((long)publicNetTime)));
    }

    public long getPublicNetTime() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.PUBLIC_NET_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found PUBLIC_NET_TIME"));
    }

    public void saveFreeNetLimit(long freeNetLimit) {
        this.put(DynamicResourceProperties.FREE_NET_LIMIT, new BytesCapsule(ByteArray.fromLong((long)freeNetLimit)));
    }

    public long getFreeNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.FREE_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found FREE_NET_LIMIT"));
    }

    public void saveTotalNetWeight(long totalNetWeight) {
        this.put(DynamicResourceProperties.TOTAL_NET_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalNetWeight)));
    }

    public long getTotalNetWeight() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_NET_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_WEIGHT"));
    }

    public void saveTotalEnergyWeight(long totalEnergyWeight) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyWeight)));
    }

    public long getTotalEnergyWeight() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_WEIGHT"));
    }

    public void saveTotalTronPowerWeight(long totalEnergyWeight) {
        this.put(DynamicResourceProperties.TOTAL_TRON_POWER_WEIGHT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyWeight)));
    }

    public long getTotalTronPowerWeight() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_TRON_POWER_WEIGHT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_TRON_POWER_WEIGHT"));
    }

    public void saveTotalNetLimit(long totalNetLimit) {
        this.put(DynamicResourceProperties.TOTAL_NET_LIMIT, new BytesCapsule(ByteArray.fromLong((long)totalNetLimit)));
    }

    public long getTotalNetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_NET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_LIMIT"));
    }

    @Deprecated
    public void saveTotalEnergyLimit(long totalEnergyLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_LIMIT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyLimit)));
        long ratio = this.getAdaptiveResourceLimitTargetRatio();
        this.saveTotalEnergyTargetLimit(totalEnergyLimit / ratio);
    }

    public void saveTotalEnergyLimit2(long totalEnergyLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_LIMIT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyLimit)));
        long ratio = this.getAdaptiveResourceLimitTargetRatio();
        this.saveTotalEnergyTargetLimit(totalEnergyLimit / ratio);
        if (this.getAllowAdaptiveEnergy() == 0L) {
            this.saveTotalEnergyCurrentLimit(totalEnergyLimit);
        }
    }

    public long getTotalEnergyLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_LIMIT"));
    }

    public void saveTotalEnergyCurrentLimit(long totalEnergyCurrentLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_CURRENT_LIMIT, new BytesCapsule(ByteArray.fromLong((long)totalEnergyCurrentLimit)));
    }

    public long getTotalEnergyCurrentLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_CURRENT_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_CURRENT_LIMIT"));
    }

    public void saveTotalEnergyTargetLimit(long targetTotalEnergyLimit) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_TARGET_LIMIT, new BytesCapsule(ByteArray.fromLong((long)targetTotalEnergyLimit)));
    }

    public long getTotalEnergyTargetLimit() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_TARGET_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_TARGET_LIMIT"));
    }

    public void saveTotalEnergyAverageUsage(long totalEnergyAverageUsage) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_USAGE, new BytesCapsule(ByteArray.fromLong((long)totalEnergyAverageUsage)));
    }

    public long getTotalEnergyAverageUsage() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_USAGE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_ENERGY_AVERAGE_USAGE"));
    }

    public void saveAdaptiveResourceLimitMultiplier(long adaptiveResourceLimitMultiplier) {
        this.put(DynamicResourceProperties.ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER, new BytesCapsule(ByteArray.fromLong((long)adaptiveResourceLimitMultiplier)));
    }

    public long getAdaptiveResourceLimitMultiplier() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER"));
    }

    public void saveAdaptiveResourceLimitTargetRatio(long adaptiveResourceLimitTargetRatio) {
        this.put(DynamicResourceProperties.ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO, new BytesCapsule(ByteArray.fromLong((long)adaptiveResourceLimitTargetRatio)));
    }

    public long getAdaptiveResourceLimitTargetRatio() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO"));
    }

    public void saveTotalEnergyAverageTime(long totalEnergyAverageTime) {
        this.put(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_TIME, new BytesCapsule(ByteArray.fromLong((long)totalEnergyAverageTime)));
    }

    public long getTotalEnergyAverageTime() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.TOTAL_ENERGY_AVERAGE_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_NET_AVERAGE_TIME"));
    }

    public void saveBlockEnergyUsage(long blockEnergyUsage) {
        this.put(DynamicResourceProperties.BLOCK_ENERGY_USAGE, new BytesCapsule(ByteArray.fromLong((long)blockEnergyUsage)));
    }

    public long getBlockEnergyUsage() {
        return Optional.ofNullable(this.getUnchecked(DynamicResourceProperties.BLOCK_ENERGY_USAGE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found BLOCK_ENERGY_USAGE"));
    }

    public void saveEnergyFee(long totalEnergyFee) {
        this.put(ENERGY_FEE, new BytesCapsule(ByteArray.fromLong((long)totalEnergyFee)));
    }

    public long getEnergyFee() {
        return Optional.ofNullable(this.getUnchecked(ENERGY_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ENERGY_FEE"));
    }

    public void saveMaxCpuTimeOfOneTx(long time) {
        this.put(MAX_CPU_TIME_OF_ONE_TX, new BytesCapsule(ByteArray.fromLong((long)time)));
    }

    public long getMaxCpuTimeOfOneTx() {
        return Optional.ofNullable(this.getUnchecked(MAX_CPU_TIME_OF_ONE_TX)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MAX_CPU_TIME_OF_ONE_TX"));
    }

    public void saveCreateAccountFee(long fee) {
        this.put(CREATE_ACCOUNT_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getShieldedTransactionCreateAccountFee() {
        return Optional.ofNullable(this.getUnchecked(SHIELDED_TRANSACTION_CREATE_ACCOUNT_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found SHIELDED_TRANSACTION_CREATE_ACCOUNT_FEE"));
    }

    public void saveShieldedTransactionCreateAccountFee(long fee) {
        this.put(SHIELDED_TRANSACTION_CREATE_ACCOUNT_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getShieldedTransactionFee() {
        return Optional.ofNullable(this.getUnchecked(SHIELDED_TRANSACTION_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found SHIELD_TRANSACTION_FEE"));
    }

    public void saveShieldedTransactionFee(long fee) {
        this.put(SHIELDED_TRANSACTION_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getTotalShieldedPoolValue() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_SHIELDED_POOL_VALUE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_SHIELDED_POOL_Value"));
    }

    public void saveTotalShieldedPoolValue(long value) {
        this.put(TOTAL_SHIELDED_POOL_VALUE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getCreateAccountFee() {
        return Optional.ofNullable(this.getUnchecked(CREATE_ACCOUNT_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_ACCOUNT_FEE"));
    }

    public void saveCreateNewAccountFeeInSystemContract(long fee) {
        this.put(CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getCreateNewAccountFeeInSystemContract() {
        return Optional.ofNullable(this.getUnchecked(CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_NEW_ACCOUNT_FEE_IN_SYSTEM_CONTRACT"));
    }

    public void saveCreateNewAccountBandwidthRate(long rate) {
        this.put(CREATE_NEW_ACCOUNT_BANDWIDTH_RATE, new BytesCapsule(ByteArray.fromLong((long)rate)));
    }

    public long getCreateNewAccountBandwidthRate() {
        return Optional.ofNullable(this.getUnchecked(CREATE_NEW_ACCOUNT_BANDWIDTH_RATE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CREATE_NsEW_ACCOUNT_BANDWIDTH_RATE2"));
    }

    public void saveTransactionFee(long fee) {
        this.put(TRANSACTION_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getTransactionFee() {
        return Optional.ofNullable(this.getUnchecked(TRANSACTION_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TRANSACTION_FEE"));
    }

    public void saveAssetIssueFee(long fee) {
        this.put(ASSET_ISSUE_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public void saveUpdateAccountPermissionFee(long fee) {
        this.put(UPDATE_ACCOUNT_PERMISSION_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public void saveMultiSignFee(long fee) {
        this.put(MULTI_SIGN_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getAssetIssueFee() {
        return Optional.ofNullable(this.getUnchecked(ASSET_ISSUE_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ASSET_ISSUE_FEE"));
    }

    public long getUpdateAccountPermissionFee() {
        return Optional.ofNullable(this.getUnchecked(UPDATE_ACCOUNT_PERMISSION_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found UPDATE_ACCOUNT_PERMISSION_FEE"));
    }

    public long getMultiSignFee() {
        return Optional.ofNullable(this.getUnchecked(MULTI_SIGN_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MULTI_SIGN_FEE"));
    }

    public void saveExchangeCreateFee(long fee) {
        this.put(EXCHANGE_CREATE_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getExchangeCreateFee() {
        return Optional.ofNullable(this.getUnchecked(EXCHANGE_CREATE_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found EXCHANGE_CREATE_FEE"));
    }

    public void saveExchangeBalanceLimit(long limit) {
        this.put(EXCHANGE_BALANCE_LIMIT, new BytesCapsule(ByteArray.fromLong((long)limit)));
    }

    public long getExchangeBalanceLimit() {
        return Optional.ofNullable(this.getUnchecked(EXCHANGE_BALANCE_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found EXCHANGE_BALANCE_LIMIT"));
    }

    public void saveAllowMarketTransaction(long allowMarketTransaction) {
        this.put(ALLOW_MARKET_TRANSACTION, new BytesCapsule(ByteArray.fromLong((long)allowMarketTransaction)));
    }

    public long getAllowMarketTransaction() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_MARKET_TRANSACTION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_MARKET_TRANSACTION"));
    }

    public boolean supportAllowMarketTransaction() {
        return this.getAllowMarketTransaction() == 1L;
    }

    public void saveMarketSellFee(long fee) {
        this.put(MARKET_SELL_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getMarketSellFee() {
        return Optional.ofNullable(this.getUnchecked(MARKET_SELL_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MARKET_SELL_FEE"));
    }

    public void saveMarketCancelFee(long fee) {
        this.put(MARKET_CANCEL_FEE, new BytesCapsule(ByteArray.fromLong((long)fee)));
    }

    public long getMarketCancelFee() {
        return Optional.ofNullable(this.getUnchecked(MARKET_CANCEL_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MARKET_CANCEL_FEE"));
    }

    public void saveMarketQuantityLimit(long limit) {
        this.put(MARKET_QUANTITY_LIMIT, new BytesCapsule(ByteArray.fromLong((long)limit)));
    }

    public long getMarketQuantityLimit() {
        return Optional.ofNullable(this.getUnchecked(MARKET_QUANTITY_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MARKET_QUANTITY_LIMIT"));
    }

    public boolean supportTransactionFeePool() {
        return this.getAllowTransactionFeePool() == 1L;
    }

    public void saveAllowTransactionFeePool(long value) {
        this.put(ALLOW_TRANSACTION_FEE_POOL, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowTransactionFeePool() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TRANSACTION_FEE_POOL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_TRANSACTION_FEE_POOL"));
    }

    public void addTransactionFeePool(long amount) {
        if (amount <= 0L) {
            return;
        }
        this.saveTransactionFeePool(amount += this.getTransactionFeePool());
    }

    public void saveTransactionFeePool(long value) {
        this.put(TRANSACTION_FEE_POOL, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getTransactionFeePool() {
        return Optional.ofNullable(this.getUnchecked(TRANSACTION_FEE_POOL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TRANSACTION_FEE_POOL"));
    }

    public void saveTotalTransactionCost(long value) {
        this.put(TOTAL_TRANSACTION_COST, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getTotalTransactionCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_TRANSACTION_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_TRANSACTION_COST"));
    }

    public void saveTotalCreateAccountFee(long value) {
        this.put(TOTAL_CREATE_ACCOUNT_COST, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getTotalCreateAccountCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_CREATE_ACCOUNT_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_CREATE_ACCOUNT_COST"));
    }

    public void saveTotalCreateWitnessFee(long value) {
        this.put(TOTAL_CREATE_WITNESS_COST, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getTotalCreateWitnessCost() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_CREATE_WITNESS_COST)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_CREATE_WITNESS_COST"));
    }

    public void saveTotalStoragePool(long trx) {
        this.put(TOTAL_STORAGE_POOL, new BytesCapsule(ByteArray.fromLong((long)trx)));
    }

    public long getTotalStoragePool() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_POOL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_POOL"));
    }

    public void saveTotalStorageTax(long trx) {
        this.put(TOTAL_STORAGE_TAX, new BytesCapsule(ByteArray.fromLong((long)trx)));
    }

    public long getTotalStorageTax() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_TAX)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_TAX"));
    }

    public void saveTotalStorageReserved(long bytes) {
        this.put(TOTAL_STORAGE_RESERVED, new BytesCapsule(ByteArray.fromLong((long)bytes)));
    }

    public long getTotalStorageReserved() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_STORAGE_RESERVED)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_STORAGE_RESERVED"));
    }

    public void saveStorageExchangeTaxRate(long rate) {
        this.put(STORAGE_EXCHANGE_TAX_RATE, new BytesCapsule(ByteArray.fromLong((long)rate)));
    }

    public long getStorageExchangeTaxRate() {
        return Optional.ofNullable(this.getUnchecked(STORAGE_EXCHANGE_TAX_RATE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found STORAGE_EXCHANGE_TAX_RATE"));
    }

    public void saveRemoveThePowerOfTheGr(long rate) {
        this.put(REMOVE_THE_POWER_OF_THE_GR, new BytesCapsule(ByteArray.fromLong((long)rate)));
    }

    public long getRemoveThePowerOfTheGr() {
        return Optional.ofNullable(this.getUnchecked(REMOVE_THE_POWER_OF_THE_GR)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found REMOVE_THE_POWER_OF_THE_GR"));
    }

    public void saveAllowDelegateResource(long value) {
        this.put(ALLOW_DELEGATE_RESOURCE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowDelegateResource() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_DELEGATE_RESOURCE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_DELEGATE_RESOURCE"));
    }

    public void saveAllowAdaptiveEnergy(long value) {
        this.put(ALLOW_ADAPTIVE_ENERGY, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowAdaptiveEnergy() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_ADAPTIVE_ENERGY)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ADAPTIVE_ENERGY"));
    }

    public void saveAllowTvmTransferTrc10(long value) {
        this.put(ALLOW_TVM_TRANSFER_TRC10, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowTvmTransferTrc10() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_TRANSFER_TRC10)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_TVM_TRANSFER_TRC10"));
    }

    public void saveAllowTvmConstantinople(long value) {
        this.put(ALLOW_TVM_CONSTANTINOPLE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowTvmConstantinople() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_CONSTANTINOPLE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_TVM_CONSTANTINOPLE"));
    }

    public void saveAllowTvmSolidity059(long value) {
        this.put(ALLOW_TVM_SOLIDITY_059, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowTvmSolidity059() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_SOLIDITY_059)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_TVM_SOLIDITY_059"));
    }

    public void saveForbidTransferToContract(long value) {
        this.put(FORBID_TRANSFER_TO_CONTRACT, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getForbidTransferToContract() {
        return Optional.ofNullable(this.getUnchecked(FORBID_TRANSFER_TO_CONTRACT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found FORBID_TRANSFER_TO_CONTRACT"));
    }

    public void saveAvailableContractType(byte[] value) {
        this.put(AVAILABLE_CONTRACT_TYPE, new BytesCapsule(value));
    }

    public byte[] getAvailableContractType() {
        return Optional.ofNullable(this.getUnchecked(AVAILABLE_CONTRACT_TYPE)).map(BytesCapsule::getData).orElseThrow(() -> new IllegalArgumentException("not found AVAILABLE_CONTRACT_TYPE"));
    }

    public void addSystemContractAndSetPermission(int id) {
        byte[] availableContractType = this.getAvailableContractType();
        int n = id / 8;
        availableContractType[n] = (byte)(availableContractType[n] | 1 << id % 8);
        this.saveAvailableContractType(availableContractType);
        byte[] activeDefaultOperations = this.getActiveDefaultOperations();
        int n2 = id / 8;
        activeDefaultOperations[n2] = (byte)(activeDefaultOperations[n2] | 1 << id % 8);
        this.saveActiveDefaultOperations(activeDefaultOperations);
    }

    public void updateDynamicStoreByConfig() {
        if (CommonParameter.getInstance().getAllowTvmConstantinople() != 0L) {
            this.saveAllowTvmConstantinople(CommonParameter.getInstance().getAllowTvmConstantinople());
            this.addSystemContractAndSetPermission(48);
        }
    }

    public void saveActiveDefaultOperations(byte[] value) {
        this.put(ACTIVE_DEFAULT_OPERATIONS, new BytesCapsule(value));
    }

    public byte[] getActiveDefaultOperations() {
        return Optional.ofNullable(this.getUnchecked(ACTIVE_DEFAULT_OPERATIONS)).map(BytesCapsule::getData).orElseThrow(() -> new IllegalArgumentException("not found ACTIVE_DEFAULT_OPERATIONS"));
    }

    public boolean supportDR() {
        return this.getAllowDelegateResource() == 1L;
    }

    public void saveAllowUpdateAccountName(long rate) {
        this.put(ALLOW_UPDATE_ACCOUNT_NAME, new BytesCapsule(ByteArray.fromLong((long)rate)));
    }

    public long getAllowUpdateAccountName() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_UPDATE_ACCOUNT_NAME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_UPDATE_ACCOUNT_NAME"));
    }

    public void saveAllowSameTokenName(long rate) {
        this.put(ALLOW_SAME_TOKEN_NAME, new BytesCapsule(ByteArray.fromLong((long)rate)));
    }

    public long getAllowSameTokenName() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_SAME_TOKEN_NAME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_SAME_TOKEN_NAME"));
    }

    public void saveAllowCreationOfContracts(long allowCreationOfContracts) {
        this.put(ALLOW_CREATION_OF_CONTRACTS, new BytesCapsule(ByteArray.fromLong((long)allowCreationOfContracts)));
    }

    public void saveTotalSignNum(int num) {
        this.put(TOTAL_SIGN_NUM, new BytesCapsule(ByteArray.fromInt((int)num)));
    }

    public int getTotalSignNum() {
        return Optional.ofNullable(this.getUnchecked(TOTAL_SIGN_NUM)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found TOTAL_SIGN_NUM"));
    }

    public void saveAllowMultiSign(long allowMultiSing) {
        this.put(ALLOW_MULTI_SIGN, new BytesCapsule(ByteArray.fromLong((long)allowMultiSing)));
    }

    public long getAllowMultiSign() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_MULTI_SIGN)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_MULTI_SIGN"));
    }

    public long getAllowCreationOfContracts() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_CREATION_OF_CONTRACTS)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_CREATION_OF_CONTRACTS"));
    }

    public boolean supportVM() {
        return this.getAllowCreationOfContracts() == 1L;
    }

    public void saveAllowShieldedTransaction(long allowShieldedTransaction) {
        this.put(ALLOW_SHIELDED_TRANSACTION, new BytesCapsule(ByteArray.fromLong((long)allowShieldedTransaction)));
    }

    public long getAllowShieldedTransaction() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_SHIELDED_TRANSACTION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_SHIELDED_TRANSACTION"));
    }

    public void saveAllowShieldedTRC20Transaction(long allowShieldedTRC20Transaction) {
        this.put(ALLOW_SHIELDED_TRC20_TRANSACTION, new BytesCapsule(ByteArray.fromLong((long)allowShieldedTRC20Transaction)));
    }

    public long getAllowShieldedTRC20Transaction() {
        String msg = "not found ALLOW_SHIELDED_TRC20_TRANSACTION";
        return Optional.ofNullable(this.getUnchecked(ALLOW_SHIELDED_TRC20_TRANSACTION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public void saveAllowTvmIstanbul(long allowTVMIstanbul) {
        this.put(ALLOW_TVM_ISTANBUL, new BytesCapsule(ByteArray.fromLong((long)allowTVMIstanbul)));
    }

    public long getAllowTvmIstanbul() {
        String msg = "not found ALLOW_TVM_ISTANBUL";
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_ISTANBUL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public boolean supportShieldedTransaction() {
        return this.getAllowShieldedTransaction() == 1L;
    }

    public boolean supportShieldedTRC20Transaction() {
        return this.getAllowShieldedTRC20Transaction() == 1L;
    }

    public void saveBlockFilledSlots(int[] blockFilledSlots) {
        logger.debug("BlockFilledSlots: {}.", (Object)this.intArrayToString(blockFilledSlots));
        this.put(BLOCK_FILLED_SLOTS, new BytesCapsule(ByteArray.fromString((String)this.intArrayToString(blockFilledSlots))));
    }

    public int[] getBlockFilledSlots() {
        return Optional.ofNullable(this.getUnchecked(BLOCK_FILLED_SLOTS)).map(BytesCapsule::getData).map(ByteArray::toStr).map(this::stringToIntArray).orElseThrow(() -> new IllegalArgumentException("not found latest SOLIDIFIED_BLOCK_NUM timestamp"));
    }

    public int getBlockFilledSlotsNumber() {
        return 128;
    }

    public void applyBlock(boolean fillBlock) {
        int[] blockFilledSlots = this.getBlockFilledSlots();
        int blockFilledSlotsIndex = this.getBlockFilledSlotsIndex();
        blockFilledSlots[blockFilledSlotsIndex] = fillBlock ? 1 : 0;
        this.saveBlockFilledSlotsIndex((blockFilledSlotsIndex + 1) % this.getBlockFilledSlotsNumber());
        this.saveBlockFilledSlots(blockFilledSlots);
    }

    public int calculateFilledSlotsCount() {
        int[] blockFilledSlots = this.getBlockFilledSlots();
        return 100 * IntStream.of(blockFilledSlots).sum() / this.getBlockFilledSlotsNumber();
    }

    public void saveLatestSolidifiedBlockNum(long number) {
        this.put(LATEST_SOLIDIFIED_BLOCK_NUM, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getLatestSolidifiedBlockNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_SOLIDIFIED_BLOCK_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest SOLIDIFIED_BLOCK_NUM"));
    }

    public void saveLatestProposalNum(long number) {
        this.put(LATEST_PROPOSAL_NUM, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getLatestProposalNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_PROPOSAL_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest PROPOSAL_NUM"));
    }

    public void saveLatestExchangeNum(long number) {
        this.put(LATEST_EXCHANGE_NUM, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getLatestExchangeNum() {
        return Optional.ofNullable(this.getUnchecked(LATEST_EXCHANGE_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest EXCHANGE_NUM"));
    }

    public long getLatestBlockHeaderTimestamp() {
        return Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_TIMESTAMP)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header timestamp"));
    }

    public long getLatestBlockHeaderNumber() {
        return Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header number"));
    }

    public long getLatestBlockHeaderNumberFromDB() {
        try {
            return Optional.ofNullable(this.getFromRoot(LATEST_BLOCK_HEADER_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found latest block header number"));
        }
        catch (BadItemException | ItemNotFoundException e) {
            logger.error("Get header from DB, {}.", (Object)e.getMessage());
            return -1L;
        }
    }

    public int getStateFlag() {
        return Optional.ofNullable(this.getUnchecked(STATE_FLAG)).map(BytesCapsule::getData).map(ByteArray::toInt).orElseThrow(() -> new IllegalArgumentException("not found maintenance flag"));
    }

    public Sha256Hash getLatestBlockHeaderHash() {
        byte[] blockHash = Optional.ofNullable(this.getUnchecked(LATEST_BLOCK_HEADER_HASH)).map(BytesCapsule::getData).orElseThrow(() -> new IllegalArgumentException("not found block hash"));
        return Sha256Hash.wrap((byte[])blockHash);
    }

    public void saveLatestBlockHeaderTimestamp(long t) {
        logger.info("Update latest block header timestamp = {}.", (Object)t);
        this.put(LATEST_BLOCK_HEADER_TIMESTAMP, new BytesCapsule(ByteArray.fromLong((long)t)));
    }

    public void saveLatestBlockHeaderNumber(long n) {
        logger.info("Update latest block header number = {}.", (Object)n);
        this.put(LATEST_BLOCK_HEADER_NUMBER, new BytesCapsule(ByteArray.fromLong((long)n)));
    }

    public void saveLatestBlockHeaderHash(ByteString h) {
        logger.info("Update latest block header id = {}.", (Object)ByteArray.toHexString((byte[])h.toByteArray()));
        this.put(LATEST_BLOCK_HEADER_HASH, new BytesCapsule(h.toByteArray()));
    }

    public void saveStateFlag(int n) {
        logger.info("Update state flag = {}.", (Object)n);
        this.put(STATE_FLAG, new BytesCapsule(ByteArray.fromInt((int)n)));
    }

    public long getNextMaintenanceTime() {
        return Optional.ofNullable(this.getUnchecked(NEXT_MAINTENANCE_TIME)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found NEXT_MAINTENANCE_TIME"));
    }

    public long getMaintenanceSkipSlots() {
        return 2L;
    }

    public void saveNextMaintenanceTime(long nextMaintenanceTime) {
        this.put(NEXT_MAINTENANCE_TIME, new BytesCapsule(ByteArray.fromLong((long)nextMaintenanceTime)));
    }

    public void updateNextMaintenanceTime(long blockTime) {
        long maintenanceTimeInterval = this.getMaintenanceTimeInterval();
        long currentMaintenanceTime = this.getNextMaintenanceTime();
        long round = (blockTime - currentMaintenanceTime) / maintenanceTimeInterval;
        long nextMaintenanceTime = currentMaintenanceTime + (round + 1L) * maintenanceTimeInterval;
        this.saveNextMaintenanceTime(nextMaintenanceTime);
        logger.info("Do update nextMaintenanceTime, currentMaintenanceTime: {}, blockTime: {}, nextMaintenanceTime: {}.", new Object[]{new DateTime(currentMaintenanceTime), new DateTime(blockTime), new DateTime(nextMaintenanceTime)});
    }

    public void addTotalNetWeight(long amount) {
        if (amount == 0L) {
            return;
        }
        long totalNetWeight = this.getTotalNetWeight();
        totalNetWeight += amount;
        if (this.allowNewReward()) {
            totalNetWeight = Math.max(0L, totalNetWeight);
        }
        this.saveTotalNetWeight(totalNetWeight);
    }

    public void addTotalEnergyWeight(long amount) {
        if (amount == 0L) {
            return;
        }
        long totalEnergyWeight = this.getTotalEnergyWeight();
        totalEnergyWeight += amount;
        if (this.allowNewReward()) {
            totalEnergyWeight = Math.max(0L, totalEnergyWeight);
        }
        this.saveTotalEnergyWeight(totalEnergyWeight);
    }

    public void addTotalTronPowerWeight(long amount) {
        if (amount == 0L) {
            return;
        }
        long totalWeight = this.getTotalTronPowerWeight();
        totalWeight += amount;
        if (this.allowNewReward()) {
            totalWeight = Math.max(0L, totalWeight);
        }
        this.saveTotalTronPowerWeight(totalWeight);
    }

    public void addTotalCreateAccountCost(long fee) {
        long newValue = this.getTotalCreateAccountCost() + fee;
        this.saveTotalCreateAccountFee(newValue);
    }

    public void addTotalCreateWitnessCost(long fee) {
        long newValue = this.getTotalCreateWitnessCost() + fee;
        this.saveTotalCreateWitnessFee(newValue);
    }

    public void addTotalTransactionCost(long fee) {
        long newValue = this.getTotalTransactionCost() + fee;
        this.saveTotalTransactionCost(newValue);
    }

    public void forked(int version, boolean value) {
        String forkKey = FORK_CONTROLLER + version;
        this.put(forkKey.getBytes(), new BytesCapsule(Boolean.toString(value).getBytes()));
    }

    public void statsByVersion(int version, byte[] stats) {
        String statsKey = FORK_PREFIX + version;
        this.put(statsKey.getBytes(), new BytesCapsule(stats));
    }

    public byte[] statsByVersion(int version) {
        String statsKey = FORK_PREFIX + version;
        return this.revokingDB.getUnchecked(statsKey.getBytes());
    }

    public Boolean getForked(int version) {
        String forkKey = FORK_CONTROLLER + version;
        byte[] value = this.revokingDB.getUnchecked(forkKey.getBytes());
        return value == null ? null : Boolean.valueOf(new String(value));
    }

    public void saveLatestVersion(int version) {
        this.put(VERSION_NUMBER, new BytesCapsule(ByteArray.fromInt((int)version)));
    }

    public int getLatestVersion() {
        BytesCapsule data = (BytesCapsule)this.getUnchecked(VERSION_NUMBER);
        if (data == null) {
            this.saveLatestVersion(0);
            return 0;
        }
        return ByteArray.toInt((byte[])data.getData());
    }

    public long getAllowProtoFilterNum() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_PROTO_FILTER_NUM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found allow protobuf number"));
    }

    public void saveAllowProtoFilterNum(long num) {
        logger.info("Update allow protobuf number = {}.", (Object)num);
        this.put(ALLOW_PROTO_FILTER_NUM, new BytesCapsule(ByteArray.fromLong((long)num)));
    }

    public void saveAllowAccountStateRoot(long allowAccountStateRoot) {
        this.put(ALLOW_ACCOUNT_STATE_ROOT, new BytesCapsule(ByteArray.fromLong((long)allowAccountStateRoot)));
    }

    public long getAllowAccountStateRoot() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_ACCOUNT_STATE_ROOT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ACCOUNT_STATE_ROOT"));
    }

    public boolean allowAccountStateRoot() {
        return this.getAllowAccountStateRoot() == 1L;
    }

    public long getCurrentCycleNumber() {
        return Optional.ofNullable(this.getUnchecked(CURRENT_CYCLE_NUMBER)).map(BytesCapsule::getData).map(ByteArray::toLong).orElse(0L);
    }

    public void saveCurrentCycleNumber(long number) {
        this.put(CURRENT_CYCLE_NUMBER, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public void saveChangeDelegation(long number) {
        this.put(CHANGE_DELEGATION, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getChangeDelegation() {
        return Optional.ofNullable(this.getUnchecked(CHANGE_DELEGATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found CHANGE_DELEGATION"));
    }

    public boolean allowChangeDelegation() {
        return this.getChangeDelegation() == 1L;
    }

    public void saveAllowPBFT(long number) {
        this.put(ALLOW_PBFT, new BytesCapsule(ByteArray.fromLong((long)number)));
    }

    public long getAllowPBFT() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_PBFT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_PBFT"));
    }

    public boolean allowPBFT() {
        return this.getAllowPBFT() == 1L;
    }

    public long getMaxFeeLimit() {
        return Optional.ofNullable(this.getUnchecked(MAX_FEE_LIMIT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MAX_FEE_LIMIT"));
    }

    public void saveMaxFeeLimit(long maxFeeLimit) {
        this.put(MAX_FEE_LIMIT, new BytesCapsule(ByteArray.fromLong((long)maxFeeLimit)));
    }

    public long getBurnTrxAmount() {
        return Optional.ofNullable(this.getUnchecked(BURN_TRX_AMOUNT)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found BURN_TRX_AMOUNT"));
    }

    public void burnTrx(long amount) {
        if (amount <= 0L) {
            return;
        }
        this.saveBurnTrx(amount += this.getBurnTrxAmount());
    }

    private void saveBurnTrx(long amount) {
        this.put(BURN_TRX_AMOUNT, new BytesCapsule(ByteArray.fromLong((long)amount)));
    }

    public boolean supportBlackHoleOptimization() {
        return this.getAllowBlackHoleOptimization() == 1L;
    }

    public void saveAllowBlackHoleOptimization(long value) {
        this.put(ALLOW_BLACKHOLE_OPTIMIZATION, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowBlackHoleOptimization() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_BLACKHOLE_OPTIMIZATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_BLACKHOLE_OPTIMIZATION"));
    }

    public boolean supportAllowNewResourceModel() {
        return this.getAllowNewResourceModel() == 1L;
    }

    public boolean supportAllowAccountAssetOptimization() {
        return this.getAllowAccountAssetOptimization() == 1L;
    }

    public boolean supportAllowAssetOptimization() {
        return this.getAllowAssetOptimization() == 1L;
    }

    public void saveAllowNewResourceModel(long value) {
        this.put(ALLOW_NEW_RESOURCE_MODEL, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowNewResourceModel() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_NEW_RESOURCE_MODEL)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_NEW_RESOURCE_MODEL"));
    }

    public void saveAllowTvmFreeze(long allowTvmFreeze) {
        this.put(ALLOW_TVM_FREEZE, new BytesCapsule(ByteArray.fromLong((long)allowTvmFreeze)));
    }

    public long getAllowTvmFreeze() {
        String msg = "not found ALLOW_TVM_FREEZE";
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_FREEZE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public void saveAllowTvmVote(long allowTvmVote) {
        this.put(ALLOW_TVM_VOTE, new BytesCapsule(ByteArray.fromLong((long)allowTvmVote)));
    }

    public long getAllowTvmVote() {
        String msg = "not found ALLOW_TVM_VOTE";
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_VOTE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public void saveAllowTvmLondon(long allowTvmLondon) {
        this.put(ALLOW_TVM_LONDON, new BytesCapsule(ByteArray.fromLong((long)allowTvmLondon)));
    }

    public long getAllowTvmLondon() {
        String msg = "not found ALLOW_TVM_LONDON";
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_LONDON)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public void saveAllowTvmCompatibleEvm(long allowTvmCompatibleEvm) {
        this.put(ALLOW_TVM_COMPATIBLE_EVM, new BytesCapsule(ByteArray.fromLong((long)allowTvmCompatibleEvm)));
    }

    public long getAllowTvmCompatibleEvm() {
        String msg = "not found ALLOW_TVM_COMPATIBLE_EVM";
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_COMPATIBLE_EVM)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public boolean useNewRewardAlgorithm() {
        return this.getNewRewardAlgorithmEffectiveCycle() != Long.MAX_VALUE;
    }

    public void saveNewRewardAlgorithmEffectiveCycle() {
        if (this.getNewRewardAlgorithmEffectiveCycle() == Long.MAX_VALUE) {
            long currentCycle = this.getCurrentCycleNumber();
            this.put(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE, new BytesCapsule(ByteArray.fromLong((long)(currentCycle + 1L))));
        }
    }

    public long getNewRewardAlgorithmEffectiveCycle() {
        return Optional.ofNullable(this.getUnchecked(NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE"));
    }

    public long getAllowAccountAssetOptimizationFromRoot() {
        try {
            return Optional.ofNullable(this.getFromRoot(ALLOW_ASSET_OPTIMIZATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ASSET_OPTIMIZATION"));
        }
        catch (Exception e) {
            logger.debug("{}", (Object)e.getMessage());
            return CommonParameter.getInstance().getAllowAssetOptimization();
        }
    }

    public long getAllowAccountAssetOptimization() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_ACCOUNT_ASSET_OPTIMIZATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ACCOUNT_ASSET_OPTIMIZATION"));
    }

    public void setAllowAccountAssetOptimization(long value) {
        this.put(ALLOW_ACCOUNT_ASSET_OPTIMIZATION, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowAssetOptimization() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_ASSET_OPTIMIZATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_ASSET_OPTIMIZATION"));
    }

    public void setAllowAssetOptimization(long value) {
        this.put(ALLOW_ASSET_OPTIMIZATION, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public void saveEnergyPriceHistoryDone(long value) {
        this.put(ENERGY_PRICE_HISTORY_DONE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getEnergyPriceHistoryDone() {
        return Optional.ofNullable(this.getUnchecked(ENERGY_PRICE_HISTORY_DONE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ENERGY_PRICE_HISTORY_DONE"));
    }

    public String getEnergyPriceHistory() {
        return Optional.ofNullable(this.getUnchecked(ENERGY_PRICE_HISTORY)).map(BytesCapsule::getData).map(ByteArray::toStr).orElseThrow(() -> new IllegalArgumentException("not found ENERGY_PRICE_HISTORY"));
    }

    public void saveEnergyPriceHistory(String value) {
        this.put(ENERGY_PRICE_HISTORY, new BytesCapsule(ByteArray.fromString((String)value)));
    }

    public void saveBandwidthPriceHistoryDone(long value) {
        this.put(BANDWIDTH_PRICE_HISTORY_DONE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getBandwidthPriceHistoryDone() {
        return Optional.ofNullable(this.getUnchecked(BANDWIDTH_PRICE_HISTORY_DONE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found BANDWIDTH_PRICE_HISTORY_DONE"));
    }

    public String getBandwidthPriceHistory() {
        return Optional.ofNullable(this.getUnchecked(BANDWIDTH_PRICE_HISTORY)).map(BytesCapsule::getData).map(ByteArray::toStr).orElseThrow(() -> new IllegalArgumentException("not found BANDWIDTH_PRICE_HISTORY"));
    }

    public void saveBandwidthPriceHistory(String value) {
        this.put(BANDWIDTH_PRICE_HISTORY, new BytesCapsule(ByteArray.fromString((String)value)));
    }

    public long getSetBlackholeAccountPermission() {
        return Optional.of(this.getUnchecked(SET_BLACKHOLE_ACCOUNT_PERMISSION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found SET_BLACKHOLE_ACCOUNT_PERMISSION"));
    }

    public void saveSetBlackholePermission(long value) {
        this.put(SET_BLACKHOLE_ACCOUNT_PERMISSION, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public void saveAllowHigherLimitForMaxCpuTimeOfOneTx(long value) {
        this.put(ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowHigherLimitForMaxCpuTimeOfOneTx() {
        String msg = "not found ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX";
        return Optional.ofNullable(this.getUnchecked(ALLOW_HIGHER_LIMIT_FOR_MAX_CPU_TIME_OF_ONE_TX)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public long getMemoFee() {
        return Optional.ofNullable(this.getUnchecked(MEMO_FEE)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found MEMO_FEE"));
    }

    public void saveMemoFee(long value) {
        this.put(MEMO_FEE, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public String getMemoFeeHistory() {
        return Optional.ofNullable(this.getUnchecked(MEMO_FEE_HISTORY)).map(BytesCapsule::getData).map(ByteArray::toStr).orElseThrow(() -> new IllegalArgumentException("not found MEMO_FEE_HISTORY"));
    }

    public void saveMemoFeeHistory(String value) {
        this.put(MEMO_FEE_HISTORY, new BytesCapsule(ByteArray.fromString((String)value)));
    }

    public long getAllowNewReward() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_NEW_REWARD)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found AllowNewReward"));
    }

    public void saveAllowNewReward(long newReward) {
        this.put(ALLOW_NEW_REWARD, new BytesCapsule(ByteArray.fromLong((long)newReward)));
    }

    public long getAllowDelegateOptimization() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_DELEGATE_OPTIMIZATION)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_DELEGATE_OPTIMIZATION"));
    }

    public boolean supportAllowDelegateOptimization() {
        return this.getAllowDelegateOptimization() == 1L;
    }

    public void saveAllowDelegateOptimization(long value) {
        this.put(ALLOW_DELEGATE_OPTIMIZATION, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowDynamicEnergy() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_DYNAMIC_ENERGY)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found ALLOW_DYNAMIC_ENERGY"));
    }

    public boolean supportAllowDynamicEnergy() {
        return this.getAllowDynamicEnergy() == 1L;
    }

    public void saveAllowDynamicEnergy(long value) {
        this.put(ALLOW_DYNAMIC_ENERGY, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getDynamicEnergyThreshold() {
        return Optional.ofNullable(this.getUnchecked(DYNAMIC_ENERGY_THRESHOLD)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found DYNAMIC_ENERGY_THRESHOLD"));
    }

    public void saveDynamicEnergyThreshold(long value) {
        this.put(DYNAMIC_ENERGY_THRESHOLD, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getDynamicEnergyIncreaseFactor() {
        return Optional.ofNullable(this.getUnchecked(DYNAMIC_ENERGY_INCREASE_FACTOR)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found DYNAMIC_ENERGY_INCREASE_FACTOR"));
    }

    public void saveDynamicEnergyIncreaseFactor(long value) {
        this.put(DYNAMIC_ENERGY_INCREASE_FACTOR, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getDynamicEnergyMaxFactor() {
        return Optional.ofNullable(this.getUnchecked(DYNAMIC_ENERGY_MAX_FACTOR)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found DYNAMIC_ENERGY_MAX_FACTOR"));
    }

    public void saveDynamicEnergyMaxFactor(long value) {
        this.put(DYNAMIC_ENERGY_MAX_FACTOR, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public boolean allowNewReward() {
        return this.getAllowNewReward() == 1L;
    }

    public long getUnfreezeDelayDays() {
        return Optional.ofNullable(this.getUnchecked(UNFREEZE_DELAY_DAYS)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException("not found UNFREEZE_DELAY_DAYS"));
    }

    public boolean supportUnfreezeDelay() {
        return this.getUnfreezeDelayDays() > 0L;
    }

    public void saveUnfreezeDelayDays(long value) {
        this.put(UNFREEZE_DELAY_DAYS, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public void saveAllowOptimizedReturnValueOfChainId(long value) {
        this.put(ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID, new BytesCapsule(ByteArray.fromLong((long)value)));
    }

    public long getAllowOptimizedReturnValueOfChainId() {
        String msg = "not found ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID";
        return Optional.ofNullable(this.getUnchecked(ALLOW_OPTIMIZED_RETURN_VALUE_OF_CHAIN_ID)).map(BytesCapsule::getData).map(ByteArray::toLong).orElseThrow(() -> new IllegalArgumentException(msg));
    }

    public void saveAllowTvmShangHai(long allowTvmShangHai) {
        this.put(ALLOW_TVM_SHANGHAI, new BytesCapsule(ByteArray.fromLong((long)allowTvmShangHai)));
    }

    public long getAllowTvmShangHai() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_TVM_SHANGHAI)).map(BytesCapsule::getData).map(ByteArray::toLong).orElse(CommonParameter.getInstance().getAllowTvmShangHai());
    }

    public void saveAllowCancelAllUnfreezeV2(long allowCancelAllUnfreezeV2) {
        this.put(ALLOW_CANCEL_ALL_UNFREEZE_V2, new BytesCapsule(ByteArray.fromLong((long)allowCancelAllUnfreezeV2)));
    }

    public long getAllowCancelAllUnfreezeV2() {
        return Optional.ofNullable(this.getUnchecked(ALLOW_CANCEL_ALL_UNFREEZE_V2)).map(BytesCapsule::getData).map(ByteArray::toLong).orElse(CommonParameter.getInstance().getAllowCancelAllUnfreezeV2());
    }

    public boolean supportAllowCancelAllUnfreezeV2() {
        return this.getAllowCancelAllUnfreezeV2() == 1L && this.getUnfreezeDelayDays() > 0L;
    }

    public void saveMaxDelegateLockPeriod(long maxDelegateLockPeriod) {
        this.put(MAX_DELEGATE_LOCK_PERIOD, new BytesCapsule(ByteArray.fromLong((long)maxDelegateLockPeriod)));
    }

    public long getMaxDelegateLockPeriod() {
        return Optional.ofNullable(this.getUnchecked(MAX_DELEGATE_LOCK_PERIOD)).map(BytesCapsule::getData).map(ByteArray::toLong).orElse(86400L);
    }

    public boolean supportMaxDelegateLockPeriod() {
        return this.getMaxDelegateLockPeriod() > 86400L && this.getUnfreezeDelayDays() > 0L;
    }

    public static byte[] getTOKEN_ID_NUM() {
        return TOKEN_ID_NUM;
    }

    private static class DynamicResourceProperties {
        private static final byte[] ONE_DAY_NET_LIMIT = "ONE_DAY_NET_LIMIT".getBytes();
        private static final byte[] PUBLIC_NET_USAGE = "PUBLIC_NET_USAGE".getBytes();
        private static final byte[] PUBLIC_NET_LIMIT = "PUBLIC_NET_LIMIT".getBytes();
        private static final byte[] PUBLIC_NET_TIME = "PUBLIC_NET_TIME".getBytes();
        private static final byte[] FREE_NET_LIMIT = "FREE_NET_LIMIT".getBytes();
        private static final byte[] TOTAL_NET_WEIGHT = "TOTAL_NET_WEIGHT".getBytes();
        private static final byte[] TOTAL_NET_LIMIT = "TOTAL_NET_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_TARGET_LIMIT = "TOTAL_ENERGY_TARGET_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_CURRENT_LIMIT = "TOTAL_ENERGY_CURRENT_LIMIT".getBytes();
        private static final byte[] TOTAL_ENERGY_AVERAGE_USAGE = "TOTAL_ENERGY_AVERAGE_USAGE".getBytes();
        private static final byte[] TOTAL_ENERGY_AVERAGE_TIME = "TOTAL_ENERGY_AVERAGE_TIME".getBytes();
        private static final byte[] TOTAL_ENERGY_WEIGHT = "TOTAL_ENERGY_WEIGHT".getBytes();
        private static final byte[] TOTAL_TRON_POWER_WEIGHT = "TOTAL_TRON_POWER_WEIGHT".getBytes();
        private static final byte[] TOTAL_ENERGY_LIMIT = "TOTAL_ENERGY_LIMIT".getBytes();
        private static final byte[] BLOCK_ENERGY_USAGE = "BLOCK_ENERGY_USAGE".getBytes();
        private static final byte[] ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER = "ADAPTIVE_RESOURCE_LIMIT_MULTIPLIER".getBytes();
        private static final byte[] ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO = "ADAPTIVE_RESOURCE_LIMIT_TARGET_RATIO".getBytes();

        private DynamicResourceProperties() {
        }
    }
}

