/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class DelegatedResourceAccountIndexStore
extends TronStoreWithRevoking<DelegatedResourceAccountIndexCapsule> {
    private static final byte[] FROM_PREFIX = new byte[]{1};
    private static final byte[] TO_PREFIX = new byte[]{2};
    private static final byte[] V2_FROM_PREFIX = new byte[]{3};
    private static final byte[] V2_TO_PREFIX = new byte[]{4};

    @Autowired
    public DelegatedResourceAccountIndexStore(@Value(value="DelegatedResourceAccountIndex") String dbName) {
        super(dbName);
    }

    @Override
    public DelegatedResourceAccountIndexCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new DelegatedResourceAccountIndexCapsule(value);
    }

    public void convert(byte[] address) {
        DelegatedResourceAccountIndexCapsule indexCapsule = this.get(address);
        if (indexCapsule == null) {
            return;
        }
        List<ByteString> toList = indexCapsule.getToAccountsList();
        for (int i = 0; i < toList.size(); ++i) {
            this.delegate(address, toList.get(i).toByteArray(), (long)i + 1L);
        }
        List<ByteString> fromList = indexCapsule.getFromAccountsList();
        for (int i = 0; i < fromList.size(); ++i) {
            this.delegate(fromList.get(i).toByteArray(), address, (long)i + 1L);
        }
        this.delete(address);
    }

    public void delegate(byte[] from, byte[] to, long time) {
        byte[] fromKey = Bytes.concat((byte[][])new byte[][]{FROM_PREFIX, from, to});
        DelegatedResourceAccountIndexCapsule toIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])to));
        toIndexCapsule.setTimestamp(time);
        this.put(fromKey, toIndexCapsule);
        byte[] toKey = Bytes.concat((byte[][])new byte[][]{TO_PREFIX, to, from});
        DelegatedResourceAccountIndexCapsule fromIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])from));
        fromIndexCapsule.setTimestamp(time);
        this.put(toKey, fromIndexCapsule);
    }

    public void delegateV2(byte[] from, byte[] to, long time) {
        byte[] fromKey = Bytes.concat((byte[][])new byte[][]{V2_FROM_PREFIX, from, to});
        DelegatedResourceAccountIndexCapsule toIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])to));
        toIndexCapsule.setTimestamp(time);
        this.put(fromKey, toIndexCapsule);
        byte[] toKey = Bytes.concat((byte[][])new byte[][]{V2_TO_PREFIX, to, from});
        DelegatedResourceAccountIndexCapsule fromIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])from));
        fromIndexCapsule.setTimestamp(time);
        this.put(toKey, fromIndexCapsule);
    }

    public void unDelegate(byte[] from, byte[] to) {
        byte[] fromKey = Bytes.concat((byte[][])new byte[][]{FROM_PREFIX, from, to});
        this.delete(fromKey);
        byte[] toKey = Bytes.concat((byte[][])new byte[][]{TO_PREFIX, to, from});
        this.delete(toKey);
    }

    public void unDelegateV2(byte[] from, byte[] to) {
        byte[] fromKey = Bytes.concat((byte[][])new byte[][]{V2_FROM_PREFIX, from, to});
        this.delete(fromKey);
        byte[] toKey = Bytes.concat((byte[][])new byte[][]{V2_TO_PREFIX, to, from});
        this.delete(toKey);
    }

    public DelegatedResourceAccountIndexCapsule getIndex(byte[] address) {
        DelegatedResourceAccountIndexCapsule indexCapsule = this.get(address);
        if (indexCapsule != null) {
            return indexCapsule;
        }
        return this.getWithPrefix(FROM_PREFIX, TO_PREFIX, address);
    }

    public DelegatedResourceAccountIndexCapsule getV2Index(byte[] address) {
        return this.getWithPrefix(V2_FROM_PREFIX, V2_TO_PREFIX, address);
    }

    private DelegatedResourceAccountIndexCapsule getWithPrefix(byte[] fromPrefix, byte[] toPrefix, byte[] address) {
        DelegatedResourceAccountIndexCapsule tmpIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])address));
        byte[] key = Bytes.concat((byte[][])new byte[][]{fromPrefix, address});
        ArrayList tmpToList = new ArrayList(this.prefixQuery(key).values());
        tmpToList.sort(Comparator.comparing(DelegatedResourceAccountIndexCapsule::getTimestamp));
        List<Object> list = tmpToList.stream().map(DelegatedResourceAccountIndexCapsule::getAccount).collect(Collectors.toList());
        tmpIndexCapsule.setAllToAccounts(list);
        key = Bytes.concat((byte[][])new byte[][]{toPrefix, address});
        ArrayList tmpFromList = new ArrayList(this.prefixQuery(key).values());
        tmpFromList.sort(Comparator.comparing(DelegatedResourceAccountIndexCapsule::getTimestamp));
        list = tmpFromList.stream().map(DelegatedResourceAccountIndexCapsule::getAccount).collect(Collectors.toList());
        tmpIndexCapsule.setAllFromAccounts(list);
        return tmpIndexCapsule;
    }

    public static byte[] getV2_FROM_PREFIX() {
        return V2_FROM_PREFIX;
    }

    public static byte[] getV2_TO_PREFIX() {
        return V2_TO_PREFIX;
    }
}

