/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockBalanceTraceCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;
import org.tron.protos.contract.BalanceContract;

@Component
public class BalanceTraceStore
extends TronStoreWithRevoking<BlockBalanceTraceCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private BlockCapsule.BlockId currentBlockId;
    private Sha256Hash currentTransactionId;
    private BlockBalanceTraceCapsule currentBlockBalanceTraceCapsule;
    private BalanceContract.TransactionBalanceTrace currentTransactionBalanceTrace;

    @Autowired
    protected BalanceTraceStore(@Value(value="balance-trace") String dbName) {
        super(dbName);
    }

    public void setCurrentTransactionId(TransactionCapsule transactionCapsule) {
        if (this.currentBlockId == null) {
            return;
        }
        this.currentTransactionId = transactionCapsule.getTransactionId();
    }

    public void setCurrentBlockId(BlockCapsule blockCapsule) {
        this.currentBlockId = blockCapsule.getBlockId();
    }

    public void resetCurrentTransactionTrace() {
        if (!CommonParameter.getInstance().isHistoryBalanceLookup()) {
            return;
        }
        if (this.currentBlockId == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)this.currentTransactionBalanceTrace.getOperationList())) {
            this.currentBlockBalanceTraceCapsule.addTransactionBalanceTrace(this.currentTransactionBalanceTrace);
        }
        this.currentTransactionId = null;
        this.currentTransactionBalanceTrace = null;
    }

    public void resetCurrentBlockTrace() {
        if (CommonParameter.getInstance().isHistoryBalanceLookup()) {
            this.putBlockBalanceTrace(this.currentBlockBalanceTraceCapsule);
            this.currentBlockId = null;
            this.currentBlockBalanceTraceCapsule = null;
        }
    }

    public void initCurrentBlockBalanceTrace(BlockCapsule blockCapsule) {
        if (CommonParameter.getInstance().isHistoryBalanceLookup()) {
            this.setCurrentBlockId(blockCapsule);
            this.currentBlockBalanceTraceCapsule = new BlockBalanceTraceCapsule(blockCapsule);
        }
    }

    public void initCurrentTransactionBalanceTrace(TransactionCapsule transactionCapsule) {
        if (!CommonParameter.getInstance().isHistoryBalanceLookup()) {
            return;
        }
        if (this.currentBlockId == null) {
            return;
        }
        this.setCurrentTransactionId(transactionCapsule);
        this.currentTransactionBalanceTrace = BalanceContract.TransactionBalanceTrace.newBuilder().setTransactionIdentifier(transactionCapsule.getTransactionId().getByteString()).setType(transactionCapsule.getInstance().getRawData().getContract(0).getType().name()).build();
    }

    public void updateCurrentTransactionStatus(String status) {
        if (!CommonParameter.getInstance().isHistoryBalanceLookup()) {
            return;
        }
        if (this.currentBlockId == null) {
            return;
        }
        this.currentTransactionBalanceTrace = this.currentTransactionBalanceTrace.toBuilder().setStatus(StringUtils.isEmpty((CharSequence)status) ? "SUCCESS" : status).build();
    }

    private void putBlockBalanceTrace(BlockBalanceTraceCapsule blockBalanceTrace) {
        byte[] key = ByteArray.fromLong((long)this.getCurrentBlockId().getNum());
        this.put(key, blockBalanceTrace);
    }

    public BlockBalanceTraceCapsule getBlockBalanceTrace(BlockCapsule.BlockId blockId) throws BadItemException {
        long blockNumber = blockId.getNum();
        if (blockNumber == -1L) {
            return null;
        }
        byte[] key = ByteArray.fromLong((long)blockNumber);
        byte[] value = this.revokingDB.getUnchecked(key);
        if (Objects.isNull(value)) {
            return null;
        }
        BlockBalanceTraceCapsule blockBalanceTraceCapsule = new BlockBalanceTraceCapsule(value);
        if (Objects.isNull(blockBalanceTraceCapsule.getInstance())) {
            return null;
        }
        return blockBalanceTraceCapsule;
    }

    public BalanceContract.TransactionBalanceTrace getTransactionBalanceTrace(BlockCapsule.BlockId blockId, Sha256Hash transactionId) throws BadItemException {
        long blockNumber = blockId.getNum();
        if (blockNumber == -1L) {
            return null;
        }
        byte[] key = ByteArray.fromLong((long)blockNumber);
        byte[] value = this.revokingDB.getUnchecked(key);
        if (Objects.isNull(value)) {
            return null;
        }
        BlockBalanceTraceCapsule blockBalanceTraceCapsule = new BlockBalanceTraceCapsule(value);
        if (Objects.isNull(blockBalanceTraceCapsule.getInstance())) {
            return null;
        }
        for (BalanceContract.TransactionBalanceTrace transactionBalanceTrace : blockBalanceTraceCapsule.getInstance().getTransactionBalanceTraceList()) {
            if (!transactionBalanceTrace.getTransactionIdentifier().equals((Object)transactionId.getByteString())) continue;
            return transactionBalanceTrace;
        }
        return null;
    }

    public BlockCapsule.BlockId getCurrentBlockId() {
        return this.currentBlockId;
    }

    public Sha256Hash getCurrentTransactionId() {
        return this.currentTransactionId;
    }

    public BlockBalanceTraceCapsule getCurrentBlockBalanceTraceCapsule() {
        return this.currentBlockBalanceTraceCapsule;
    }

    public void setCurrentBlockBalanceTraceCapsule(BlockBalanceTraceCapsule currentBlockBalanceTraceCapsule) {
        this.currentBlockBalanceTraceCapsule = currentBlockBalanceTraceCapsule;
    }

    public BalanceContract.TransactionBalanceTrace getCurrentTransactionBalanceTrace() {
        return this.currentTransactionBalanceTrace;
    }

    public void setCurrentTransactionBalanceTrace(BalanceContract.TransactionBalanceTrace currentTransactionBalanceTrace) {
        this.currentTransactionBalanceTrace = currentTransactionBalanceTrace;
    }
}

