/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.common.iterator;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.db.common.iterator.DBIterator;

public final class StoreIterator
implements DBIterator {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private final org.iq80.leveldb.DBIterator dbIterator;
    private boolean first = true;
    private boolean valid = true;

    public StoreIterator(org.iq80.leveldb.DBIterator dbIterator) {
        this.dbIterator = dbIterator;
    }

    @Override
    public void close() throws IOException {
        this.dbIterator.close();
    }

    @Override
    public boolean hasNext() {
        if (!this.valid) {
            return false;
        }
        boolean hasNext = false;
        try {
            if (this.first) {
                this.dbIterator.seekToFirst();
                this.first = false;
            }
            if (!(hasNext = this.dbIterator.hasNext())) {
                this.dbIterator.close();
                this.valid = false;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return hasNext;
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (!this.valid) {
            throw new NoSuchElementException();
        }
        return (Map.Entry)this.dbIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

