/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.accountstate;

import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.protos.Protocol;

public class AccountStateEntity {
    private static final Logger logger = LoggerFactory.getLogger((String)"AccountState");
    private Protocol.Account account;

    public AccountStateEntity() {
    }

    public AccountStateEntity(Protocol.Account account) {
        Protocol.Account.Builder builder = Protocol.Account.newBuilder();
        builder.setAddress(account.getAddress());
        builder.setBalance(account.getBalance());
        builder.setAllowance(account.getAllowance());
        this.account = builder.build();
    }

    public static AccountStateEntity parse(byte[] data) {
        try {
            return new AccountStateEntity().setAccount(Protocol.Account.parseFrom((byte[])data));
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("Parse to AccountStateEntity error! reason: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Protocol.Account getAccount() {
        return this.account;
    }

    public AccountStateEntity setAccount(Protocol.Account account) {
        this.account = account;
        return this;
    }

    public byte[] toByteArrays() {
        return this.account.toByteArray();
    }

    public String toString() {
        return "address:" + StringUtil.encode58Check((byte[])this.account.getAddress().toByteArray()) + "; " + this.account.toString();
    }
}

