/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.accountstate;

import java.util.ArrayList;
import java.util.List;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db.accountstate.AccountStateEntity;

public class AccountStateCallBackUtils {
    protected volatile boolean execute = false;
    protected volatile boolean allowGenerateRoot = false;
    protected List<TrieEntry> trieEntryList = new ArrayList<TrieEntry>();

    public void accountCallBack(byte[] key, AccountCapsule item) {
        if (!this.exe()) {
            return;
        }
        if (item == null) {
            return;
        }
        this.trieEntryList.add(TrieEntry.build(key, new AccountStateEntity(item.getInstance()).toByteArrays()));
    }

    protected boolean exe() {
        if (!this.execute || !this.allowGenerateRoot) {
            this.execute = false;
            return false;
        }
        return true;
    }

    public static class TrieEntry {
        private byte[] key;
        private byte[] data;

        public static TrieEntry build(byte[] key, byte[] data) {
            TrieEntry trieEntry = new TrieEntry();
            return trieEntry.setKey(key).setData(data);
        }

        public byte[] getKey() {
            return this.key;
        }

        public TrieEntry setKey(byte[] key) {
            this.key = key;
            return this;
        }

        public byte[] getData() {
            return this.data;
        }

        public TrieEntry setData(byte[] data) {
            this.data = data;
            return this;
        }
    }
}

