/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.BlockStore;
import org.tron.core.db.KhaosDatabase;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;

@Component
public class TransactionStore
extends TronStoreWithRevoking<TransactionCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    @Autowired
    private BlockStore blockStore;
    @Autowired
    private KhaosDatabase khaosDatabase;

    @Autowired
    private TransactionStore(@Value(value="trans") String dbName) {
        super(dbName);
    }

    @Override
    public void put(byte[] key, TransactionCapsule item) {
        if (Objects.isNull(item) || item.getBlockNum() == -1L) {
            super.put(key, item);
        } else {
            this.revokingDB.put(key, ByteArray.fromLong((long)item.getBlockNum()));
        }
    }

    private TransactionCapsule getTransactionFromBlockStore(byte[] key, long blockNum) {
        List<BlockCapsule> blocksList = this.blockStore.getLimitNumber(blockNum, 1L);
        if (blocksList.size() != 0) {
            for (TransactionCapsule e : blocksList.get(0).getTransactions()) {
                if (!e.getTransactionId().equals((Object)Sha256Hash.wrap((byte[])key))) continue;
                return e;
            }
        }
        return null;
    }

    private TransactionCapsule getTransactionFromKhaosDatabase(byte[] key, long high) {
        List<KhaosDatabase.KhaosBlock> khaosBlocks = this.khaosDatabase.getMiniStore().getBlockByNum(high);
        if (khaosBlocks == null) {
            return null;
        }
        for (KhaosDatabase.KhaosBlock bl : khaosBlocks) {
            for (TransactionCapsule e : bl.getBlk().getTransactions()) {
                if (!e.getTransactionId().equals((Object)Sha256Hash.wrap((byte[])key))) continue;
                return e;
            }
        }
        return null;
    }

    public long getBlockNumber(byte[] key) throws BadItemException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return -1L;
        }
        if (value.length == 8) {
            return ByteArray.toLong((byte[])value);
        }
        TransactionCapsule transactionCapsule = new TransactionCapsule(value);
        return transactionCapsule.getBlockNum();
    }

    @Override
    public TransactionCapsule get(byte[] key) throws BadItemException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return null;
        }
        TransactionCapsule transactionCapsule = null;
        long blockHigh = -1L;
        if (value.length == 8 && (transactionCapsule = this.getTransactionFromBlockStore(key, blockHigh = ByteArray.toLong((byte[])value))) == null) {
            transactionCapsule = this.getTransactionFromKhaosDatabase(key, blockHigh);
        }
        if (transactionCapsule == null) {
            return new TransactionCapsule(value);
        }
        transactionCapsule.setBlockNum(blockHigh);
        return transactionCapsule;
    }

    @Override
    public TransactionCapsule getUnchecked(byte[] key) {
        try {
            return this.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public long getTotalTransactions() {
        return 0L;
    }
}

