/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.PbftSignCapsule;
import org.tron.core.db.TronDatabase;
import org.tron.protos.Protocol;

@Component
public class PbftSignDataStore
extends TronDatabase<PbftSignCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    public PbftSignDataStore() {
        super("pbft-sign-data");
    }

    @Override
    public void put(byte[] key, PbftSignCapsule item) {
        this.dbSource.putData(key, item.getData());
    }

    @Override
    public PbftSignCapsule get(byte[] key) {
        byte[] data = (byte[])this.dbSource.getData(key);
        if (ByteUtil.isNullOrZeroArray((byte[])data)) {
            return null;
        }
        return new PbftSignCapsule(data);
    }

    @Override
    public void delete(byte[] key) {
        this.dbSource.deleteData(key);
    }

    @Override
    public boolean has(byte[] key) {
        return this.dbSource.getData(key) != null;
    }

    public void putSrSignData(long epoch, PbftSignCapsule item) {
        this.put(this.buildSrSignKey(epoch), item);
    }

    public PbftSignCapsule getSrSignData(long epoch) {
        return this.get(this.buildSrSignKey(epoch));
    }

    public void putBlockSignData(long blockNum, PbftSignCapsule item) {
        this.put(this.buildBlockSignKey(blockNum), item);
    }

    public PbftSignCapsule getBlockSignData(long blockNum) {
        return this.get(this.buildBlockSignKey(blockNum));
    }

    private byte[] buildSrSignKey(long epoch) {
        return (Protocol.PBFTMessage.DataType.SRL.toString() + epoch).getBytes();
    }

    private byte[] buildBlockSignKey(long blockNum) {
        return (Protocol.PBFTMessage.DataType.BLOCK.toString() + blockNum).getBytes();
    }
}

