/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.BadItemException;

@Component
public class BlockStore
extends TronStoreWithRevoking<BlockCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    private BlockStore(@Value(value="block") String dbName) {
        super(dbName);
    }

    public List<BlockCapsule> getLimitNumber(long startNumber, long limit) {
        BlockCapsule.BlockId startBlockId = new BlockCapsule.BlockId(Sha256Hash.ZERO_HASH, startNumber);
        return this.pack(this.revokingDB.getValuesNext(startBlockId.getBytes(), limit));
    }

    public List<BlockCapsule> getBlockByLatestNum(long getNum) {
        return this.pack(this.revokingDB.getlatestValues(getNum));
    }

    private List<BlockCapsule> pack(Set<byte[]> values) {
        ArrayList<BlockCapsule> blocks = new ArrayList<BlockCapsule>();
        for (byte[] bytes : values) {
            try {
                blocks.add(new BlockCapsule(bytes));
            }
            catch (BadItemException e) {
                logger.error("Find bad item: {}", (Object)e.getMessage());
            }
        }
        blocks.sort(Comparator.comparing(BlockCapsule::getNum));
        return blocks;
    }
}

