/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class PbftSignCapsule
implements ProtoCapsule<Protocol.PBFTCommitResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)"pbft");
    private Protocol.PBFTCommitResult pbftCommitResult;

    public PbftSignCapsule(byte[] data) {
        try {
            this.pbftCommitResult = Protocol.PBFTCommitResult.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.error("", (Throwable)e);
        }
    }

    public PbftSignCapsule(ByteString data, List<ByteString> signList) {
        Protocol.PBFTCommitResult.Builder builder = Protocol.PBFTCommitResult.newBuilder();
        builder.setData(data).addAllSignature(signList);
        this.pbftCommitResult = builder.build();
    }

    @Override
    public byte[] getData() {
        return this.pbftCommitResult.toByteArray();
    }

    @Override
    public Protocol.PBFTCommitResult getInstance() {
        return this.pbftCommitResult;
    }

    public Protocol.PBFTCommitResult getPbftCommitResult() {
        return this.pbftCommitResult;
    }
}

