/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.protos.contract.BalanceContract;

public class AccountTraceCapsule
implements ProtoCapsule<BalanceContract.AccountTrace> {
    private BalanceContract.AccountTrace accountTrace;

    public AccountTraceCapsule() {
        this.accountTrace = BalanceContract.AccountTrace.newBuilder().build();
    }

    public AccountTraceCapsule(long balance) {
        this();
        this.accountTrace = this.accountTrace.toBuilder().setBalance(balance).build();
    }

    public AccountTraceCapsule(BalanceContract.AccountTrace accountTrace) {
        this.accountTrace = accountTrace;
    }

    public AccountTraceCapsule(byte[] data) throws BadItemException {
        try {
            this.accountTrace = BalanceContract.AccountTrace.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("AccountTraceCapsule proto data parse exception");
        }
    }

    public Long getBalance() {
        return this.accountTrace.getBalance();
    }

    @Override
    public byte[] getData() {
        if (Objects.isNull(this.accountTrace)) {
            return null;
        }
        if (this.accountTrace.getBalance() == 0L) {
            this.accountTrace = this.accountTrace.toBuilder().setPlaceholder(1L).build();
        }
        return this.accountTrace.toByteArray();
    }

    @Override
    public BalanceContract.AccountTrace getInstance() {
        return this.accountTrace;
    }
}

