/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.zksnark.IncrementalMerkleTreeContainer;
import org.tron.common.zksnark.MerklePath;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.capsule.PedersenHashCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.store.IncrementalMerkleTreeStore;
import org.tron.core.store.TreeBlockIndexStore;

public class MerkleContainer {
    private static final Logger logger = LoggerFactory.getLogger(MerkleContainer.class);
    private static final byte[] lastTreeKey = "LAST_TREE".getBytes();
    private static final byte[] currentTreeKey = "CURRENT_TREE".getBytes();
    private IncrementalMerkleTreeStore incrementalMerkleTreeStore;
    private TreeBlockIndexStore merkleTreeIndexStore;

    public static MerkleContainer createInstance(IncrementalMerkleTreeStore incrementalMerkleTreeStore, TreeBlockIndexStore merkleTreeIndexStore) {
        MerkleContainer instance = new MerkleContainer();
        instance.setIncrementalMerkleTreeStore(incrementalMerkleTreeStore);
        instance.setMerkleTreeIndexStore(merkleTreeIndexStore);
        return instance;
    }

    public IncrementalMerkleTreeContainer getCurrentMerkle() {
        IncrementalMerkleTreeCapsule capsule = this.incrementalMerkleTreeStore.get(currentTreeKey);
        if (capsule == null) {
            return this.getBestMerkle();
        }
        return capsule.toMerkleTreeContainer();
    }

    public void setCurrentMerkle(IncrementalMerkleTreeContainer treeContainer) {
        this.incrementalMerkleTreeStore.put(currentTreeKey, treeContainer.getTreeCapsule());
    }

    public IncrementalMerkleTreeContainer getBestMerkle() {
        IncrementalMerkleTreeCapsule capsule = this.incrementalMerkleTreeStore.get(lastTreeKey);
        if (capsule == null) {
            IncrementalMerkleTreeContainer container = new IncrementalMerkleTreeCapsule().toMerkleTreeContainer();
            return container;
        }
        return capsule.toMerkleTreeContainer();
    }

    public void resetCurrentMerkleTree() {
        IncrementalMerkleTreeContainer bestMerkle = this.getBestMerkle();
        this.setCurrentMerkle(bestMerkle);
    }

    public void saveCurrentMerkleTreeAsBestMerkleTree(long blockNum) throws ZksnarkException {
        IncrementalMerkleTreeContainer treeContainer = this.getCurrentMerkle();
        this.setBestMerkle(blockNum, treeContainer);
        this.putMerkleTreeIntoStore(treeContainer.getMerkleTreeKey(), treeContainer.getTreeCapsule());
    }

    public void setBestMerkle(long blockNum, IncrementalMerkleTreeContainer treeContainer) throws ZksnarkException {
        this.incrementalMerkleTreeStore.put(lastTreeKey, treeContainer.getTreeCapsule());
        this.merkleTreeIndexStore.put(blockNum, treeContainer.getMerkleTreeKey());
    }

    public boolean merkleRootExist(byte[] rt) {
        return this.incrementalMerkleTreeStore.contain(rt);
    }

    public IncrementalMerkleTreeCapsule getMerkleTree(byte[] rt) {
        return this.incrementalMerkleTreeStore.get(rt);
    }

    public IncrementalMerkleTreeContainer saveCmIntoMerkleTree(IncrementalMerkleTreeContainer tree, byte[] cm) throws ZksnarkException {
        PedersenHashCapsule pedersenHashCapsule = new PedersenHashCapsule();
        pedersenHashCapsule.setContent(ByteString.copyFrom((byte[])cm));
        tree.append(pedersenHashCapsule.getInstance());
        return tree;
    }

    public void putMerkleTreeIntoStore(byte[] key, IncrementalMerkleTreeCapsule capsule) {
        this.incrementalMerkleTreeStore.put(key, capsule);
    }

    public MerklePath merklePath(byte[] rt) throws ZksnarkException {
        if (!this.merkleRootExist(rt)) {
            return null;
        }
        IncrementalMerkleTreeContainer tree = this.incrementalMerkleTreeStore.get(rt).toMerkleTreeContainer();
        return tree.path();
    }

    public IncrementalMerkleTreeStore getIncrementalMerkleTreeStore() {
        return this.incrementalMerkleTreeStore;
    }

    public void setIncrementalMerkleTreeStore(IncrementalMerkleTreeStore incrementalMerkleTreeStore) {
        this.incrementalMerkleTreeStore = incrementalMerkleTreeStore;
    }

    public TreeBlockIndexStore getMerkleTreeIndexStore() {
        return this.merkleTreeIndexStore;
    }

    public void setMerkleTreeIndexStore(TreeBlockIndexStore merkleTreeIndexStore) {
        this.merkleTreeIndexStore = merkleTreeIndexStore;
    }
}

