/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.exception.ZksnarkException;

public class LibrustzcashParam {
    public static void validNull(byte[] value) throws ZksnarkException {
        if (ByteUtil.isNullOrZeroArray((byte[])value)) {
            throw new ZksnarkException("param is null");
        }
    }

    public static void validObjectNull(Object object) throws ZksnarkException {
        if (object == null) {
            throw new ZksnarkException("param is null");
        }
    }

    public static void validByteValue(byte src, byte desc) throws ZksnarkException {
        if (src != desc) {
            throw new ZksnarkException("param " + src + " not equals:" + desc);
        }
    }

    public static void validParamLength(byte[] value, int length) throws ZksnarkException {
        LibrustzcashParam.validNull(value);
        if (value.length != length) {
            throw new ZksnarkException("param length must be " + length);
        }
    }

    public static void valid11Params(byte[] value) throws ZksnarkException {
        LibrustzcashParam.validParamLength(value, 11);
    }

    public static void valid32Params(byte[] value) throws ZksnarkException {
        LibrustzcashParam.validParamLength(value, 32);
    }

    public static void validVoucherPath(byte[] voucherPath) throws ZksnarkException {
        LibrustzcashParam.validParamLength(voucherPath, 1065);
        LibrustzcashParam.validByteValue(voucherPath[0], (byte)32);
        for (int i = 0; i < 32; ++i) {
            LibrustzcashParam.validByteValue(voucherPath[1 + i * 33], (byte)32);
        }
    }

    public static void validValueParams(long value) throws ZksnarkException {
        if (value < 0L) {
            throw new ZksnarkException("Value should be non-negative.");
        }
    }

    public static void validPositionParams(long value) throws ZksnarkException {
        if (value < 0L) {
            throw new ZksnarkException("Position should be non-negative.");
        }
    }

    public static class MerkleHashParams
    implements ValidParam {
        private int depth;
        private byte[] a;
        private byte[] b;
        private byte[] result;

        public MerkleHashParams(int depth, byte[] a, byte[] b, byte[] result) throws ZksnarkException {
            this.depth = depth;
            this.a = a;
            this.b = b;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            if (this.depth >= 63 || this.depth < 0) {
                throw new ZksnarkException("Merkle tree depth must be smaller than 63");
            }
            LibrustzcashParam.valid32Params(this.a);
            LibrustzcashParam.valid32Params(this.b);
            LibrustzcashParam.valid32Params(this.result);
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setA(byte[] a) {
            this.a = a;
        }

        public byte[] getA() {
            return this.a;
        }

        public void setB(byte[] b) {
            this.b = b;
        }

        public byte[] getB() {
            return this.b;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class IvkToPkdParams
    implements ValidParam {
        private byte[] ivk;
        private byte[] d;
        private byte[] pkD;

        public IvkToPkdParams(byte[] ivk, byte[] d, byte[] pkD) throws ZksnarkException {
            this.ivk = ivk;
            this.d = d;
            this.pkD = pkD;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.ivk);
            LibrustzcashParam.valid11Params(this.d);
            LibrustzcashParam.valid32Params(this.pkD);
            if (this.ivk[31] >> 3 != 0) {
                throw new ZksnarkException("Most significant five bits of ivk should be 0.");
            }
        }

        public void setIvk(byte[] ivk) {
            this.ivk = ivk;
        }

        public byte[] getIvk() {
            return this.ivk;
        }

        public void setD(byte[] d) {
            this.d = d;
        }

        public byte[] getD() {
            return this.d;
        }

        public void setPkD(byte[] pkD) {
            this.pkD = pkD;
        }

        public byte[] getPkD() {
            return this.pkD;
        }
    }

    public static class FinalCheckNewParams
    implements ValidParam {
        private long valueBalance;
        private byte[] bindingSig;
        private byte[] sighashValue;
        private byte[] spendCv;
        private int spendCvLen;
        private byte[] outputCv;
        private int outputCvLen;

        public FinalCheckNewParams(long valueBalance, byte[] bindingSig, byte[] sighashValue, byte[] spendCv, int spendCvLen, byte[] outputCv, int outputCvLen) throws ZksnarkException {
            this.valueBalance = valueBalance;
            this.bindingSig = bindingSig;
            this.sighashValue = sighashValue;
            this.spendCv = spendCv;
            this.spendCvLen = spendCvLen;
            this.outputCv = outputCv;
            this.outputCvLen = outputCvLen;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validParamLength(this.bindingSig, 64);
            LibrustzcashParam.valid32Params(this.sighashValue);
            if (this.spendCvLen <= 0 || this.outputCvLen <= 0) {
                throw new ZksnarkException("spendCvLen and  outputCvLen must be positive");
            }
            if (this.spendCvLen % 32 != 0 || this.outputCvLen % 32 != 0) {
                throw new ZksnarkException("spendCvLen and  ouFinalCheckNewParamstputCvLen must be multiple of 32");
            }
            LibrustzcashParam.validParamLength(this.spendCv, this.spendCvLen);
            LibrustzcashParam.validParamLength(this.outputCv, this.outputCvLen);
        }

        public void setValueBalance(long valueBalance) {
            this.valueBalance = valueBalance;
        }

        public long getValueBalance() {
            return this.valueBalance;
        }

        public void setBindingSig(byte[] bindingSig) {
            this.bindingSig = bindingSig;
        }

        public byte[] getBindingSig() {
            return this.bindingSig;
        }

        public void setSighashValue(byte[] sighashValue) {
            this.sighashValue = sighashValue;
        }

        public byte[] getSighashValue() {
            return this.sighashValue;
        }

        public void setSpendCv(byte[] spendCv) {
            this.spendCv = spendCv;
        }

        public byte[] getSpendCv() {
            return this.spendCv;
        }

        public void setSpendCvLen(int spendCvLen) {
            this.spendCvLen = spendCvLen;
        }

        public int getSpendCvLen() {
            return this.spendCvLen;
        }

        public void setOutputCv(byte[] outputCv) {
            this.outputCv = outputCv;
        }

        public byte[] getOutputCv() {
            return this.outputCv;
        }

        public void setOutputCvLen(int outputCvLen) {
            this.outputCvLen = outputCvLen;
        }

        public int getOutputCvLen() {
            return this.outputCvLen;
        }
    }

    public static class CheckOutputNewParams
    implements ValidParam {
        private byte[] cv;
        private byte[] cm;
        private byte[] ephemeralKey;
        private byte[] zkproof;

        public CheckOutputNewParams(byte[] cv, byte[] cm, byte[] ephemeralKey, byte[] zkproof) throws ZksnarkException {
            this.cv = cv;
            this.cm = cm;
            this.ephemeralKey = ephemeralKey;
            this.zkproof = zkproof;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.valid32Params(this.cm);
            LibrustzcashParam.valid32Params(this.ephemeralKey);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setCm(byte[] cm) {
            this.cm = cm;
        }

        public byte[] getCm() {
            return this.cm;
        }

        public void setEphemeralKey(byte[] ephemeralKey) {
            this.ephemeralKey = ephemeralKey;
        }

        public byte[] getEphemeralKey() {
            return this.ephemeralKey;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }
    }

    public static class CheckSpendNewParams
    implements ValidParam {
        private byte[] cv;
        private byte[] anchor;
        private byte[] nullifier;
        private byte[] rk;
        private byte[] zkproof;
        private byte[] spendAuthSig;
        private byte[] sighashValue;

        public CheckSpendNewParams(byte[] cv, byte[] anchor, byte[] nullifier, byte[] rk, byte[] zkproof, byte[] spendAuthSig, byte[] sighashValue) throws ZksnarkException {
            this.cv = cv;
            this.anchor = anchor;
            this.nullifier = nullifier;
            this.rk = rk;
            this.zkproof = zkproof;
            this.spendAuthSig = spendAuthSig;
            this.sighashValue = sighashValue;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.valid32Params(this.anchor);
            LibrustzcashParam.valid32Params(this.nullifier);
            LibrustzcashParam.valid32Params(this.rk);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
            LibrustzcashParam.validParamLength(this.spendAuthSig, 64);
            LibrustzcashParam.valid32Params(this.sighashValue);
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setAnchor(byte[] anchor) {
            this.anchor = anchor;
        }

        public byte[] getAnchor() {
            return this.anchor;
        }

        public void setNullifier(byte[] nullifier) {
            this.nullifier = nullifier;
        }

        public byte[] getNullifier() {
            return this.nullifier;
        }

        public void setRk(byte[] rk) {
            this.rk = rk;
        }

        public byte[] getRk() {
            return this.rk;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }

        public void setSpendAuthSig(byte[] spendAuthSig) {
            this.spendAuthSig = spendAuthSig;
        }

        public byte[] getSpendAuthSig() {
            return this.spendAuthSig;
        }

        public void setSighashValue(byte[] sighashValue) {
            this.sighashValue = sighashValue;
        }

        public byte[] getSighashValue() {
            return this.sighashValue;
        }
    }

    public static class FinalCheckParams
    implements ValidParam {
        private long ctx;
        private long valueBalance;
        private byte[] bindingSig;
        private byte[] sighashValue;

        public FinalCheckParams(long ctx, long valueBalance, byte[] bindingSig, byte[] sighashValue) throws ZksnarkException {
            this.ctx = ctx;
            this.valueBalance = valueBalance;
            this.bindingSig = bindingSig;
            this.sighashValue = sighashValue;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validParamLength(this.bindingSig, 64);
            LibrustzcashParam.valid32Params(this.sighashValue);
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setValueBalance(long valueBalance) {
            this.valueBalance = valueBalance;
        }

        public long getValueBalance() {
            return this.valueBalance;
        }

        public void setBindingSig(byte[] bindingSig) {
            this.bindingSig = bindingSig;
        }

        public byte[] getBindingSig() {
            return this.bindingSig;
        }

        public void setSighashValue(byte[] sighashValue) {
            this.sighashValue = sighashValue;
        }

        public byte[] getSighashValue() {
            return this.sighashValue;
        }
    }

    public static class CheckOutputParams
    implements ValidParam {
        private long ctx;
        private byte[] cv;
        private byte[] cm;
        private byte[] ephemeralKey;
        private byte[] zkproof;

        public CheckOutputParams(long ctx, byte[] cv, byte[] cm, byte[] ephemeralKey, byte[] zkproof) throws ZksnarkException {
            this.ctx = ctx;
            this.cv = cv;
            this.cm = cm;
            this.ephemeralKey = ephemeralKey;
            this.zkproof = zkproof;
            this.valid();
        }

        public static CheckOutputParams decode(long ctx, byte[] data) throws ZksnarkException {
            byte[] cv = new byte[32];
            byte[] cm = new byte[32];
            byte[] ephemeralKey = new byte[32];
            byte[] zkproof = new byte[192];
            System.arraycopy(data, 0, cv, 0, 32);
            System.arraycopy(data, 32, cm, 0, 32);
            System.arraycopy(data, 64, ephemeralKey, 0, 32);
            System.arraycopy(data, 96, zkproof, 0, 192);
            return new CheckOutputParams(ctx, cv, cm, ephemeralKey, zkproof);
        }

        public static CheckOutputParams decodeZ(long ctx, byte[] data) throws ZksnarkException {
            byte[] cv = new byte[32];
            byte[] cm = new byte[32];
            byte[] ephemeralKey = new byte[32];
            byte[] zkproof = new byte[192];
            System.arraycopy(data, 0, cv, 0, 32);
            System.arraycopy(data, 32, cm, 0, 32);
            System.arraycopy(data, 64, ephemeralKey, 0, 32);
            System.arraycopy(data, 756, zkproof, 0, 192);
            return new CheckOutputParams(ctx, cv, cm, ephemeralKey, zkproof);
        }

        public byte[] encode() {
            byte[] data = new byte[288];
            System.arraycopy(this.cv, 0, data, 0, 32);
            System.arraycopy(this.cm, 0, data, 32, 32);
            System.arraycopy(this.ephemeralKey, 0, data, 64, 32);
            System.arraycopy(this.zkproof, 0, data, 96, 192);
            return data;
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.valid32Params(this.cm);
            LibrustzcashParam.valid32Params(this.ephemeralKey);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setCm(byte[] cm) {
            this.cm = cm;
        }

        public byte[] getCm() {
            return this.cm;
        }

        public void setEphemeralKey(byte[] ephemeralKey) {
            this.ephemeralKey = ephemeralKey;
        }

        public byte[] getEphemeralKey() {
            return this.ephemeralKey;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }
    }

    public static class CheckSpendParams
    implements ValidParam {
        private long ctx;
        private byte[] cv;
        private byte[] anchor;
        private byte[] nullifier;
        private byte[] rk;
        private byte[] zkproof;
        private byte[] spendAuthSig;
        private byte[] sighashValue;

        public CheckSpendParams(long ctx, byte[] cv, byte[] anchor, byte[] nullifier, byte[] rk, byte[] zkproof, byte[] spendAuthSig, byte[] sighashValue) throws ZksnarkException {
            this.ctx = ctx;
            this.cv = cv;
            this.anchor = anchor;
            this.nullifier = nullifier;
            this.rk = rk;
            this.zkproof = zkproof;
            this.spendAuthSig = spendAuthSig;
            this.sighashValue = sighashValue;
            this.valid();
        }

        public static CheckSpendParams decode(long ctx, byte[] data, byte[] sigHashValue) throws ZksnarkException {
            byte[] cv = new byte[32];
            byte[] anchor = new byte[32];
            byte[] nullifier = new byte[32];
            byte[] rk = new byte[32];
            byte[] zkproof = new byte[192];
            byte[] spendAuthSig = new byte[64];
            System.arraycopy(data, 0, cv, 0, 32);
            System.arraycopy(data, 32, anchor, 0, 32);
            System.arraycopy(data, 64, nullifier, 0, 32);
            System.arraycopy(data, 96, rk, 0, 32);
            System.arraycopy(data, 128, zkproof, 0, 192);
            System.arraycopy(data, 320, spendAuthSig, 0, 64);
            return new CheckSpendParams(ctx, cv, anchor, nullifier, rk, zkproof, spendAuthSig, sigHashValue);
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.valid32Params(this.anchor);
            LibrustzcashParam.valid32Params(this.nullifier);
            LibrustzcashParam.valid32Params(this.rk);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
            LibrustzcashParam.validParamLength(this.spendAuthSig, 64);
            LibrustzcashParam.valid32Params(this.sighashValue);
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setAnchor(byte[] anchor) {
            this.anchor = anchor;
        }

        public byte[] getAnchor() {
            return this.anchor;
        }

        public void setNullifier(byte[] nullifier) {
            this.nullifier = nullifier;
        }

        public byte[] getNullifier() {
            return this.nullifier;
        }

        public void setRk(byte[] rk) {
            this.rk = rk;
        }

        public byte[] getRk() {
            return this.rk;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }

        public void setSpendAuthSig(byte[] spendAuthSig) {
            this.spendAuthSig = spendAuthSig;
        }

        public byte[] getSpendAuthSig() {
            return this.spendAuthSig;
        }

        public void setSighashValue(byte[] sighashValue) {
            this.sighashValue = sighashValue;
        }

        public byte[] getSighashValue() {
            return this.sighashValue;
        }
    }

    public static class BindingSigParams
    implements ValidParam {
        private long ctx;
        private long valueBalance;
        private byte[] sighash;
        private byte[] result;

        public BindingSigParams(long ctx, long valueBalance, byte[] sighash, byte[] result) throws ZksnarkException {
            this.ctx = ctx;
            this.valueBalance = valueBalance;
            this.sighash = sighash;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.sighash);
            LibrustzcashParam.validParamLength(this.result, 64);
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setValueBalance(long valueBalance) {
            this.valueBalance = valueBalance;
        }

        public long getValueBalance() {
            return this.valueBalance;
        }

        public void setSighash(byte[] sighash) {
            this.sighash = sighash;
        }

        public byte[] getSighash() {
            return this.sighash;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class SpendSigParams
    implements ValidParam {
        private byte[] ask;
        private byte[] alpha;
        private byte[] sigHash;
        private byte[] result;

        public SpendSigParams(byte[] ask, byte[] alpha, byte[] sigHash, byte[] result) throws ZksnarkException {
            this.ask = ask;
            this.alpha = alpha;
            this.sigHash = sigHash;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.ask);
            LibrustzcashParam.valid32Params(this.alpha);
            LibrustzcashParam.valid32Params(this.sigHash);
            LibrustzcashParam.validParamLength(this.result, 64);
        }

        public void setAsk(byte[] ask) {
            this.ask = ask;
        }

        public byte[] getAsk() {
            return this.ask;
        }

        public void setAlpha(byte[] alpha) {
            this.alpha = alpha;
        }

        public byte[] getAlpha() {
            return this.alpha;
        }

        public void setSigHash(byte[] sigHash) {
            this.sigHash = sigHash;
        }

        public byte[] getSigHash() {
            return this.sigHash;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class OutputProofParams
    implements ValidParam {
        private long ctx;
        private byte[] esk;
        private byte[] d;
        private byte[] pkD;
        private byte[] r;
        private long value;
        private byte[] cv;
        private byte[] zkproof;

        public OutputProofParams(long ctx, byte[] esk, byte[] d, byte[] pkD, byte[] r, long value, byte[] cv, byte[] zkproof) throws ZksnarkException {
            this.ctx = ctx;
            this.esk = esk;
            this.d = d;
            this.pkD = pkD;
            this.r = r;
            this.value = value;
            this.cv = cv;
            this.zkproof = zkproof;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validValueParams(this.value);
            LibrustzcashParam.valid32Params(this.esk);
            LibrustzcashParam.valid11Params(this.d);
            LibrustzcashParam.valid32Params(this.pkD);
            LibrustzcashParam.valid32Params(this.r);
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setEsk(byte[] esk) {
            this.esk = esk;
        }

        public byte[] getEsk() {
            return this.esk;
        }

        public void setD(byte[] d) {
            this.d = d;
        }

        public byte[] getD() {
            return this.d;
        }

        public void setPkD(byte[] pkD) {
            this.pkD = pkD;
        }

        public byte[] getPkD() {
            return this.pkD;
        }

        public void setR(byte[] r) {
            this.r = r;
        }

        public byte[] getR() {
            return this.r;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }
    }

    public static class SpendProofParams
    implements ValidParam {
        private long ctx;
        private byte[] ak;
        private byte[] nsk;
        private byte[] d;
        private byte[] r;
        private byte[] alpha;
        private long value;
        private byte[] anchor;
        private byte[] voucherPath;
        private byte[] cv;
        private byte[] rk;
        private byte[] zkproof;

        public SpendProofParams(long ctx, byte[] ak, byte[] nsk, byte[] d, byte[] r, byte[] alpha, long value, byte[] anchor, byte[] voucherPath, byte[] cv, byte[] rk, byte[] zkproof) throws ZksnarkException {
            this.ctx = ctx;
            this.ak = ak;
            this.nsk = nsk;
            this.d = d;
            this.r = r;
            this.alpha = alpha;
            this.value = value;
            this.anchor = anchor;
            this.voucherPath = voucherPath;
            this.cv = cv;
            this.rk = rk;
            this.zkproof = zkproof;
            this.valid();
        }

        public static SpendProofParams decode(long ctx, byte[] data) throws ZksnarkException {
            byte[] ak = new byte[32];
            byte[] nsk = new byte[32];
            byte[] d = new byte[11];
            byte[] r = new byte[32];
            byte[] alpha = new byte[32];
            byte[] valueByte = new byte[8];
            byte[] anchor = new byte[32];
            byte[] voucherPath = new byte[1065];
            byte[] cv = new byte[32];
            byte[] rk = new byte[192];
            byte[] zkproof = new byte[64];
            System.arraycopy(data, 0, ak, 0, 32);
            System.arraycopy(data, 32, nsk, 0, 32);
            System.arraycopy(data, 64, d, 0, 11);
            System.arraycopy(data, 75, r, 0, 32);
            System.arraycopy(data, 107, alpha, 0, 32);
            System.arraycopy(data, 139, valueByte, 0, 8);
            System.arraycopy(data, 147, anchor, 0, 32);
            System.arraycopy(data, 179, voucherPath, 0, 1065);
            System.arraycopy(data, 1244, cv, 0, 32);
            System.arraycopy(data, 1276, rk, 0, 192);
            System.arraycopy(data, 1308, zkproof, 0, 64);
            return new SpendProofParams(ctx, ak, nsk, d, r, alpha, ByteArray.toLong((byte[])valueByte), anchor, voucherPath, cv, rk, zkproof);
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validValueParams(this.value);
            LibrustzcashParam.valid32Params(this.ak);
            LibrustzcashParam.valid32Params(this.nsk);
            LibrustzcashParam.valid11Params(this.d);
            LibrustzcashParam.valid32Params(this.r);
            LibrustzcashParam.valid32Params(this.alpha);
            LibrustzcashParam.valid32Params(this.anchor);
            LibrustzcashParam.validVoucherPath(this.voucherPath);
            LibrustzcashParam.valid32Params(this.cv);
            LibrustzcashParam.valid32Params(this.rk);
            LibrustzcashParam.validParamLength(this.zkproof, 192);
        }

        public byte[] encode() {
            byte[] data = new byte[1500];
            System.arraycopy(this.ak, 0, data, 0, 32);
            System.arraycopy(this.nsk, 0, data, 32, 32);
            System.arraycopy(this.d, 0, data, 64, 11);
            System.arraycopy(this.r, 0, data, 75, 32);
            System.arraycopy(this.alpha, 0, data, 107, 32);
            System.arraycopy(ByteArray.fromLong((long)this.value), 0, data, 139, 8);
            System.arraycopy(this.anchor, 0, data, 147, 32);
            System.arraycopy(this.voucherPath, 0, data, 179, 1065);
            System.arraycopy(this.cv, 0, data, 1244, 32);
            System.arraycopy(this.rk, 0, data, 1276, 32);
            System.arraycopy(this.zkproof, 0, data, 1308, 192);
            return data;
        }

        public void setCtx(long ctx) {
            this.ctx = ctx;
        }

        public long getCtx() {
            return this.ctx;
        }

        public void setAk(byte[] ak) {
            this.ak = ak;
        }

        public byte[] getAk() {
            return this.ak;
        }

        public void setNsk(byte[] nsk) {
            this.nsk = nsk;
        }

        public byte[] getNsk() {
            return this.nsk;
        }

        public void setD(byte[] d) {
            this.d = d;
        }

        public byte[] getD() {
            return this.d;
        }

        public void setR(byte[] r) {
            this.r = r;
        }

        public byte[] getR() {
            return this.r;
        }

        public void setAlpha(byte[] alpha) {
            this.alpha = alpha;
        }

        public byte[] getAlpha() {
            return this.alpha;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setAnchor(byte[] anchor) {
            this.anchor = anchor;
        }

        public byte[] getAnchor() {
            return this.anchor;
        }

        public void setVoucherPath(byte[] voucherPath) {
            this.voucherPath = voucherPath;
        }

        public byte[] getVoucherPath() {
            return this.voucherPath;
        }

        public void setCv(byte[] cv) {
            this.cv = cv;
        }

        public byte[] getCv() {
            return this.cv;
        }

        public void setRk(byte[] rk) {
            this.rk = rk;
        }

        public byte[] getRk() {
            return this.rk;
        }

        public void setZkproof(byte[] zkproof) {
            this.zkproof = zkproof;
        }

        public byte[] getZkproof() {
            return this.zkproof;
        }
    }

    public static class KaDerivepublicParams
    implements ValidParam {
        private byte[] diversifier;
        private byte[] esk;
        private byte[] result;

        public KaDerivepublicParams(byte[] diversifier, byte[] esk, byte[] result) throws ZksnarkException {
            this.diversifier = diversifier;
            this.esk = esk;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid11Params(this.diversifier);
            LibrustzcashParam.valid32Params(this.esk);
            LibrustzcashParam.valid32Params(this.result);
        }

        public void setDiversifier(byte[] diversifier) {
            this.diversifier = diversifier;
        }

        public byte[] getDiversifier() {
            return this.diversifier;
        }

        public void setEsk(byte[] esk) {
            this.esk = esk;
        }

        public byte[] getEsk() {
            return this.esk;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class ComputeNfParams
    implements ValidParam {
        private byte[] d;
        private byte[] pkD;
        private long value;
        private byte[] r;
        private byte[] ak;
        private byte[] nk;
        private long position;
        private byte[] result;

        public ComputeNfParams(byte[] d, byte[] pkD, long value, byte[] r, byte[] ak, byte[] nk, long position, byte[] result) throws ZksnarkException {
            this.d = d;
            this.pkD = pkD;
            this.value = value;
            this.r = r;
            this.ak = ak;
            this.nk = nk;
            this.position = position;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validValueParams(this.value);
            LibrustzcashParam.validPositionParams(this.position);
            LibrustzcashParam.valid11Params(this.d);
            LibrustzcashParam.valid32Params(this.pkD);
            LibrustzcashParam.valid32Params(this.r);
            LibrustzcashParam.valid32Params(this.ak);
            LibrustzcashParam.valid32Params(this.nk);
            LibrustzcashParam.valid32Params(this.result);
        }

        public void setD(byte[] d) {
            this.d = d;
        }

        public byte[] getD() {
            return this.d;
        }

        public void setPkD(byte[] pkD) {
            this.pkD = pkD;
        }

        public byte[] getPkD() {
            return this.pkD;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setR(byte[] r) {
            this.r = r;
        }

        public byte[] getR() {
            return this.r;
        }

        public void setAk(byte[] ak) {
            this.ak = ak;
        }

        public byte[] getAk() {
            return this.ak;
        }

        public void setNk(byte[] nk) {
            this.nk = nk;
        }

        public byte[] getNk() {
            return this.nk;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public long getPosition() {
            return this.position;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class ComputeCmParams
    implements ValidParam {
        private byte[] d;
        private byte[] pkD;
        private long value;
        private byte[] r;
        private byte[] cm;

        public ComputeCmParams(byte[] d, byte[] pkD, long value, byte[] r, byte[] cm) throws ZksnarkException {
            this.d = d;
            this.pkD = pkD;
            this.value = value;
            this.r = r;
            this.cm = cm;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validValueParams(this.value);
            LibrustzcashParam.valid11Params(this.d);
            LibrustzcashParam.valid32Params(this.pkD);
            LibrustzcashParam.valid32Params(this.r);
            LibrustzcashParam.valid32Params(this.cm);
        }

        public void setD(byte[] d) {
            this.d = d;
        }

        public byte[] getD() {
            return this.d;
        }

        public void setPkD(byte[] pkD) {
            this.pkD = pkD;
        }

        public byte[] getPkD() {
            return this.pkD;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setR(byte[] r) {
            this.r = r;
        }

        public byte[] getR() {
            return this.r;
        }

        public void setCm(byte[] cm) {
            this.cm = cm;
        }

        public byte[] getCm() {
            return this.cm;
        }
    }

    public static class KaAgreeParams
    implements ValidParam {
        private byte[] p;
        private byte[] sk;
        private byte[] result;

        public KaAgreeParams(byte[] p, byte[] sk, byte[] result) throws ZksnarkException {
            this.p = p;
            this.sk = sk;
            this.result = result;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.p);
            LibrustzcashParam.valid32Params(this.sk);
            LibrustzcashParam.valid32Params(this.result);
        }

        public void setP(byte[] p) {
            this.p = p;
        }

        public byte[] getP() {
            return this.p;
        }

        public void setSk(byte[] sk) {
            this.sk = sk;
        }

        public byte[] getSk() {
            return this.sk;
        }

        public void setResult(byte[] result) {
            this.result = result;
        }

        public byte[] getResult() {
            return this.result;
        }
    }

    public static class CrhIvkParams
    implements ValidParam {
        private byte[] ak;
        private byte[] nk;
        private byte[] ivk;

        public CrhIvkParams(byte[] ak, byte[] nk, byte[] ivk) throws ZksnarkException {
            this.ak = ak;
            this.nk = nk;
            this.ivk = ivk;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.valid32Params(this.ak);
            LibrustzcashParam.valid32Params(this.nk);
            LibrustzcashParam.valid32Params(this.ivk);
        }

        public void setAk(byte[] ak) {
            this.ak = ak;
        }

        public byte[] getAk() {
            return this.ak;
        }

        public void setNk(byte[] nk) {
            this.nk = nk;
        }

        public byte[] getNk() {
            return this.nk;
        }

        public void setIvk(byte[] ivk) {
            this.ivk = ivk;
        }

        public byte[] getIvk() {
            return this.ivk;
        }
    }

    public static class Zip32XfvkAddressParams
    implements ValidParam {
        private byte[] xfvk;
        private byte[] j;
        private byte[] j_ret;
        private byte[] addr_ret;

        public Zip32XfvkAddressParams(byte[] xfvk, byte[] j, byte[] j_ret, byte[] addr_ret) throws ZksnarkException {
            this.xfvk = xfvk;
            this.j = j;
            this.j_ret = j_ret;
            this.addr_ret = addr_ret;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
        }

        public void setXfvk(byte[] xfvk) {
            this.xfvk = xfvk;
        }

        public byte[] getXfvk() {
            return this.xfvk;
        }

        public void setJ(byte[] j) {
            this.j = j;
        }

        public byte[] getJ() {
            return this.j;
        }

        public void setJ_ret(byte[] j_ret) {
            this.j_ret = j_ret;
        }

        public byte[] getJ_ret() {
            return this.j_ret;
        }

        public void setAddr_ret(byte[] addr_ret) {
            this.addr_ret = addr_ret;
        }

        public byte[] getAddr_ret() {
            return this.addr_ret;
        }
    }

    public static class Zip32XskDeriveParams
    extends Zip32XskMasterParams
    implements ValidParam {
        public Zip32XskDeriveParams(byte[] data, int size, byte[] m_bytes) throws ZksnarkException {
            super(data, size, m_bytes);
        }

        @Override
        public void valid() throws ZksnarkException {
        }
    }

    public static class Zip32XskMasterParams
    implements ValidParam {
        private byte[] data;
        private int size;
        private byte[] m_bytes;

        public Zip32XskMasterParams(byte[] data, int size, byte[] m_bytes) throws ZksnarkException {
            this.data = data;
            this.size = size;
            this.m_bytes = m_bytes;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
            LibrustzcashParam.validParamLength(this.m_bytes, 169);
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setM_bytes(byte[] m_bytes) {
            this.m_bytes = m_bytes;
        }

        public byte[] getM_bytes() {
            return this.m_bytes;
        }
    }

    public static class InitZksnarkParams
    implements ValidParam {
        private String spend_path;
        private String spend_hash;
        private String output_path;
        private String output_hash;

        public InitZksnarkParams(String spend_path, String spend_hash, String output_path, String output_hash) throws ZksnarkException {
            this.spend_path = spend_path;
            this.spend_hash = spend_hash;
            this.output_path = output_path;
            this.output_hash = output_hash;
            this.valid();
        }

        @Override
        public void valid() throws ZksnarkException {
        }

        public void setSpend_path(String spend_path) {
            this.spend_path = spend_path;
        }

        public String getSpend_path() {
            return this.spend_path;
        }

        public void setSpend_hash(String spend_hash) {
            this.spend_hash = spend_hash;
        }

        public String getSpend_hash() {
            return this.spend_hash;
        }

        public void setOutput_path(String output_path) {
            this.output_path = output_path;
        }

        public String getOutput_path() {
            return this.output_path;
        }

        public void setOutput_hash(String output_hash) {
            this.output_hash = output_hash;
        }

        public String getOutput_hash() {
            return this.output_hash;
        }
    }

    static interface ValidParam {
        public void valid() throws ZksnarkException;
    }
}

