/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage.leveldb;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.storage.WriteOptionsWrapper;
import org.tron.common.storage.metric.DbStat;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.StorageUtils;
import org.tron.core.db.common.DbSourceInter;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db.common.iterator.StoreIterator;
import org.tron.core.db2.common.Instance;
import org.tron.core.db2.common.WrappedByteArray;

public class LevelDbDataSourceImpl
extends DbStat
implements DbSourceInter<byte[]>,
Iterable<Map.Entry<byte[], byte[]>>,
Instance<LevelDbDataSourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private String dataBaseName;
    private DB database;
    private volatile boolean alive;
    private String parentPath;
    private Options options;
    private WriteOptions writeOptions;
    private ReadWriteLock resetDbLock = new ReentrantReadWriteLock();
    private static final String LEVELDB = "LEVELDB";
    private static final Logger innerLogger = LoggerFactory.getLogger((String)"LEVELDB");
    private org.iq80.leveldb.Logger leveldbLogger = new org.iq80.leveldb.Logger(){

        public void log(String message) {
            innerLogger.info("{} {}", (Object)LevelDbDataSourceImpl.this.dataBaseName, (Object)message);
        }
    };

    public LevelDbDataSourceImpl(String parentPath, String dataBaseName, Options options, WriteOptions writeOptions) {
        this.parentPath = Paths.get(parentPath, CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
        this.dataBaseName = dataBaseName;
        this.options = options.logger(this.leveldbLogger);
        this.writeOptions = writeOptions;
        this.initDB();
    }

    public LevelDbDataSourceImpl(String parentPath, String dataBaseName) {
        this.parentPath = Paths.get(parentPath, CommonParameter.getInstance().getStorage().getDbDirectory()).toString();
        this.dataBaseName = dataBaseName;
        this.options = new Options().logger(this.leveldbLogger);
        this.writeOptions = new WriteOptions();
    }

    @Override
    public void initDB() {
        this.resetDbLock.writeLock().lock();
        try {
            logger.debug("Init DB: {}.", (Object)this.dataBaseName);
            if (this.isAlive()) {
                return;
            }
            if (this.dataBaseName == null) {
                throw new IllegalArgumentException("No name set to the dbStore");
            }
            try {
                this.openDatabase(this.options);
                this.alive = true;
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.format("Can't initialize database, %s", this.dataBaseName), ioe);
            }
            logger.debug("Init DB {} done.", (Object)this.dataBaseName);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    private void openDatabase(Options dbOptions) throws IOException {
        Path dbPath = this.getDbPath();
        if (dbPath == null || dbPath.getParent() == null) {
            return;
        }
        if (!Files.isSymbolicLink(dbPath.getParent())) {
            Files.createDirectories(dbPath.getParent(), new FileAttribute[0]);
        }
        this.database = JniDBFactory.factory.open(dbPath.toFile(), dbOptions);
        if (!this.getDBName().startsWith("checkpoint")) {
            logger.info("DB {} open success with writeBufferSize {} M, cacheSize {} M, maxOpenFiles {}.", new Object[]{this.getDBName(), dbOptions.writeBufferSize() / 1024 / 1024, dbOptions.cacheSize() / 1024L / 1024L, dbOptions.maxOpenFiles()});
        }
    }

    public Path getDbPath() {
        return Paths.get(this.parentPath, this.dataBaseName);
    }

    @Override
    public void resetDb() {
        this.resetDbLock.writeLock().lock();
        try {
            this.closeDB();
            FileUtil.recursiveDelete((String)this.getDbPath().toString());
            this.initDB();
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public String getDBName() {
        return this.dataBaseName;
    }

    @Override
    public void setDBName(String name) {
        this.dataBaseName = name;
    }

    @Override
    public byte[] getData(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            byte[] byArray = this.database.get(key);
            return byArray;
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public void putData(byte[] key, byte[] value) {
        this.resetDbLock.readLock().lock();
        try {
            this.database.put(key, value, this.writeOptions);
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public void deleteData(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            this.database.delete(key, this.writeOptions);
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public Set<byte[]> allKeys() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public Set<byte[]> allValues() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<byte[]> getlatestValues(long limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Set<byte[]> getValuesNext(byte[] key, long limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> getKeysNext(byte[] key, long limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<byte[], byte[]> getNext(byte[] key, long limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<WrappedByteArray, byte[]> prefixQuery(byte[] key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getTotal() throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateByBatchInner(Map<byte[], byte[]> rows) throws Exception {
        try (WriteBatch batch = this.database.createWriteBatch();){
            this.innerBatchUpdate(rows, batch);
            this.database.write(batch, this.writeOptions);
        }
    }

    private void updateByBatchInner(Map<byte[], byte[]> rows, WriteOptions options) throws Exception {
        try (WriteBatch batch = this.database.createWriteBatch();){
            this.innerBatchUpdate(rows, batch);
            this.database.write(batch, options);
        }
    }

    private void innerBatchUpdate(Map<byte[], byte[]> rows, WriteBatch batch) {
        rows.forEach((? super K key, ? super V value) -> {
            if (value == null) {
                batch.delete(key);
            } else {
                batch.put(key, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByBatch(Map<byte[], byte[]> rows, WriteOptionsWrapper options) {
        this.resetDbLock.readLock().lock();
        try {
            this.updateByBatchInner(rows, options.level);
        }
        catch (Exception e) {
            try {
                this.updateByBatchInner(rows, options.level);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByBatch(Map<byte[], byte[]> rows) {
        this.resetDbLock.readLock().lock();
        try {
            this.updateByBatchInner(rows);
        }
        catch (Exception e) {
            try {
                this.updateByBatchInner(rows);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public boolean flush() {
        return false;
    }

    @Override
    public void closeDB() {
        this.resetDbLock.writeLock().lock();
        try {
            if (!this.isAlive()) {
                return;
            }
            this.database.close();
            this.alive = false;
        }
        catch (IOException e) {
            logger.error("Failed to find the dbStore file on the closeDB: {}.", (Object)this.dataBaseName, (Object)e);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    public DBIterator iterator() {
        return new StoreIterator(this.getDBIterator());
    }

    public Stream<Map.Entry<byte[], byte[]>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public LevelDbDataSourceImpl newInstance() {
        return new LevelDbDataSourceImpl(StorageUtils.getOutputDirectoryByDbName(this.dataBaseName), this.dataBaseName, this.options, this.writeOptions);
    }

    private org.iq80.leveldb.DBIterator getDBIterator() {
        ReadOptions readOptions = new ReadOptions().fillCache(false);
        return this.database.iterator(readOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStats() throws Exception {
        this.resetDbLock.readLock().lock();
        try {
            if (!this.isAlive()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            String stat = this.database.getProperty("leveldb.stats");
            String[] stats = stat.split("\n");
            List<String> list = Arrays.stream(stats).skip(3L).collect(Collectors.toList());
            return list;
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public String getEngine() {
        return LEVELDB;
    }

    @Override
    public String getName() {
        return this.dataBaseName;
    }

    @Override
    public void stat() {
        this.statProperty();
    }

    public LevelDbDataSourceImpl() {
    }
}

