/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.bloom;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Iterator;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.protos.Protocol;

public class Bloom {
    public static final int BLOOM_BIT_SIZE = 2048;
    public static final int BLOOM_BYTE_SIZE = 256;
    private static final int STEPS_8 = 8;
    private static final int ENSURE_BYTE = 255;
    private static final int LOW_3_BITS = Bloom.getLowBits(2048);
    private byte[] data = new byte[256];

    public Bloom() {
    }

    public Bloom(byte[] data) {
        if (data.length != this.data.length) {
            throw new RuntimeException("input data length is not equal to Bloom size " + this.data.length);
        }
        this.data = data;
    }

    public static int getLowBits(int bloomBitSize) {
        return 255 >> 17 - Integer.toBinaryString(bloomBitSize).length();
    }

    public static Bloom create(byte[] toBloom) {
        int mov1 = ((toBloom[0] & 0xFF & LOW_3_BITS) << 8) + (toBloom[1] & 0xFF);
        int mov2 = ((toBloom[2] & 0xFF & LOW_3_BITS) << 8) + (toBloom[3] & 0xFF);
        int mov3 = ((toBloom[4] & 0xFF & LOW_3_BITS) << 8) + (toBloom[5] & 0xFF);
        byte[] data = new byte[256];
        Bloom bloom = new Bloom(data);
        ByteUtil.setBit((byte[])data, (int)mov1, (int)1);
        ByteUtil.setBit((byte[])data, (int)mov2, (int)1);
        ByteUtil.setBit((byte[])data, (int)mov3, (int)1);
        return bloom;
    }

    public static Bloom createBloom(TransactionRetCapsule transactionRetCapsule) {
        if (transactionRetCapsule == null) {
            return null;
        }
        Iterator it = transactionRetCapsule.getInstance().getTransactioninfoList().iterator();
        Bloom blockBloom = null;
        while (it.hasNext()) {
            Protocol.TransactionInfo transactionInfo = (Protocol.TransactionInfo)it.next();
            if (transactionInfo == null || transactionInfo.getLogCount() == 0) continue;
            if (blockBloom == null) {
                blockBloom = new Bloom();
            }
            for (Protocol.TransactionInfo.Log log : transactionInfo.getLogList()) {
                Bloom bloom = Bloom.create(Hash.sha3((byte[])log.getAddress().toByteArray()));
                blockBloom.or(bloom);
                for (ByteString topic : log.getTopicsList()) {
                    bloom = Bloom.create(Hash.sha3((byte[])topic.toByteArray()));
                    blockBloom.or(bloom);
                }
            }
        }
        return blockBloom;
    }

    public void or(Bloom bloom) {
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = (byte)(this.data[n] | bloom.data[i]);
        }
    }

    public boolean matches(Bloom topicBloom) {
        Bloom copy = this.copy();
        copy.or(topicBloom);
        return this.equals(copy);
    }

    public byte[] getData() {
        return this.data;
    }

    public Bloom copy() {
        return new Bloom(Arrays.copyOf(this.getData(), this.getData().length));
    }

    public String toString() {
        return ByteArray.toHexString((byte[])this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bloom bloom = (Bloom)o;
        return Arrays.equals(this.data, bloom.data);
    }

    public int hashCode() {
        return this.data != null ? Arrays.hashCode(this.data) : 0;
    }
}

