/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class ContractStore
extends TronStoreWithRevoking<ContractCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    private ContractStore(@Value(value="contract") String dbName) {
        super(dbName);
    }

    @Override
    public ContractCapsule get(byte[] key) {
        return (ContractCapsule)this.getUnchecked(key);
    }

    @Override
    public void put(byte[] key, ContractCapsule item) {
        if (Objects.isNull(key) || Objects.isNull(item)) {
            return;
        }
        if (item.getInstance().hasAbi()) {
            item = new ContractCapsule(item.getInstance().toBuilder().clearAbi().build());
        }
        this.revokingDB.put(key, item.getData());
    }

    public long getTotalContracts() {
        return Streams.stream(this.revokingDB.iterator()).count();
    }

    public byte[] findContractByHash(byte[] trxHash) {
        return this.revokingDB.getUnchecked(trxHash);
    }
}

