/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.service;

import com.google.common.collect.Streams;
import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.annotation.PreDestroy;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.error.TronDBException;
import org.tron.common.es.ExecutorServiceManager;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.MerkleRoot;
import org.tron.common.utils.Pair;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db2.common.DB;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.RewardViStore;
import org.tron.core.store.WitnessStore;

@Component
public class RewardViCalService {
    private static final Logger logger = LoggerFactory.getLogger((String)"rewardViCalService");
    private final DB<byte[], byte[]> propertiesStore;
    private final DB<byte[], byte[]> delegationStore;
    private final DB<byte[], byte[]> witnessStore;
    @Autowired
    private RewardViStore rewardViStore;
    private static final byte[] IS_DONE_KEY = new byte[]{0};
    private static final byte[] IS_DONE_VALUE = new byte[]{1};
    private long newRewardCalStartCycle = Long.MAX_VALUE;
    private volatile long lastBlockNumber = -1L;
    private static final String MAIN_NET_ROOT_HEX = "9debcb9924055500aaae98cdee10501c5c39d4daa75800a996f4bdda73dbccd8";
    private final Sha256Hash rewardViRoot = CommonParameter.getInstance().getStorage().getDbRoot("reward-vi", Sha256Hash.wrap((ByteString)ByteString.fromHex((String)"9debcb9924055500aaae98cdee10501c5c39d4daa75800a996f4bdda73dbccd8")));
    private final CountDownLatch lock = new CountDownLatch(1);
    private final ScheduledExecutorService es = ExecutorServiceManager.newSingleThreadScheduledExecutor((String)"rewardViCalService");

    @Autowired
    public RewardViCalService(@Autowired DynamicPropertiesStore propertiesStore, @Autowired DelegationStore delegationStore, @Autowired WitnessStore witnessStore) {
        this.propertiesStore = propertiesStore.getDb();
        this.delegationStore = delegationStore.getDb();
        this.witnessStore = witnessStore.getDb();
    }

    public void init() {
        boolean ret;
        this.newRewardCalStartCycle = this.getNewRewardAlgorithmEffectiveCycle();
        boolean bl = ret = this.newRewardCalStartCycle != Long.MAX_VALUE;
        if (ret) {
            this.lastBlockNumber = Long.MAX_VALUE;
        }
        this.es.scheduleWithFixedDelay(this::maybeRun, 0L, 3L, TimeUnit.SECONDS);
    }

    private boolean enableNewRewardAlgorithm() {
        boolean ret;
        this.newRewardCalStartCycle = this.getNewRewardAlgorithmEffectiveCycle();
        boolean bl = ret = this.newRewardCalStartCycle != Long.MAX_VALUE;
        if (ret && this.lastBlockNumber == -1L) {
            this.lastBlockNumber = this.getLatestBlockHeaderNumber();
        }
        return ret;
    }

    private boolean isDone() {
        return this.rewardViStore.has(IS_DONE_KEY);
    }

    private void maybeRun() {
        try {
            if (this.enableNewRewardAlgorithm()) {
                if (this.newRewardCalStartCycle > 1L) {
                    if (this.isDone()) {
                        this.clearUp(true);
                        logger.info("rewardViCalService is already done");
                    } else if (this.lastBlockNumber == Long.MAX_VALUE || this.getLatestBlockHeaderNumber() > this.lastBlockNumber) {
                        this.startRewardCal();
                        this.clearUp(true);
                    } else {
                        logger.info("startRewardCal will run after checkpoint is flushed to db");
                    }
                } else {
                    this.clearUp(false);
                    logger.info("rewardViCalService is no need to run");
                }
            }
        }
        catch (Exception e) {
            logger.error(" Find fatal error, program will be exited soon.", (Throwable)e);
            System.exit(1);
        }
    }

    private void clearUp(boolean isDone) {
        this.lock.countDown();
        if (isDone) {
            this.calcMerkleRoot();
        }
        this.es.shutdown();
    }

    @PreDestroy
    private void destroy() {
        this.es.shutdownNow();
    }

    public long getNewRewardAlgorithmReward(long beginCycle, long endCycle, List<Pair<byte[], Long>> votes) {
        if (!this.isDone()) {
            logger.warn("rewardViCalService is not done, wait for it");
            try {
                this.lock.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TronDBException(e);
            }
        }
        long reward = 0L;
        if (beginCycle < endCycle) {
            for (Pair<byte[], Long> vote : votes) {
                byte[] srAddress = (byte[])vote.getKey();
                BigInteger beginVi = this.getWitnessVi(beginCycle - 1L, srAddress);
                BigInteger endVi = this.getWitnessVi(endCycle - 1L, srAddress);
                BigInteger deltaVi = endVi.subtract(beginVi);
                if (deltaVi.signum() <= 0) continue;
                long userVote = (Long)vote.getValue();
                reward += deltaVi.multiply(BigInteger.valueOf(userVote)).divide(DelegationStore.DECIMAL_OF_VI_REWARD).longValue();
            }
        }
        return reward;
    }

    private void calcMerkleRoot() {
        logger.info("calcMerkleRoot start");
        DBIterator iterator = this.rewardViStore.iterator();
        iterator.seekToFirst();
        ArrayList ids = Streams.stream((Iterator)iterator).map(this::getHash).collect(Collectors.toCollection(ArrayList::new));
        Sha256Hash rewardViRootLocal = MerkleRoot.root((List)ids);
        if (!Objects.equals(this.rewardViRoot, rewardViRootLocal)) {
            logger.warn("Merkle root mismatch, expect: {}, actual: {}. If you are quite sure that there is no miscalculation (not on the main network), please configure 'storage.merkleRoot.reward-vi = {}'(for a specific network such as Nile, etc.) in config.conf to fix the hints", new Object[]{this.rewardViRoot, rewardViRootLocal, rewardViRootLocal});
        }
        logger.info("calcMerkleRoot: {}", (Object)rewardViRootLocal);
    }

    private Sha256Hash getHash(Map.Entry<byte[], byte[]> entry) {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])Bytes.concat((byte[][])new byte[][]{entry.getKey(), entry.getValue()}));
    }

    private void startRewardCal() {
        logger.info("rewardViCalService start");
        this.rewardViStore.reset();
        DBIterator iterator = (DBIterator)this.witnessStore.iterator();
        iterator.seekToFirst();
        iterator.forEachRemaining(e -> this.accumulateWitnessReward((byte[])e.getKey()));
        this.rewardViStore.put(IS_DONE_KEY, IS_DONE_VALUE);
        logger.info("rewardViCalService is done");
    }

    private void accumulateWitnessReward(byte[] witness) {
        long startCycle = 1L;
        LongStream.range(startCycle, this.newRewardCalStartCycle).forEach(cycle -> this.accumulateWitnessVi(cycle, witness));
    }

    private void accumulateWitnessVi(long cycle, byte[] address) {
        BigInteger preVi = this.getWitnessVi(cycle - 1L, address);
        long voteCount = this.getWitnessVote(cycle, address);
        long reward = this.getReward(cycle, address);
        if (reward == 0L || voteCount == 0L) {
            if (!BigInteger.ZERO.equals(preVi)) {
                this.setWitnessVi(cycle, address, preVi);
            }
        } else {
            BigInteger deltaVi = BigInteger.valueOf(reward).multiply(DelegationStore.DECIMAL_OF_VI_REWARD).divide(BigInteger.valueOf(voteCount));
            this.setWitnessVi(cycle, address, preVi.add(deltaVi));
        }
    }

    private void setWitnessVi(long cycle, byte[] address, BigInteger value) {
        byte[] k = this.buildViKey(cycle, address);
        byte[] v = value.toByteArray();
        this.rewardViStore.put(k, v);
    }

    private BigInteger getWitnessVi(long cycle, byte[] address) {
        byte[] v = this.rewardViStore.get(this.buildViKey(cycle, address));
        if (v == null) {
            return BigInteger.ZERO;
        }
        return new BigInteger(v);
    }

    private byte[] buildViKey(long cycle, byte[] address) {
        return this.generateKey(cycle, address, "vi");
    }

    private long getReward(long cycle, byte[] address) {
        byte[] value = this.delegationStore.get(this.generateKey(cycle, address, "reward"));
        return value == null ? 0L : ByteArray.toLong((byte[])value);
    }

    private long getWitnessVote(long cycle, byte[] address) {
        byte[] value = this.delegationStore.get(this.generateKey(cycle, address, "vote"));
        return value == null ? -1L : ByteArray.toLong((byte[])value);
    }

    private byte[] generateKey(long cycle, byte[] address, String suffix) {
        return this.generateKey(cycle + "", address, suffix);
    }

    private byte[] generateKey(String prefix, byte[] address, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(Hex.toHexString((byte[])address));
        if (suffix != null) {
            sb.append("-").append(suffix);
        }
        return sb.toString().getBytes();
    }

    private long getNewRewardAlgorithmEffectiveCycle() {
        byte[] value = this.propertiesStore.get("NEW_REWARD_ALGORITHM_EFFECTIVE_CYCLE".getBytes());
        return value == null ? Long.MAX_VALUE : ByteArray.toLong((byte[])value);
    }

    private long getLatestBlockHeaderNumber() {
        byte[] value = this.propertiesStore.get("latest_block_header_number".getBytes());
        return value == null ? 1L : ByteArray.toLong((byte[])value);
    }
}

