/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.ResourceProcessor;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class BandwidthProcessor
extends ResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private ChainBaseManager chainBaseManager;

    public BandwidthProcessor(ChainBaseManager chainBaseManager) {
        super(chainBaseManager.getDynamicPropertiesStore(), chainBaseManager.getAccountStore());
        this.chainBaseManager = chainBaseManager;
    }

    public void updateUsageForDelegated(AccountCapsule ac) {
        long now = this.chainBaseManager.getHeadSlot();
        long oldNetUsage = ac.getNetUsage();
        long latestConsumeTime = ac.getLatestConsumeTime();
        ac.setNetUsage(this.increase(ac, Common.ResourceCode.BANDWIDTH, oldNetUsage, 0L, latestConsumeTime, now));
    }

    public void updateUsage(AccountCapsule accountCapsule) {
        long now = this.chainBaseManager.getHeadSlot();
        long oldNetUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        accountCapsule.setNetUsage(this.increase(accountCapsule, Common.ResourceCode.BANDWIDTH, oldNetUsage, 0L, latestConsumeTime, now));
        long oldFreeNetUsage = accountCapsule.getFreeNetUsage();
        long latestConsumeFreeTime = accountCapsule.getLatestConsumeFreeTime();
        accountCapsule.setFreeNetUsage(this.increase(oldFreeNetUsage, 0L, latestConsumeFreeTime, now));
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            Map<String, Long> assetMap = accountCapsule.getAssetMap();
            assetMap.forEach((assetName, balance) -> {
                long oldFreeAssetNetUsage = accountCapsule.getFreeAssetNetUsage((String)assetName);
                long latestAssetOperationTime = accountCapsule.getLatestAssetOperationTime((String)assetName);
                accountCapsule.putFreeAssetNetUsage((String)assetName, this.increase(oldFreeAssetNetUsage, 0L, latestAssetOperationTime, now));
            });
        }
        Map<String, Long> assetMapV2 = accountCapsule.getAssetMapV2();
        HashMap<String, Long> map = new HashMap<String, Long>(assetMapV2);
        accountCapsule.getAllFreeAssetNetUsageV2().forEach((k, v) -> {
            if (!map.containsKey(k)) {
                map.put((String)k, 0L);
            }
        });
        map.forEach((assetName, balance) -> {
            long oldFreeAssetNetUsage = accountCapsule.getFreeAssetNetUsageV2((String)assetName);
            long latestAssetOperationTime = accountCapsule.getLatestAssetOperationTimeV2((String)assetName);
            accountCapsule.putFreeAssetNetUsageV2((String)assetName, this.increase(oldFreeAssetNetUsage, 0L, latestAssetOperationTime, now));
        });
    }

    public void updateUsage(AssetIssueCapsule assetIssueCapsule) {
        long now = this.chainBaseManager.getHeadSlot();
        this.updateUsage(assetIssueCapsule, now);
    }

    public void updateUsage(AssetIssueCapsule assetIssueCapsule, long now) {
        long publicFreeAssetNetUsage = assetIssueCapsule.getPublicFreeAssetNetUsage();
        long publicLatestFreeNetTime = assetIssueCapsule.getPublicLatestFreeNetTime();
        assetIssueCapsule.setPublicFreeAssetNetUsage(this.increase(publicFreeAssetNetUsage, 0L, publicLatestFreeNetTime, now));
    }

    @Override
    public void consume(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException, TooBigTransactionException {
        List contracts = trx.getInstance().getRawData().getContractList();
        long resultSizeWithMaxContractRet = trx.getResultSizeWithMaxContractRet();
        if (!trx.isInBlock() && resultSizeWithMaxContractRet > 64L * (long)contracts.size()) {
            throw new TooBigTransactionResultException(String.format("Too big transaction result, TxId %s, the result size is %d bytes, maxResultSize %d", trx.getTransactionId(), resultSizeWithMaxContractRet, 64L));
        }
        if (trx.getResultSerializedSize() > 64L * (long)contracts.size()) {
            throw new TooBigTransactionResultException();
        }
        long bytesSize = this.chainBaseManager.getDynamicPropertiesStore().supportVM() ? (long)trx.getInstance().toBuilder().clearRet().build().getSerializedSize() : trx.getSerializedSize();
        for (Protocol.Transaction.Contract contract : contracts) {
            if (contract.getType() == Protocol.Transaction.Contract.ContractType.ShieldedTransferContract) continue;
            if (this.chainBaseManager.getDynamicPropertiesStore().supportVM()) {
                bytesSize += 64L;
            }
            logger.debug("TxId {}, bandwidth cost: {}.", (Object)trx.getTransactionId(), (Object)bytesSize);
            trace.setNetBill(bytesSize, 0L);
            byte[] address = TransactionCapsule.getOwner(contract);
            AccountCapsule accountCapsule = this.chainBaseManager.getAccountStore().get(address);
            if (accountCapsule == null) {
                throw new ContractValidateException(String.format("account [%s] does not exist", StringUtil.encode58Check((byte[])address)));
            }
            long now = this.chainBaseManager.getHeadSlot();
            if (this.contractCreateNewAccount(contract)) {
                if (!trx.isInBlock()) {
                    long maxCreateAccountTxSize = this.dynamicPropertiesStore.getMaxCreateAccountTxSize();
                    int signatureCount = trx.getInstance().getSignatureCount();
                    long createAccountBytesSize = (long)trx.getInstance().toBuilder().clearRet().build().getSerializedSize() - (long)signatureCount * 65L;
                    if (createAccountBytesSize > maxCreateAccountTxSize) {
                        throw new TooBigTransactionException(String.format("Too big new account transaction, TxId %s, the size is %d bytes, maxTxSize %d", trx.getTransactionId(), createAccountBytesSize, maxCreateAccountTxSize));
                    }
                }
                this.consumeForCreateNewAccount(accountCapsule, bytesSize, now, trace);
                continue;
            }
            if (contract.getType() == Protocol.Transaction.Contract.ContractType.TransferAssetContract && this.useAssetAccountNet(contract, accountCapsule, now, bytesSize) || this.useAccountNet(accountCapsule, bytesSize, now) || this.useFreeNet(accountCapsule, bytesSize, now) || this.useTransactionFee(accountCapsule, bytesSize, trace)) continue;
            long fee = this.chainBaseManager.getDynamicPropertiesStore().getTransactionFee() * bytesSize;
            throw new AccountResourceInsufficientException(String.format("account [%s] has insufficient bandwidth[%d] and balance[%d] to create new account", StringUtil.encode58Check((byte[])address), bytesSize, fee));
        }
    }

    private boolean useTransactionFee(AccountCapsule accountCapsule, long bytes, TransactionTrace trace) {
        long fee = this.chainBaseManager.getDynamicPropertiesStore().getTransactionFee() * bytes;
        if (this.consumeFeeForBandwidth(accountCapsule, fee)) {
            trace.setNetBill(0L, fee);
            this.chainBaseManager.getDynamicPropertiesStore().addTotalTransactionCost(fee);
            return true;
        }
        return false;
    }

    private void consumeForCreateNewAccount(AccountCapsule accountCapsule, long bytes, long now, TransactionTrace trace) throws AccountResourceInsufficientException {
        boolean ret = this.consumeBandwidthForCreateNewAccount(accountCapsule, bytes, now, trace);
        if (!ret && !(ret = this.consumeFeeForCreateNewAccount(accountCapsule, trace))) {
            throw new AccountResourceInsufficientException(String.format("account [%s] has insufficient bandwidth[%d] and balance[%d] to create new account", StringUtil.encode58Check((byte[])accountCapsule.createDbKey()), bytes, this.chainBaseManager.getDynamicPropertiesStore().getCreateAccountFee()));
        }
    }

    public boolean consumeBandwidthForCreateNewAccount(AccountCapsule accountCapsule, long bytes, long now, TransactionTrace trace) {
        long newNetUsage;
        long createNewAccountBandwidthRatio = this.chainBaseManager.getDynamicPropertiesStore().getCreateNewAccountBandwidthRate();
        long netUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        long netCost = bytes * createNewAccountBandwidthRatio;
        long netLimit = this.calculateGlobalNetLimit(accountCapsule);
        if (netCost <= netLimit - (newNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(netUsage, 0L, latestConsumeTime, now) : this.recovery(accountCapsule, Common.ResourceCode.BANDWIDTH, netUsage, latestConsumeTime, now))) {
            long latestOperationTime = this.chainBaseManager.getHeadBlockTimeStamp();
            newNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(newNetUsage, netCost, now, now) : this.increase(accountCapsule, Common.ResourceCode.BANDWIDTH, netUsage, netCost, latestConsumeTime, now);
            accountCapsule.setLatestConsumeTime(now);
            accountCapsule.setLatestOperationTime(latestOperationTime);
            accountCapsule.setNetUsage(newNetUsage);
            trace.setNetBillForCreateNewAccount(netCost, 0L);
            this.chainBaseManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            return true;
        }
        return false;
    }

    public boolean consumeFeeForCreateNewAccount(AccountCapsule accountCapsule, TransactionTrace trace) {
        long fee = this.chainBaseManager.getDynamicPropertiesStore().getCreateAccountFee();
        if (this.consumeFeeForNewAccount(accountCapsule, fee)) {
            trace.setNetBillForCreateNewAccount(0L, fee);
            this.chainBaseManager.getDynamicPropertiesStore().addTotalCreateAccountCost(fee);
            return true;
        }
        return false;
    }

    public boolean contractCreateNewAccount(Protocol.Transaction.Contract contract) {
        switch (contract.getType()) {
            case AccountCreateContract: {
                return true;
            }
            case TransferContract: {
                BalanceContract.TransferContract transferContract;
                try {
                    transferContract = (BalanceContract.TransferContract)contract.getParameter().unpack(BalanceContract.TransferContract.class);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                AccountCapsule toAccount = this.chainBaseManager.getAccountStore().get(transferContract.getToAddress().toByteArray());
                return toAccount == null;
            }
            case TransferAssetContract: {
                AssetIssueContractOuterClass.TransferAssetContract transferAssetContract;
                try {
                    transferAssetContract = (AssetIssueContractOuterClass.TransferAssetContract)contract.getParameter().unpack(AssetIssueContractOuterClass.TransferAssetContract.class);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                AccountCapsule toAccount = this.chainBaseManager.getAccountStore().get(transferAssetContract.getToAddress().toByteArray());
                return toAccount == null;
            }
        }
        return false;
    }

    private boolean useAssetAccountNet(Protocol.Transaction.Contract contract, AccountCapsule accountCapsule, long now, long bytes) throws ContractValidateException {
        long newIssuerNetUsage;
        long latestAssetOperationTime;
        long freeAssetNetUsage;
        long publicLatestFreeNetTime;
        long publicFreeAssetNetUsage;
        long newPublicFreeAssetNetUsage;
        ByteString assetName;
        try {
            assetName = ((AssetIssueContractOuterClass.TransferAssetContract)contract.getParameter().unpack(AssetIssueContractOuterClass.TransferAssetContract.class)).getAssetName();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        AssetIssueCapsule assetIssueCapsule = Commons.getAssetIssueStoreFinal(this.chainBaseManager.getDynamicPropertiesStore(), this.chainBaseManager.getAssetIssueStore(), this.chainBaseManager.getAssetIssueV2Store()).get(assetName.toByteArray());
        if (assetIssueCapsule == null) {
            throw new ContractValidateException(String.format("asset [%s] does not exist", assetName));
        }
        String tokenName = ByteArray.toStr((byte[])assetName.toByteArray());
        String tokenID = assetIssueCapsule.getId();
        if (assetIssueCapsule.getOwnerAddress() == accountCapsule.getAddress()) {
            return this.useAccountNet(accountCapsule, bytes, now);
        }
        long publicFreeAssetNetLimit = assetIssueCapsule.getPublicFreeAssetNetLimit();
        if (bytes > publicFreeAssetNetLimit - (newPublicFreeAssetNetUsage = this.increase(publicFreeAssetNetUsage = assetIssueCapsule.getPublicFreeAssetNetUsage(), 0L, publicLatestFreeNetTime = assetIssueCapsule.getPublicLatestFreeNetTime(), now))) {
            logger.debug("The {} public free bandwidth is not enough. Bytes: {}, publicFreeAssetNetLimit: {}, newPublicFreeAssetNetUsage: {}.", new Object[]{tokenID, bytes, publicFreeAssetNetLimit, newPublicFreeAssetNetUsage});
            return false;
        }
        long freeAssetNetLimit = assetIssueCapsule.getFreeAssetNetLimit();
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            freeAssetNetUsage = accountCapsule.getFreeAssetNetUsage(tokenName);
            latestAssetOperationTime = accountCapsule.getLatestAssetOperationTime(tokenName);
        } else {
            freeAssetNetUsage = accountCapsule.getFreeAssetNetUsageV2(tokenID);
            latestAssetOperationTime = accountCapsule.getLatestAssetOperationTimeV2(tokenID);
        }
        long newFreeAssetNetUsage = this.increase(freeAssetNetUsage, 0L, latestAssetOperationTime, now);
        if (bytes > freeAssetNetLimit - newFreeAssetNetUsage) {
            logger.debug("The {} free bandwidth is not enough. Bytes: {}, freeAssetNetLimit: {}, newFreeAssetNetUsage:{}.", new Object[]{tokenID, bytes, freeAssetNetLimit, newFreeAssetNetUsage});
            return false;
        }
        AccountCapsule issuerAccountCapsule = this.chainBaseManager.getAccountStore().get(assetIssueCapsule.getOwnerAddress().toByteArray());
        long issuerNetUsage = issuerAccountCapsule.getNetUsage();
        long latestConsumeTime = issuerAccountCapsule.getLatestConsumeTime();
        long issuerNetLimit = this.calculateGlobalNetLimit(issuerAccountCapsule);
        if (bytes > issuerNetLimit - (newIssuerNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(issuerNetUsage, 0L, latestConsumeTime, now) : this.recovery(issuerAccountCapsule, Common.ResourceCode.BANDWIDTH, issuerNetUsage, latestConsumeTime, now))) {
            logger.debug("The {} issuer's bandwidth is not enough. Bytes: {}, issuerNetLimit: {}, newIssuerNetUsage:{}.", new Object[]{tokenID, bytes, issuerNetLimit, newIssuerNetUsage});
            return false;
        }
        latestAssetOperationTime = now;
        publicLatestFreeNetTime = now;
        long latestOperationTime = this.chainBaseManager.getHeadBlockTimeStamp();
        newIssuerNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(newIssuerNetUsage, bytes, now, now) : this.increase(issuerAccountCapsule, Common.ResourceCode.BANDWIDTH, issuerNetUsage, bytes, latestConsumeTime, now);
        newFreeAssetNetUsage = this.increase(newFreeAssetNetUsage, bytes, latestAssetOperationTime, now);
        newPublicFreeAssetNetUsage = this.increase(newPublicFreeAssetNetUsage, bytes, publicLatestFreeNetTime, now);
        issuerAccountCapsule.setNetUsage(newIssuerNetUsage);
        issuerAccountCapsule.setLatestConsumeTime(now);
        assetIssueCapsule.setPublicFreeAssetNetUsage(newPublicFreeAssetNetUsage);
        assetIssueCapsule.setPublicLatestFreeNetTime(publicLatestFreeNetTime);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        if (this.chainBaseManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            accountCapsule.putLatestAssetOperationTimeMap(tokenName, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsage(tokenName, newFreeAssetNetUsage);
            accountCapsule.putLatestAssetOperationTimeMapV2(tokenID, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsageV2(tokenID, newFreeAssetNetUsage);
            this.chainBaseManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), assetIssueCapsule);
            AssetIssueCapsule assetIssueCapsuleV2 = this.chainBaseManager.getAssetIssueV2Store().get(assetIssueCapsule.createDbV2Key());
            assetIssueCapsuleV2.setPublicFreeAssetNetUsage(newPublicFreeAssetNetUsage);
            assetIssueCapsuleV2.setPublicLatestFreeNetTime(publicLatestFreeNetTime);
            this.chainBaseManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
        } else {
            accountCapsule.putLatestAssetOperationTimeMapV2(tokenID, latestAssetOperationTime);
            accountCapsule.putFreeAssetNetUsageV2(tokenID, newFreeAssetNetUsage);
            this.chainBaseManager.getAssetIssueV2Store().put(assetIssueCapsule.createDbV2Key(), assetIssueCapsule);
        }
        this.chainBaseManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        this.chainBaseManager.getAccountStore().put(issuerAccountCapsule.createDbKey(), issuerAccountCapsule);
        return true;
    }

    public long calculateGlobalNetLimit(AccountCapsule accountCapsule) {
        long frozeBalance = accountCapsule.getAllFrozenBalanceForBandwidth();
        if (this.dynamicPropertiesStore.supportUnfreezeDelay()) {
            return this.calculateGlobalNetLimitV2(frozeBalance);
        }
        if (frozeBalance < 1000000L) {
            return 0L;
        }
        long netWeight = frozeBalance / 1000000L;
        long totalNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.chainBaseManager.getDynamicPropertiesStore().getTotalNetWeight();
        if (this.dynamicPropertiesStore.allowNewReward() && totalNetWeight <= 0L) {
            return 0L;
        }
        if (totalNetWeight == 0L) {
            return 0L;
        }
        return (long)((double)netWeight * ((double)totalNetLimit / (double)totalNetWeight));
    }

    public long calculateGlobalNetLimitV2(long frozeBalance) {
        double netWeight = (double)frozeBalance / 1000000.0;
        long totalNetLimit = this.dynamicPropertiesStore.getTotalNetLimit();
        long totalNetWeight = this.dynamicPropertiesStore.getTotalNetWeight();
        if (totalNetWeight == 0L) {
            return 0L;
        }
        return (long)(netWeight * ((double)totalNetLimit / (double)totalNetWeight));
    }

    private boolean useAccountNet(AccountCapsule accountCapsule, long bytes, long now) {
        long newNetUsage;
        long netUsage = accountCapsule.getNetUsage();
        long latestConsumeTime = accountCapsule.getLatestConsumeTime();
        long netLimit = this.calculateGlobalNetLimit(accountCapsule);
        if (bytes > netLimit - (newNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(netUsage, 0L, latestConsumeTime, now) : this.recovery(accountCapsule, Common.ResourceCode.BANDWIDTH, netUsage, latestConsumeTime, now))) {
            logger.debug("Net usage is running out, now use free net usage. Bytes: {}, netLimit: {}, newNetUsage: {}.", new Object[]{bytes, netLimit, newNetUsage});
            return false;
        }
        long latestOperationTime = this.chainBaseManager.getHeadBlockTimeStamp();
        newNetUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(newNetUsage, bytes, now, now) : this.increase(accountCapsule, Common.ResourceCode.BANDWIDTH, netUsage, bytes, latestConsumeTime, now);
        accountCapsule.setNetUsage(newNetUsage);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        accountCapsule.setLatestConsumeTime(now);
        this.chainBaseManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        return true;
    }

    private boolean useFreeNet(AccountCapsule accountCapsule, long bytes, long now) {
        long publicNetTime;
        long publicNetUsage;
        long newPublicNetUsage;
        long latestConsumeFreeTime;
        long freeNetUsage;
        long newFreeNetUsage;
        long freeNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getFreeNetLimit();
        if (bytes > freeNetLimit - (newFreeNetUsage = this.increase(freeNetUsage = accountCapsule.getFreeNetUsage(), 0L, latestConsumeFreeTime = accountCapsule.getLatestConsumeFreeTime(), now))) {
            logger.debug("Free net usage is running out. Bytes: {}, freeNetLimit: {}, newFreeNetUsage: {}.", new Object[]{bytes, freeNetLimit, newFreeNetUsage});
            return false;
        }
        long publicNetLimit = this.chainBaseManager.getDynamicPropertiesStore().getPublicNetLimit();
        if (bytes > publicNetLimit - (newPublicNetUsage = this.increase(publicNetUsage = this.chainBaseManager.getDynamicPropertiesStore().getPublicNetUsage(), 0L, publicNetTime = this.chainBaseManager.getDynamicPropertiesStore().getPublicNetTime(), now))) {
            logger.debug("Free public net usage is running out. Bytes: {}, publicNetLimit: {}, newPublicNetUsage: {}.", new Object[]{bytes, publicNetLimit, newPublicNetUsage});
            return false;
        }
        latestConsumeFreeTime = now;
        long latestOperationTime = this.chainBaseManager.getHeadBlockTimeStamp();
        publicNetTime = now;
        newFreeNetUsage = this.increase(newFreeNetUsage, bytes, latestConsumeFreeTime, now);
        newPublicNetUsage = this.increase(newPublicNetUsage, bytes, publicNetTime, now);
        accountCapsule.setFreeNetUsage(newFreeNetUsage);
        accountCapsule.setLatestConsumeFreeTime(latestConsumeFreeTime);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        this.chainBaseManager.getDynamicPropertiesStore().savePublicNetUsage(newPublicNetUsage);
        this.chainBaseManager.getDynamicPropertiesStore().savePublicNetTime(publicNetTime);
        this.chainBaseManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        return true;
    }
}

