/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.bloom.Bloom;
import org.tron.common.crypto.SignInterface;
import org.tron.common.crypto.SignUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Time;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionRetCapsule;
import org.tron.core.capsule.utils.MerkleTree;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;

public class BlockCapsule
implements ProtoCapsule<Protocol.Block> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    public boolean generatedByMyself = false;
    private TransactionRetCapsule result;
    private BlockId blockId = new BlockId(Sha256Hash.ZERO_HASH, 0L);
    private Protocol.Block block;
    private List<TransactionCapsule> transactions = new ArrayList<TransactionCapsule>();
    private boolean isSwitch;
    private Bloom bloom;

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public BlockCapsule setSwitch(boolean aSwitch) {
        this.isSwitch = aSwitch;
        return this;
    }

    public BlockCapsule(long number, Sha256Hash hash, long when, ByteString witnessAddress) {
        Protocol.BlockHeader.raw.Builder blockHeaderRawBuild = Protocol.BlockHeader.raw.newBuilder();
        Protocol.BlockHeader.raw blockHeaderRaw = blockHeaderRawBuild.setNumber(number).setParentHash(hash.getByteString()).setTimestamp(when).setVersion(31).setWitnessAddress(witnessAddress).build();
        Protocol.BlockHeader.Builder blockHeaderBuild = Protocol.BlockHeader.newBuilder();
        Protocol.BlockHeader blockHeader = blockHeaderBuild.setRawData(blockHeaderRaw).build();
        Protocol.Block.Builder blockBuild = Protocol.Block.newBuilder();
        this.block = blockBuild.setBlockHeader(blockHeader).build();
        this.initTxs();
    }

    public BlockCapsule(long timestamp, ByteString parentHash, long number, List<Protocol.Transaction> transactionList) {
        Protocol.BlockHeader.raw.Builder blockHeaderRawBuild = Protocol.BlockHeader.raw.newBuilder();
        Protocol.BlockHeader.raw blockHeaderRaw = blockHeaderRawBuild.setTimestamp(timestamp).setParentHash(parentHash).setNumber(number).build();
        Protocol.BlockHeader.Builder blockHeaderBuild = Protocol.BlockHeader.newBuilder();
        Protocol.BlockHeader blockHeader = blockHeaderBuild.setRawData(blockHeaderRaw).build();
        Protocol.Block.Builder blockBuild = Protocol.Block.newBuilder();
        transactionList.forEach(trx -> blockBuild.addTransactions(trx));
        this.block = blockBuild.setBlockHeader(blockHeader).build();
        this.initTxs();
    }

    public BlockCapsule(Protocol.Block block) {
        this.block = block;
        this.initTxs();
    }

    public BlockCapsule(byte[] data) throws BadItemException {
        try {
            this.block = Protocol.Block.parseFrom((byte[])data);
            this.initTxs();
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("Block proto data parse exception");
        }
    }

    public BlockCapsule(CodedInputStream codedInputStream) throws BadItemException {
        try {
            this.block = Protocol.Block.parseFrom((CodedInputStream)codedInputStream);
            this.initTxs();
        }
        catch (Exception e) {
            logger.error("constructor block error : {}", (Object)e.getMessage());
            throw new BadItemException("Block proto data parse exception");
        }
    }

    public void addTransaction(TransactionCapsule pendingTrx) {
        this.block = this.block.toBuilder().addTransactions(pendingTrx.getInstance()).build();
        this.getTransactions().add(pendingTrx);
    }

    public void addAllTransactions(List<TransactionCapsule> pendingTrxs) {
        List list = pendingTrxs.stream().map(TransactionCapsule::getInstance).collect(Collectors.toList());
        this.block = this.block.toBuilder().addAllTransactions(list).build();
        this.getTransactions().addAll(pendingTrxs);
    }

    public List<TransactionCapsule> getTransactions() {
        return this.transactions;
    }

    private void initTxs() {
        this.transactions = this.block.getTransactionsList().stream().map(trx -> new TransactionCapsule((Protocol.Transaction)trx)).collect(Collectors.toList());
    }

    public void sign(byte[] privateKey) {
        SignInterface ecKeyEngine = SignUtils.fromPrivate((byte[])privateKey, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
        ByteString sig = ByteString.copyFrom((byte[])ecKeyEngine.Base64toBytes(ecKeyEngine.signHash(this.getRawHash().getBytes())));
        Protocol.BlockHeader blockHeader = this.block.getBlockHeader().toBuilder().setWitnessSignature(sig).build();
        this.block = this.block.toBuilder().setBlockHeader(blockHeader).build();
    }

    private Sha256Hash getRawHash() {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])this.block.getBlockHeader().getRawData().toByteArray());
    }

    public boolean validateSignature(DynamicPropertiesStore dynamicPropertiesStore, AccountStore accountStore) throws ValidateSignatureException {
        try {
            byte[] sigAddress = SignUtils.signatureToAddress((byte[])this.getRawHash().getBytes(), (String)TransactionCapsule.getBase64FromByteString(this.block.getBlockHeader().getWitnessSignature()), (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
            byte[] witnessAccountAddress = this.block.getBlockHeader().getRawData().getWitnessAddress().toByteArray();
            if (dynamicPropertiesStore.getAllowMultiSign() != 1L) {
                return Arrays.equals(sigAddress, witnessAccountAddress);
            }
            byte[] witnessPermissionAddress = accountStore.get(witnessAccountAddress).getWitnessPermissionAddress();
            return Arrays.equals(sigAddress, witnessPermissionAddress);
        }
        catch (SignatureException e) {
            throw new ValidateSignatureException(e.getMessage());
        }
    }

    public BlockId getBlockId() {
        if (this.blockId.equals(Sha256Hash.ZERO_HASH)) {
            this.blockId = new BlockId(Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])this.block.getBlockHeader().getRawData().toByteArray()), this.getNum());
        }
        return this.blockId;
    }

    public Sha256Hash calcMerkleRoot() {
        List transactionsList = this.block.getTransactionsList();
        if (CollectionUtils.isEmpty((Collection)transactionsList)) {
            return Sha256Hash.ZERO_HASH;
        }
        ArrayList ids = transactionsList.stream().map(TransactionCapsule::new).map(TransactionCapsule::getMerkleHash).collect(Collectors.toCollection(ArrayList::new));
        return MerkleTree.getInstance().createTree(ids).getRoot().getHash();
    }

    public void setMerkleRoot() {
        Protocol.BlockHeader.raw blockHeaderRaw = this.block.getBlockHeader().getRawData().toBuilder().setTxTrieRoot(this.calcMerkleRoot().getByteString()).build();
        this.block = this.block.toBuilder().setBlockHeader(this.block.getBlockHeader().toBuilder().setRawData(blockHeaderRaw)).build();
    }

    public void setAccountStateRoot(byte[] root) {
        Protocol.BlockHeader.raw blockHeaderRaw = this.block.getBlockHeader().getRawData().toBuilder().setAccountStateRoot(ByteString.copyFrom((byte[])root)).build();
        this.block = this.block.toBuilder().setBlockHeader(this.block.getBlockHeader().toBuilder().setRawData(blockHeaderRaw)).build();
    }

    public void setWitness(String witness) {
        Protocol.BlockHeader.raw blockHeaderRaw = this.block.getBlockHeader().getRawData().toBuilder().setWitnessAddress(ByteString.copyFrom((byte[])witness.getBytes())).build();
        this.block = this.block.toBuilder().setBlockHeader(this.block.getBlockHeader().toBuilder().setRawData(blockHeaderRaw)).build();
    }

    public Sha256Hash getMerkleRoot() {
        return Sha256Hash.wrap((ByteString)this.block.getBlockHeader().getRawData().getTxTrieRoot());
    }

    public Sha256Hash getAccountRoot() {
        if (this.block.getBlockHeader().getRawData().getAccountStateRoot() != null && !this.block.getBlockHeader().getRawData().getAccountStateRoot().isEmpty()) {
            return Sha256Hash.wrap((ByteString)this.block.getBlockHeader().getRawData().getAccountStateRoot());
        }
        return Sha256Hash.ZERO_HASH;
    }

    public ByteString getWitnessAddress() {
        return this.block.getBlockHeader().getRawData().getWitnessAddress();
    }

    public boolean isMerkleRootEmpty() {
        return this.block.getBlockHeader().getRawData().getTxTrieRoot().toByteArray().length == 0;
    }

    @Override
    public byte[] getData() {
        return this.block.toByteArray();
    }

    @Override
    public Protocol.Block getInstance() {
        return this.block;
    }

    public long getSerializedSize() {
        return this.block.getSerializedSize();
    }

    public Sha256Hash getParentHash() {
        return Sha256Hash.wrap((ByteString)this.block.getBlockHeader().getRawData().getParentHash());
    }

    public BlockId getParentBlockId() {
        return new BlockId(this.getParentHash(), this.getNum() - 1L);
    }

    public ByteString getParentHashStr() {
        return this.block.getBlockHeader().getRawData().getParentHash();
    }

    public long getNum() {
        return this.block.getBlockHeader().getRawData().getNumber();
    }

    public long getTimeStamp() {
        return this.block.getBlockHeader().getRawData().getTimestamp();
    }

    public boolean hasWitnessSignature() {
        return !this.getInstance().getBlockHeader().getWitnessSignature().isEmpty();
    }

    public String toString() {
        StringBuilder toStringBuff = new StringBuilder();
        toStringBuff.append("BlockCapsule \n[ ");
        toStringBuff.append("hash=").append((Object)this.getBlockId()).append("\n");
        toStringBuff.append("number=").append(this.getNum()).append("\n");
        toStringBuff.append("parentId=").append(this.getParentHash()).append("\n");
        toStringBuff.append("witness address=").append(ByteArray.toHexString((byte[])this.getWitnessAddress().toByteArray())).append("\n");
        toStringBuff.append("generated by myself=").append(this.generatedByMyself).append("\n");
        toStringBuff.append("generate time=").append(Time.getTimeString((long)this.getTimeStamp())).append("\n");
        toStringBuff.append("account root=").append(this.getAccountRoot()).append("\n");
        if (!this.getTransactions().isEmpty()) {
            toStringBuff.append("merkle root=").append(this.getMerkleRoot()).append("\n");
            toStringBuff.append("txs size=").append(this.getTransactions().size()).append("\n");
        } else {
            toStringBuff.append("txs are empty\n");
        }
        toStringBuff.append("]");
        return toStringBuff.toString();
    }

    public TransactionRetCapsule getResult() {
        return this.result;
    }

    public void setResult(TransactionRetCapsule result) {
        this.result = result;
    }

    public Bloom getBloom() {
        return this.bloom;
    }

    public void setBloom(Bloom bloom) {
        this.bloom = bloom;
    }

    public static class BlockId
    extends Sha256Hash {
        private long num;

        public BlockId() {
            super(Sha256Hash.ZERO_HASH.getBytes());
            this.num = 0L;
        }

        public BlockId(Sha256Hash blockId) {
            super(blockId.getBytes());
            byte[] blockNum = new byte[8];
            System.arraycopy(blockId.getBytes(), 0, blockNum, 0, 8);
            this.num = Longs.fromByteArray((byte[])blockNum);
        }

        public BlockId(Sha256Hash hash, long num) {
            super(num, hash);
            this.num = num;
        }

        public BlockId(byte[] hash, long num) {
            super(num, hash);
            this.num = num;
        }

        public BlockId(ByteString hash, long num) {
            super(num, hash.toByteArray());
            this.num = num;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass() && !(o instanceof Sha256Hash)) {
                return false;
            }
            return Arrays.equals(this.getBytes(), ((Sha256Hash)o).getBytes());
        }

        public String getString() {
            return "Num:" + this.num + ",ID:" + super.toString();
        }

        public String toString() {
            return super.toString();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public int compareTo(Sha256Hash other) {
            if (other.getClass().equals(BlockId.class)) {
                long otherNum = ((BlockId)other).getNum();
                return Long.compare(this.num, otherNum);
            }
            return super.compareTo(other);
        }

        public long getNum() {
            return this.num;
        }
    }
}

