/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.vm.config.VMConfig;

public class ProgramPrecompile {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private final Set<Integer> jumpDest = new HashSet<Integer>();

    public static ProgramPrecompile compile(byte[] ops) {
        ProgramPrecompile ret = new ProgramPrecompile();
        for (int i = 0; i < ops.length; ++i) {
            int op = ops[i] & 0xFF;
            if (op == 91) {
                ret.jumpDest.add(i);
            }
            if (op < 96 || op > 127) continue;
            i += op - 96 + 1;
        }
        return ret;
    }

    public static byte[] getCode(byte[] ops) {
        for (int i = 0; i < ops.length; ++i) {
            int op = ops[i] & 0xFF;
            if (op == 243 && i + 1 < ops.length && (ops[i + 1] & 0xFF) == 0) {
                byte[] ret = new byte[ops.length - ++i - 1];
                System.arraycopy(ops, i + 1, ret, 0, ops.length - i - 1);
                return ret;
            }
            if (op < 96 || op > 127) continue;
            i += op - 96 + 1;
        }
        if (VMConfig.allowTvmConstantinople()) {
            return new byte[0];
        }
        return new byte[32];
    }

    public boolean hasJumpDest(int pc) {
        return this.jumpDest.contains(pc);
    }
}

