/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract.param;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.tron.common.utils.StringUtil;
import org.tron.protos.Protocol;

public class VoteWitnessParam {
    private byte[] voterAddress;
    private final List<Protocol.Vote> votes = new ArrayList<Protocol.Vote>();

    public byte[] getVoterAddress() {
        return this.voterAddress;
    }

    public void setVoterAddress(byte[] voterAddress) {
        this.voterAddress = voterAddress;
    }

    public List<Protocol.Vote> getVotes() {
        return this.votes;
    }

    public void addVote(byte[] witnessAddress, long tronPower) {
        this.votes.add(Protocol.Vote.newBuilder().setVoteAddress(ByteString.copyFrom((byte[])witnessAddress)).setVoteCount(tronPower).build());
    }

    public String toJsonStr() {
        StringBuilder sb = new StringBuilder("{\"votes\":[");
        String template = "{\"vote_address\":\"%s\",\"vote_count\":%d}";
        for (Protocol.Vote vote : this.votes) {
            sb.append(String.format(template, StringUtil.encode58Check((byte[])vote.getVoteAddress().toByteArray()), vote.getVoteCount())).append(",");
        }
        if (!this.votes.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }
}

