/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.repository.Repository;

public final class VMUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private static final int BUF_SIZE = 4096;

    private VMUtils() {
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File createProgramTraceFile(String txHash) {
        File result = null;
        if (VMConfig.vmTrace()) {
            File file = new File(new File("./", "vm_trace"), txHash + ".json");
            if (file.exists()) {
                if (file.isFile() && file.canWrite()) {
                    result = file;
                }
            } else {
                try {
                    file.getParentFile().mkdirs();
                    if (!file.createNewFile()) {
                        logger.error("failed to create file {}", (Object)file.getPath());
                    }
                    result = file;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(File file, String data) {
        FileOutputStream out;
        block4: {
            out = null;
            try {
                out = new FileOutputStream(file);
                if (data == null) break block4;
                ((OutputStream)out).write(data.getBytes("UTF-8"));
            }
            catch (Exception e) {
                try {
                    logger.error(String.format("Cannot write to file '%s': ", file.getAbsolutePath()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    VMUtils.closeQuietly(out);
                    throw throwable;
                }
                VMUtils.closeQuietly(out);
            }
        }
        VMUtils.closeQuietly(out);
    }

    public static void saveProgramTraceFile(String txHash, String content) {
        File file = VMUtils.createProgramTraceFile(txHash);
        if (file != null) {
            VMUtils.writeStringToFile(file, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            byte[] buf = new byte[bufSize];
            int count = in.read(buf);
            while (count != -1) {
                out.write(buf, 0, count);
                count = in.read(buf);
            }
        }
        finally {
            VMUtils.closeQuietly(in);
            VMUtils.closeQuietly(out);
        }
    }

    public static byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)baos, new Deflater(), 4096);
        VMUtils.write(in, out, 4096);
        return baos.toByteArray();
    }

    public static byte[] compress(String content) throws IOException {
        return VMUtils.compress(content.getBytes("UTF-8"));
    }

    public static String zipAndEncode(String content) {
        try {
            return Base64.encodeBase64String((byte[])VMUtils.compress(content));
        }
        catch (Exception e) {
            logger.error("Cannot zip or encode: ", (Throwable)e);
            return content;
        }
    }

    public static boolean validateForSmartContract(Repository deposit, byte[] ownerAddress, byte[] toAddress, long amount) throws ContractValidateException {
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress!");
        }
        if (!DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid toAddress!");
        }
        if (Arrays.equals(toAddress, ownerAddress)) {
            throw new ContractValidateException("Cannot transfer TRX to yourself.");
        }
        AccountCapsule ownerAccount = deposit.getAccount(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Validate InternalTransfer error, no OwnerAccount.");
        }
        AccountCapsule toAccount = deposit.getAccount(toAddress);
        if (toAccount == null) {
            throw new ContractValidateException("Validate InternalTransfer error, no ToAccount. And not allowed to create an account in a smartContract.");
        }
        long balance = ownerAccount.getBalance();
        if (amount < 0L) {
            throw new ContractValidateException("Amount must be greater than or equals 0.");
        }
        try {
            if (balance < amount) {
                throw new ContractValidateException("Validate InternalTransfer error, balance is not sufficient.");
            }
            Math.addExact(toAccount.getBalance(), amount);
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public static boolean validateForSmartContract(Repository deposit, byte[] ownerAddress, byte[] toAddress, byte[] tokenId, long amount) throws ContractValidateException {
        if (deposit == null) {
            throw new ContractValidateException("No deposit!");
        }
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes((byte[])tokenId);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0.");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot transfer asset to yourself.");
        }
        AccountCapsule ownerAccount = deposit.getAccount(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("No owner account!");
        }
        if (deposit.getAssetIssue(tokenIdWithoutLeadingZero) == null) {
            throw new ContractValidateException("No asset !");
        }
        if (!Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)deposit.getDynamicPropertiesStore(), (AssetIssueStore)deposit.getAssetIssueStore(), (AssetIssueV2Store)deposit.getAssetIssueV2Store()).has(tokenIdWithoutLeadingZero)) {
            throw new ContractValidateException("No asset !");
        }
        Long assetBalance = ownerAccount.getAsset(deposit.getDynamicPropertiesStore(), ByteArray.toStr((byte[])tokenIdWithoutLeadingZero));
        if (null == assetBalance || assetBalance <= 0L) {
            throw new ContractValidateException("assetBalance must greater than 0.");
        }
        if (amount > assetBalance) {
            throw new ContractValidateException("assetBalance is not sufficient.");
        }
        AccountCapsule toAccount = deposit.getAccount(toAddress);
        if (toAccount != null) {
            assetBalance = toAccount.getAsset(deposit.getDynamicPropertiesStore(), ByteArray.toStr((byte[])tokenIdWithoutLeadingZero));
            if (assetBalance != null) {
                try {
                    assetBalance = Math.addExact(assetBalance, amount);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
            }
        } else {
            throw new ContractValidateException("Validate InternalTransfer error, no ToAccount. And not allowed to create account in smart contract.");
        }
        return true;
    }
}

