/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.utils;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Longs;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.PermissionException;
import org.tron.core.exception.SignatureFormatException;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.SmartContractOuterClass;

@Component
public class TransactionUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private static final int MAX_ACCOUNT_NAME_LEN = 200;
    private static final int MAX_ACCOUNT_ID_LEN = 32;
    private static final int MIN_ACCOUNT_ID_LEN = 8;
    private static final int MAX_ASSET_NAME_LEN = 32;
    private static final int MAX_TOKEN_ABBR_NAME_LEN = 5;
    private static final int MAX_ASSET_DESCRIPTION_LEN = 200;
    private static final int MAX_URL_LEN = 256;
    @Autowired
    private ChainBaseManager chainBaseManager;

    public static boolean validAccountName(byte[] accountName) {
        return TransactionUtil.validBytes(accountName, 200, true);
    }

    public static boolean validAssetDescription(byte[] description) {
        return TransactionUtil.validBytes(description, 200, true);
    }

    public static boolean validUrl(byte[] url) {
        return TransactionUtil.validBytes(url, 256, false);
    }

    public static boolean validAccountId(byte[] accountId) {
        return TransactionUtil.validReadableBytes(accountId, 32) && accountId.length >= 8;
    }

    public static boolean validAssetName(byte[] assetName) {
        return TransactionUtil.validReadableBytes(assetName, 32);
    }

    public static boolean validTokenAbbrName(byte[] abbrName) {
        return TransactionUtil.validReadableBytes(abbrName, 5);
    }

    private static boolean validBytes(byte[] bytes, int maxLength, boolean allowEmpty) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return allowEmpty;
        }
        return bytes.length <= maxLength;
    }

    private static boolean validReadableBytes(byte[] bytes, int maxLength) {
        if (ArrayUtils.isEmpty((byte[])bytes) || bytes.length > maxLength) {
            return false;
        }
        for (byte b : bytes) {
            if (b < 33) {
                return false;
            }
            if (b <= 126) continue;
            return false;
        }
        return true;
    }

    public static Sha256Hash getTransactionId(Protocol.Transaction transaction) {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray());
    }

    public static Protocol.Transaction.Result.contractResult getContractRet(Protocol.Transaction transaction) {
        if (transaction.getRetCount() <= 0) {
            return null;
        }
        return transaction.getRet(0).getContractRet();
    }

    public static long getCallTokenValue(Protocol.Transaction.Contract contract) {
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TriggerSmartContract: {
                    return ((SmartContractOuterClass.TriggerSmartContract)contractParameter.unpack(SmartContractOuterClass.TriggerSmartContract.class)).getCallTokenValue();
                }
                case CreateSmartContract: {
                    return ((SmartContractOuterClass.CreateSmartContract)contractParameter.unpack(SmartContractOuterClass.CreateSmartContract.class)).getCallTokenValue();
                }
            }
            return 0L;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0L;
        }
    }

    public static byte[] generateContractAddress(byte[] ownerAddress, byte[] txRawDataHash) {
        byte[] combined = new byte[txRawDataHash.length + ownerAddress.length];
        System.arraycopy(txRawDataHash, 0, combined, 0, txRawDataHash.length);
        System.arraycopy(ownerAddress, 0, combined, txRawDataHash.length, ownerAddress.length);
        return Hash.sha3omit12((byte[])combined);
    }

    public static byte[] generateContractAddress(byte[] transactionRootId, long nonce) {
        byte[] nonceBytes = Longs.toByteArray((long)nonce);
        byte[] combined = new byte[transactionRootId.length + nonceBytes.length];
        System.arraycopy(transactionRootId, 0, combined, 0, transactionRootId.length);
        System.arraycopy(nonceBytes, 0, combined, transactionRootId.length, nonceBytes.length);
        return Hash.sha3omit12((byte[])combined);
    }

    public static boolean checkPermissionOperations(Protocol.Permission permission, Protocol.Transaction.Contract contract) throws PermissionException {
        ByteString operations = permission.getOperations();
        if (operations.size() != 32) {
            throw new PermissionException("operations size must be 32");
        }
        int contractType = contract.getTypeValue();
        boolean b = (operations.byteAt(contractType / 8) & 1 << contractType % 8) != 0;
        return b;
    }

    public static String makeUpperCamelMethod(String originName) {
        return "get" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, originName).replace("_", "");
    }

    public GrpcAPI.TransactionSignWeight getTransactionSignWeight(Protocol.Transaction trx) {
        GrpcAPI.TransactionSignWeight.Builder tswBuilder = GrpcAPI.TransactionSignWeight.newBuilder();
        GrpcAPI.TransactionExtention.Builder trxExBuilder = GrpcAPI.TransactionExtention.newBuilder();
        trxExBuilder.setTransaction(trx);
        trxExBuilder.setTxid(ByteString.copyFrom((byte[])Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])trx.getRawData().toByteArray())));
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExBuilder.setResult(retBuilder);
        tswBuilder.setTransaction(trxExBuilder);
        GrpcAPI.TransactionSignWeight.Result.Builder resultBuilder = GrpcAPI.TransactionSignWeight.Result.newBuilder();
        if (trx.getRawData().getContractCount() == 0) {
            resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.OTHER_ERROR);
            resultBuilder.setMessage("Invalid transaction: no valid contract");
        } else {
            try {
                Protocol.Transaction.Contract contract = trx.getRawData().getContract(0);
                byte[] owner = TransactionCapsule.getOwner((Protocol.Transaction.Contract)contract);
                AccountCapsule account = this.chainBaseManager.getAccountStore().get(owner);
                if (Objects.isNull(account)) {
                    throw new PermissionException("Account does not exist!");
                }
                int permissionId = contract.getPermissionId();
                Protocol.Permission permission = account.getPermissionById(permissionId);
                if (permission == null) {
                    throw new PermissionException("Permission for this, does not exist!");
                }
                if (permissionId != 0) {
                    if (permission.getType() != Protocol.Permission.PermissionType.Active) {
                        throw new PermissionException("Permission type is wrong!");
                    }
                    if (!TransactionUtil.checkPermissionOperations(permission, contract)) {
                        throw new PermissionException("Permission denied!");
                    }
                }
                tswBuilder.setPermission(permission);
                if (trx.getSignatureCount() > 0) {
                    ArrayList approveList = new ArrayList();
                    long currentWeight = TransactionCapsule.checkWeight((Protocol.Permission)permission, (List)trx.getSignatureList(), (byte[])Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])trx.getRawData().toByteArray()), approveList);
                    tswBuilder.addAllApprovedList(approveList);
                    tswBuilder.setCurrentWeight(currentWeight);
                }
                if (tswBuilder.getCurrentWeight() >= permission.getThreshold()) {
                    resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.ENOUGH_PERMISSION);
                } else {
                    resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.NOT_ENOUGH_PERMISSION);
                }
            }
            catch (SignatureFormatException signEx) {
                resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.SIGNATURE_FORMAT_ERROR);
                resultBuilder.setMessage(signEx.getMessage());
            }
            catch (SignatureException signEx) {
                resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.COMPUTE_ADDRESS_ERROR);
                resultBuilder.setMessage(signEx.getMessage());
            }
            catch (PermissionException permEx) {
                resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.PERMISSION_ERROR);
                resultBuilder.setMessage(permEx.getMessage());
            }
            catch (Exception ex) {
                resultBuilder.setCode(GrpcAPI.TransactionSignWeight.Result.response_code.OTHER_ERROR);
                resultBuilder.setMessage(ex.getClass() + " : " + ex.getMessage());
            }
        }
        tswBuilder.setResult(resultBuilder);
        return tswBuilder.build();
    }

    public static long estimateConsumeBandWidthSize(DynamicPropertiesStore dps, long balance) {
        BalanceContract.DelegateResourceContract.Builder builder = dps.supportMaxDelegateLockPeriod() ? BalanceContract.DelegateResourceContract.newBuilder().setLock(true).setLockPeriod(dps.getMaxDelegateLockPeriod()).setBalance(balance) : BalanceContract.DelegateResourceContract.newBuilder().setLock(true).setBalance(balance);
        long builderSize = builder.build().getSerializedSize();
        BalanceContract.DelegateResourceContract.Builder builder2 = BalanceContract.DelegateResourceContract.newBuilder().setBalance(1000000L);
        long builder2Size = builder2.build().getSerializedSize();
        long addSize = Math.max(builderSize - builder2Size, 0L);
        return 275L + addSize;
    }
}

