/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.MarketOrderCapsule;
import org.tron.core.capsule.MarketOrderIdListCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.MarketUtils;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.MarketAccountStore;
import org.tron.core.store.MarketOrderStore;
import org.tron.core.store.MarketPairPriceToOrderStore;
import org.tron.core.store.MarketPairToPriceStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.MarketContract;

public class MarketCancelOrderActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private AccountStore accountStore;
    private DynamicPropertiesStore dynamicStore;
    private AssetIssueStore assetIssueStore;
    private MarketAccountStore marketAccountStore;
    private MarketOrderStore orderStore;
    private MarketPairToPriceStore pairToPriceStore;
    private MarketPairPriceToOrderStore pairPriceToOrderStore;

    public MarketCancelOrderActuator() {
        super(Protocol.Transaction.Contract.ContractType.MarketCancelOrderContract, MarketContract.MarketCancelOrderContract.class);
    }

    private void initStores() {
        this.accountStore = this.chainBaseManager.getAccountStore();
        this.dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        this.assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        this.marketAccountStore = this.chainBaseManager.getMarketAccountStore();
        this.orderStore = this.chainBaseManager.getMarketOrderStore();
        this.pairToPriceStore = this.chainBaseManager.getMarketPairToPriceStore();
        this.pairPriceToOrderStore = this.chainBaseManager.getMarketPairPriceToOrderStore();
    }

    public boolean execute(Object object) throws ContractExeException {
        this.initStores();
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            MarketContract.MarketCancelOrderContract contract = (MarketContract.MarketCancelOrderContract)this.any.unpack(MarketContract.MarketCancelOrderContract.class);
            AccountCapsule accountCapsule = this.accountStore.get(contract.getOwnerAddress().toByteArray());
            byte[] orderId = contract.getOrderId().toByteArray();
            MarketOrderCapsule orderCapsule = this.orderStore.get(orderId);
            accountCapsule.setBalance(accountCapsule.getBalance() - fee);
            if (this.dynamicStore.supportBlackHoleOptimization()) {
                this.dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)this.accountStore, (AccountCapsule)this.accountStore.getBlackhole(), (long)fee);
            }
            MarketUtils.returnSellTokenRemain((MarketOrderCapsule)orderCapsule, (AccountCapsule)accountCapsule, (DynamicPropertiesStore)this.dynamicStore, (AssetIssueStore)this.assetIssueStore);
            MarketUtils.updateOrderState((MarketOrderCapsule)orderCapsule, (Protocol.MarketOrder.State)Protocol.MarketOrder.State.CANCELED, (MarketAccountStore)this.marketAccountStore);
            this.accountStore.put(orderCapsule.getOwnerAddress().toByteArray(), accountCapsule);
            this.orderStore.put(orderCapsule.getID().toByteArray(), (ProtoCapsule)orderCapsule);
            byte[] pairPriceKey = MarketUtils.createPairPriceKey((byte[])orderCapsule.getSellTokenId(), (byte[])orderCapsule.getBuyTokenId(), (long)orderCapsule.getSellTokenQuantity(), (long)orderCapsule.getBuyTokenQuantity());
            MarketOrderIdListCapsule orderIdListCapsule = this.pairPriceToOrderStore.get(pairPriceKey);
            orderIdListCapsule.removeOrder(orderCapsule, this.orderStore, pairPriceKey, this.pairPriceToOrderStore);
            if (orderIdListCapsule.isOrderEmpty()) {
                this.pairPriceToOrderStore.delete(pairPriceKey);
                byte[] makerPair = MarketUtils.createPairKey((byte[])orderCapsule.getSellTokenId(), (byte[])orderCapsule.getBuyTokenId());
                long remainCount = this.pairToPriceStore.getPriceNum(makerPair) - 1L;
                if (remainCount == 0L) {
                    this.pairToPriceStore.delete(makerPair);
                } else {
                    this.pairToPriceStore.setPriceNum(makerPair, remainCount);
                }
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        MarketOrderCapsule marketOrderCapsule;
        MarketContract.MarketCancelOrderContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        this.initStores();
        if (!this.any.is(MarketContract.MarketCancelOrderContract.class)) {
            throw new ContractValidateException("contract type error,expected type [MarketCancelOrderContract],real type[" + this.any.getClass() + "]");
        }
        if (!this.dynamicStore.supportAllowMarketTransaction()) {
            throw new ContractValidateException("Not support Market Transaction, need to be opened by the committee");
        }
        try {
            contract = (MarketContract.MarketCancelOrderContract)this.any.unpack(MarketContract.MarketCancelOrderContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        ByteString orderId = contract.getOrderId();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerAccount = this.accountStore.get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Account does not exist!");
        }
        try {
            marketOrderCapsule = this.orderStore.get(orderId.toByteArray());
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("orderId not exists");
        }
        if (!marketOrderCapsule.isActive()) {
            throw new ContractValidateException("Order is not active!");
        }
        if (!marketOrderCapsule.getOwnerAddress().equals((Object)ownerAccount.getAddress())) {
            throw new ContractValidateException("Order does not belong to the account!");
        }
        long fee = this.calcFee();
        if (ownerAccount.getBalance() < fee) {
            throw new ContractValidateException("No enough balance !");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.AssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.AssetIssueContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.dynamicStore.getMarketCancelFee();
    }
}

